# 画面設計書 197-クレジットノート一覧

## 概要

本ドキュメントは、Invoices（請求書）モジュールにおけるクレジットノート一覧画面（ListCreditNotes）の設計仕様を記載するものです。顧客向けのクレジットノート（返金・貸方伝票）を一覧表示し、管理を行う画面です。

### 本画面の処理概要

**業務上の目的・背景**：顧客への返金処理や請求書の修正に伴うクレジットノートを一元管理するために必要な画面です。請求書の取り消しや返金処理を追跡できます。

**画面へのアクセス方法**：メインナビゲーションから「請求書」モジュールを選択し、「顧客」クラスター内の「クレジットノート」メニューをクリックしてアクセスします。URLは `/invoices/customer/credit-notes` です。

**主要な操作・処理内容**：
1. クレジットノートデータの一覧表示と検索
2. プリセットビューによるフィルタリング
3. クレジットノートレコードの詳細表示・編集・削除
4. 新規クレジットノートの作成
5. 一括削除操作

**画面遷移**：
- この画面から遷移できる画面：クレジットノート作成画面、クレジットノート編集画面、クレジットノート詳細画面
- この画面に遷移してくる画面：顧客モジュールのメニュー、ダッシュボード

**権限による表示制御**：請求書モジュールへのアクセス権限を持つユーザーのみが表示可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-CU-005 | クレジットノート一覧 | 主機能 | クレジットノートデータの一覧表示 |
| FN-ACC-CN-001 | クレジットノート一覧 | API連携 | 会計モジュールのクレジットノートリソース継承 |

## 画面種別

一覧

## URL/ルーティング

`/invoices/customer/credit-notes`

## 画面構成

- **ヘッダーアクション**：新規作成ボタン（CreateAction）
- **プリセットビュー**：請求書リソースから継承されたビュー
- **テーブル**：クレジットノートデータ一覧（請求書リソースから継承されたテーブル構造）
- **フィルター**：番号、請求書元、参照、パートナー名、請求日、支払期限、作成日、更新日
- **グループ化**：名前、パートナー名、請求日、確認済み、日付、支払期限、請求元、担当者、通貨、作成日、更新日

## 表示項目

| 項目名 | 表示形式 | ソート | 検索 | 説明 |
|--------|----------|--------|------|------|
| name | テキスト | 可 | 可 | クレジットノート番号 |
| state | バッジ | 可 | - | ステータス |
| invoice_partner_display_name | テキスト | 可 | 可 | 顧客名 |
| invoice_date | 日付 | 可 | - | 発行日 |
| invoice_date_due | 日付 | 可 | - | 期限日 |
| amount_untaxed_in_currency_signed | 通貨 | 可 | 可 | 税抜金額 |
| amount_tax_signed | 通貨 | 可 | 可 | 税額 |
| amount_total_in_currency_signed | 通貨 | 可 | 可 | 合計金額 |
| amount_residual_signed | 通貨 | 可 | 可 | 残高 |
| payment_state | バッジ | 可 | 可 | 支払状態 |

## イベント仕様

### 1-新規作成ボタン押下

CreateActionにより新規クレジットノート作成画面に遷移します。

### 2-行アクション

- **表示**：ViewActionで詳細画面へ遷移
- **編集**：EditActionで編集画面へ遷移
- **削除**：DeleteActionで削除（確認ダイアログあり）

### 3-一括削除

DeleteBulkActionにより選択した複数のクレジットノートを一括削除します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除ボタン押下 | account_moves | DELETE | クレジットノートレコードの削除 |
| 一括削除 | account_moves | DELETE | 複数クレジットノートレコードの削除 |

### テーブル別更新項目詳細

#### account_moves

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE id = {選択レコードID} AND move_type = 'out_refund' | 顧客向けクレジットノートのみ対象 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| delete.success.title | 成功 | 削除が完了しました | 削除成功時 |
| delete.success.body | 成功 | レコードが正常に削除されました | 削除成功時 |

## 例外処理

| 例外条件 | 対応処理 | 表示メッセージ |
|---------|---------|--------------|
| データが見つからない | 空の一覧を表示 | - |
| 削除権限不足 | 操作を拒否 | 権限がありません |

## 備考

- 本画面はBaseCreditNoteResource::ListCreditNotesを継承しており、クレジットノート一覧の基本機能を継承しています
- CreditNotesResourceはBaseCreditNoteResourceを継承し、Customerクラスターに属します
- モデルはCreditNote::classを使用し、move_typeがOUT_REFUNDのレコードが表示されます
- navigationSortは2で、顧客メニュー内で請求書の次に表示されます
- ProductRepeaterに商品を開くアクション（openProduct）が追加されています
