# 画面設計書 198-顧客支払一覧

## 概要

本ドキュメントは、Invoices（請求書）モジュールにおける顧客支払一覧画面（ListPayments）の設計仕様を記載するものです。顧客からの支払（入金）を一覧表示し、支払の管理・追跡を行う画面です。

### 本画面の処理概要

**業務上の目的・背景**：顧客からの支払（入金）を一元管理し、売掛金の回収状況を追跡するために必要な画面です。支払状態の管理、支払方法の追跡が可能です。

**画面へのアクセス方法**：メインナビゲーションから「請求書」モジュールを選択し、「顧客」クラスター内の「支払」メニューをクリックしてアクセスします。URLは `/invoices/customer/payments` です。

**主要な操作・処理内容**：
1. 顧客支払データの一覧表示と検索
2. プリセットビューによる支払データのフィルタリング（顧客支払がデフォルト）
3. 支払レコードの詳細表示・編集・削除
4. 新規支払の作成
5. 一括削除操作

**画面遷移**：
- この画面から遷移できる画面：顧客支払作成画面、顧客支払編集画面、顧客支払詳細画面
- この画面に遷移してくる画面：顧客モジュールのメニュー、ダッシュボード

**権限による表示制御**：請求書モジュールへのアクセス権限を持つユーザーのみが表示可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-CU-006 | 顧客支払一覧 | 主機能 | 支払データの一覧表示 |
| FN-ACC-PAY-001 | 支払一覧 | API連携 | 会計モジュールの支払リソース継承 |

## 画面種別

一覧

## URL/ルーティング

`/invoices/customer/payments`

## 画面構成

- **ヘッダーアクション**：新規作成ボタン（CreateAction）
- **プリセットビュー**：顧客支払（デフォルト・お気に入り）、その他（継承元から）
- **テーブル**：支払データ一覧
- **フィルター**：会社、顧客銀行口座、内部振替ペア、支払方法ライン、支払方法、通貨、パートナー、作成日、更新日
- **グループ化**：名前、会社、支払方法ライン、パートナー、支払方法、パートナー銀行口座、内部振替ペア、作成日、更新日

## 表示項目

| 項目名 | 表示形式 | ソート | 検索 | 説明 |
|--------|----------|--------|------|------|
| name | テキスト | 可 | 可 | 支払番号 |
| company.name | テキスト | 可 | - | 会社名 |
| partnerBank.account_holder_name | テキスト | 可 | 可 | 銀行口座名義 |
| pairedInternalTransferPayment.name | テキスト | 可 | - | 内部振替ペア |
| paymentMethodLine.name | テキスト | 可 | - | 支払方法ライン |
| paymentMethod.name | テキスト | 可 | - | 支払方法 |
| currency.name | テキスト | 可 | - | 通貨 |
| partner.name | テキスト | 可 | - | パートナー（デフォルト非表示） |
| outstandingAccount.name | テキスト | 可 | - | 未払勘定（デフォルト非表示） |
| destinationAccount.name | テキスト | 可 | - | 入金先勘定（デフォルト非表示） |
| createdBy.name | テキスト | 可 | - | 作成者（デフォルト非表示） |
| paymentTransaction.name | テキスト | 可 | - | 支払トランザクション（デフォルト非表示） |

## プリセットビュー詳細

| ビュー名 | アイコン | フィルタ条件 | お気に入り |
|---------|---------|-------------|----------|
| 顧客支払 | heroicon-s-banknotes | partner_type IN ('customer', 'company') | デフォルト、お気に入り |

## イベント仕様

### 1-プリセットビュー切替

プリセットビューを切り替えると、支払データに対してフィルタリングが適用されます。顧客支払ビューでは、partner_typeがcustomerまたはcompanyの支払のみが表示されます。

### 2-新規作成ボタン押下

CreateActionにより新規支払作成画面に遷移します。

### 3-行アクション

- **表示**：ViewActionで詳細画面へ遷移
- **編集**：EditActionで編集画面へ遷移
- **削除**：DeleteActionで削除（確認ダイアログあり）

### 4-一括削除

DeleteBulkActionにより選択した複数の支払を一括削除します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除ボタン押下 | account_payments | DELETE | 支払レコードの削除 |
| 一括削除 | account_payments | DELETE | 複数支払レコードの削除 |

### テーブル別更新項目詳細

#### account_payments

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE id = {選択レコードID} | 支払削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| delete.notification.title | 成功 | 削除が完了しました | 削除成功時 |
| delete.notification.body | 成功 | レコードが正常に削除されました | 削除成功時 |
| bulk-actions.delete.notification.title | 成功 | 一括削除が完了しました | 一括削除成功時 |
| bulk-actions.delete.notification.body | 成功 | 選択したレコードが正常に削除されました | 一括削除成功時 |

## 例外処理

| 例外条件 | 対応処理 | 表示メッセージ |
|---------|---------|--------------|
| データが見つからない | 空の一覧を表示 | - |
| 削除権限不足 | 操作を拒否 | 権限がありません |

## 備考

- 本画面はBaseListPaymentsを継承しており、会計モジュールの支払一覧の基本機能を継承しています
- PaymentsResourceはBasePaymentsResourceを継承し、Customerクラスターに属します
- モデルはPayment::classを使用します
- navigationSortは4で、顧客メニュー内で4番目に表示されます
- 顧客支払ビューがデフォルトで設定され、お気に入りとしてマークされています
- partner_typeが'customer'または'company'の支払のみが顧客支払ビューに表示されます
