# 画面設計書 2-勘定科目作成

## 概要

本ドキュメントは、Aureus ERPシステムの会計モジュールにおける勘定科目作成画面の設計仕様を記載したものです。

### 本画面の処理概要

この画面は、新規の勘定科目を登録するためのフォーム画面です。勘定科目コード、名称、科目タイプなどの必須情報と、税設定やタグなどの付加情報を入力し、データベースに新規レコードを作成します。

**業務上の目的・背景**：企業の会計処理において、新たな取引分類が必要になった場合や、組織変更に伴う勘定体系の見直し時に、新規勘定科目の追加が必要となります。本画面により、経理担当者は適切な属性を持つ勘定科目を簡単に追加でき、会計システムの柔軟な運用を可能にします。

**画面へのアクセス方法**：勘定科目一覧画面のヘッダーにある「新規作成」ボタン（+アイコン）をクリックしてアクセスします。

**主要な操作・処理内容**：
1. 勘定科目コード（code）の入力
2. 勘定科目名（name）の入力
3. 科目タイプ（account_type）の選択
4. デフォルト税（taxes）の設定（オプション）
5. タグ（tags）の設定（オプション）
6. 仕訳帳（journals）の関連付け（オプション）
7. 通貨（currency）の選択（オプション）
8. 各種フラグ（非推奨、消込対象、非取引）の設定
9. 保存ボタンによるデータ登録

**画面遷移**：
- 本画面から遷移可能：勘定科目詳細画面（保存成功時）
- 本画面への遷移元：勘定科目一覧画面

**権限による表示制御**：勘定科目の作成権限を持つユーザーのみアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-019 | 勘定科目作成 | 主機能 | 新規勘定科目の作成 |
| FN-ACC-018 | 勘定科目一覧 | 遷移元機能 | 一覧画面からの遷移 |

## 画面種別

登録

## URL/ルーティング

`/accounts/accounts/create`

## 画面構成

- フォームセクション：勘定科目情報入力エリア
  - 基本情報：コード、名称（2カラムレイアウト）
  - 会計設定フィールドセット：科目タイプ、税、タグ、仕訳帳、通貨、各種トグル

## 入出力項目

| No | 項目名 | 物理名 | 型 | 必須 | 初期値 | 説明 | 入力形式 |
|----|--------|--------|-----|------|--------|------|---------|
| 1 | コード | code | string | ○ | なし | 勘定科目コード | テキスト入力（最大255文字） |
| 2 | 勘定科目名 | name | string | ○ | なし | 勘定科目の名称 | テキスト入力（最大255文字） |
| 3 | 科目タイプ | account_type | enum | ○ | なし | 勘定科目の種類 | セレクトボックス（AccountType選択肢） |
| 4 | デフォルト税 | invoices_account_tax | array | - | なし | 関連する税 | 複数選択セレクト |
| 5 | タグ | invoices_account_account_tags | array | - | なし | 勘定科目タグ | 複数選択セレクト |
| 6 | 仕訳帳 | invoices_account_journals | array | - | なし | 関連仕訳帳 | 複数選択セレクト |
| 7 | 通貨 | currency_id | integer | - | なし | 使用通貨 | セレクトボックス |
| 8 | 非推奨 | deprecated | boolean | - | false | 非推奨フラグ | トグルスイッチ |
| 9 | 消込対象 | reconcile | boolean | - | false | 消込可能フラグ | トグルスイッチ |
| 10 | 非取引 | non_trade | boolean | - | false | 非取引フラグ | トグルスイッチ |

## 表示項目

該当なし（登録画面のため）

## イベント仕様

### 1-科目タイプ変更

科目タイプを変更すると、リアクティブに画面が更新されます。科目タイプが「OFF_BALANCE（オフバランス）」の場合、デフォルト税の入力欄が非表示になります。

### 2-保存ボタン押下

フォームのバリデーションを実行し、成功した場合はデータベースにレコードを作成します。作成成功後、勘定科目詳細画面（ViewAccount）へ自動遷移し、成功通知が表示されます。

### 3-キャンセル

フォーム入力をキャンセルして一覧画面に戻ります。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | accounts_accounts | INSERT | 新規勘定科目レコードを作成 |
| 保存ボタン押下 | accounts_account_taxes | INSERT | 税との関連を作成 |
| 保存ボタン押下 | accounts_account_account_tags | INSERT | タグとの関連を作成 |
| 保存ボタン押下 | accounts_account_journals | INSERT | 仕訳帳との関連を作成 |

### テーブル別更新項目詳細

#### accounts_accounts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | code | フォーム入力値 | 必須 |
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | account_type | フォーム選択値 | 必須、AccountType Enum |
| INSERT | currency_id | フォーム選択値 | 任意 |
| INSERT | deprecated | フォーム入力値 | デフォルトfalse |
| INSERT | reconcile | フォーム入力値 | デフォルトfalse |
| INSERT | non_trade | フォーム入力値 | デフォルトfalse |
| INSERT | creator_id | ログインユーザーID | 自動設定 |

## メッセージ仕様

| メッセージID | メッセージ種別 | メッセージ内容 | 表示条件 |
|-------------|--------------|--------------|---------|
| MSG-001 | 成功 | 勘定科目が作成されました | 保存成功時 |
| MSG-002 | エラー | 必須項目を入力してください | バリデーションエラー時 |
| MSG-003 | エラー | コードは一意である必要があります | コード重複時 |

## 例外処理

| 例外条件 | 処理内容 | 表示メッセージ |
|---------|---------|--------------|
| 必須項目未入力 | フォームエラー表示 | 必須項目を入力してください |
| データベースエラー | エラー通知表示 | データの保存に失敗しました |
| 権限不足 | アクセス拒否 | この操作を行う権限がありません |

## 備考

- 本画面はFilament PHPのCreateRecordを継承して実装されています
- 保存成功後は自動的に詳細画面（ViewAccount）へリダイレクトされます
- 税選択欄は科目タイプが「OFF_BALANCE」以外の場合のみ表示されます
- 複数選択フィールド（税、タグ、仕訳帳）はプリロード・検索機能付きです
