# 画面設計書 20-財務ポジション作成

## 概要

本ドキュメントは、Aureus ERPシステムにおける「財務ポジション作成」画面の設計仕様を定義するものである。

### 本画面の処理概要

財務ポジション作成画面は、会計モジュールにおいて新しい財務ポジション（税務ポジション）設定を登録するための画面である。

**業務上の目的・背景**：国際取引や特定の地域条件に基づく税率適用ルールを新規に定義する必要がある場合に使用する。例えば、特定の国への輸出時に免税処理を適用する、EU域内取引でリバースチャージを適用するなど、複雑な税務要件に対応するための設定を作成する。

**画面へのアクセス方法**：財務ポジション一覧画面のヘッダーにある「作成」ボタンをクリックしてアクセスする。URL直接入力でもアクセス可能。

**主要な操作・処理内容**：
1. 財務ポジション設定の名前を入力
2. 外国VAT番号を入力
3. 適用対象の国・国グループを選択
4. 郵便番号範囲（開始・終了）を入力
5. 自動検出フラグを設定
6. 備考を入力
7. 保存ボタンで登録を確定

**画面遷移**：
- 保存成功時：財務ポジション詳細画面（ViewFiscalPosition）へ自動遷移
- キャンセル時：財務ポジション一覧画面へ戻る

**権限による表示制御**：Filament Resourceの標準的な権限管理に従い、作成権限を持つユーザーのみが画面にアクセス可能。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| SCR-ACC-020 | 財務ポジション管理 | 主機能 | 財務ポジション設定の新規作成 |
| FN-ACC-035 | 財務ポジション管理 | 主機能 | 作成処理 |

## 画面種別

登録

## URL/ルーティング

`/admin/accounts/fiscal-positions/create`

## 画面構成

1. **フォームセクション**
   - Sectionコンポーネント内にフォームフィールドを配置

2. **入力フィールドエリア（2カラムレイアウト）**
   - 名前（TextInput）
   - 外国VAT（TextInput）
   - 国（Select - リレーション）
   - 国グループ（Select - リレーション）
   - 郵便番号（開始）（TextInput）
   - 郵便番号（終了）（TextInput）
   - 自動検出（Toggle）

3. **備考エリア**
   - 備考（RichEditor）- フルワイド

4. **アクションエリア**
   - 保存ボタン（Filament標準）
   - キャンセルボタン（Filament標準）

## 入出力項目

| 項目名 | 物理名 | データ型 | 必須 | 初期値 | 説明 |
|--------|--------|----------|------|--------|------|
| 名前 | name | string | 必須 | なし | 財務ポジション設定の名称 |
| 外国VAT | foreign_vat | string | 必須 | なし | 外国VAT番号 |
| 国 | country_id | integer | 任意 | なし | 適用対象国ID（リレーション） |
| 国グループ | country_group_id | integer | 任意 | なし | 適用対象国グループID（リレーション） |
| 郵便番号（開始） | zip_from | string | 必須 | なし | 適用郵便番号範囲（開始） |
| 郵便番号（終了） | zip_to | string | 必須 | なし | 適用郵便番号範囲（終了） |
| 自動検出 | auto_reply | boolean | 任意 | false | 自動検出フラグ |
| 備考 | notes | text | 任意 | なし | 備考・メモ |

## 表示項目

該当なし（登録画面のため出力専用項目なし）

## イベント仕様

### 1-保存ボタン押下

フォームの入力内容をバリデーション後、データベースに新規レコードを作成する。作成成功時は成功通知を表示し、詳細画面へ遷移する。

### 2-キャンセル

入力内容を破棄し、一覧画面へ戻る。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | accounts_fiscal_positions | INSERT | 新規レコードの作成 |

### テーブル別更新項目詳細

#### accounts_fiscal_positions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | foreign_vat | フォーム入力値 | 必須 |
| INSERT | country_id | フォーム選択値 | nullable |
| INSERT | country_group_id | フォーム選択値 | nullable |
| INSERT | zip_from | フォーム入力値 | 必須 |
| INSERT | zip_to | フォーム入力値 | 必須 |
| INSERT | auto_reply | フォーム選択値 | デフォルトfalse |
| INSERT | notes | フォーム入力値 | nullable |
| INSERT | company_id | ログインユーザーのデフォルト会社ID | mutateFormDataBeforeCreateで設定 |
| INSERT | creator_id | ログインユーザーID | mutateFormDataBeforeCreateで設定 |
| INSERT | created_at | 現在日時 | 自動設定 |
| INSERT | updated_at | 現在日時 | 自動設定 |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|--------------|---------|
| 成功 | 作成成功通知（タイトル・本文） | レコード作成成功時 |
| エラー | バリデーションエラー | 必須項目未入力時 |

## 例外処理

| 例外条件 | 処理内容 |
|---------|---------|
| バリデーションエラー | エラーメッセージを該当フィールドに表示 |
| データベースエラー | Filament標準のエラー処理 |
| 権限不足 | アクセス拒否エラー表示 |

## 備考

- company_idとcreator_idは`mutateFormDataBeforeCreate`メソッドで現在ログインユーザーの情報から自動設定される
- 国と国グループはSelectコンポーネントでリレーションから選択（searchable、preload）
- 自動検出（auto_reply）はToggleコンポーネントでinline(false)表示
- 備考（notes）はRichEditorコンポーネントでリッチテキスト入力が可能
- 保存成功後のリダイレクト先は詳細画面（view）
- 作成後、財務ポジション税マッピングの管理画面（ManageFiscalPositionTax）でさらに詳細な税率マッピングを設定可能
