# 画面設計書 200-税設定一覧

## 概要

本ドキュメントは、Invoices（請求書）モジュールにおける税設定一覧画面（ListTaxes）の設計仕様を記載するものです。税金設定を一覧表示し、税の管理を行う画面です。

### 本画面の処理概要

**業務上の目的・背景**：請求書で使用する税金（消費税、付加価値税等）を管理するために必要な画面です。税率、税タイプ、計算方法などを設定できます。

**画面へのアクセス方法**：メインナビゲーションから「請求書」モジュールを選択し、「設定」クラスター内の「税」メニューをクリックしてアクセスします。URLは `/invoices/configuration/taxes` です。

**主要な操作・処理内容**：
1. 税設定データの一覧表示と検索
2. 税設定レコードの詳細表示・編集・削除
3. 新規税設定の作成
4. 一括削除操作
5. 並び替え操作

**画面遷移**：
- この画面から遷移できる画面：税設定作成画面、税設定編集画面、税設定詳細画面、請求書用配分管理画面、返金用配分管理画面
- この画面に遷移してくる画面：設定モジュールのメニュー、ダッシュボード

**権限による表示制御**：請求書モジュール設定へのアクセス権限を持つユーザーのみが表示可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-CF-001 | 税設定一覧 | 主機能 | 税設定データの一覧表示 |
| FN-ACC-TAX-001 | 税一覧 | API連携 | 会計モジュールの税リソース継承 |

## 画面種別

一覧

## URL/ルーティング

`/invoices/configuration/taxes`

## 画面構成

- **ヘッダーアクション**：新規作成ボタン（CreateAction）
- **テーブル**：税設定データ一覧（並び替え可能）
- **カラムマネージャ**：表示カラムのカスタマイズ
- **フィルター**：なし（テーブルのみ）
- **グループ化**：名前、会社、税グループ、国、作成者、税タイプ、税スコープ、金額タイプ

## 表示項目

| 項目名 | 表示形式 | ソート | 検索 | 説明 |
|--------|----------|--------|------|------|
| name | テキスト | 可 | 可 | 税名 |
| company.name | テキスト | 可 | - | 会社名 |
| taxGroup.name | テキスト | 可 | 可 | 税グループ |
| country.name | テキスト | 可 | - | 国（デフォルト非表示） |
| type_tax_use | テキスト | 可 | - | 税タイプ（販売/仕入/なし） |
| tax_scope | テキスト | 可 | - | 税スコープ（デフォルト非表示） |
| amount_type | テキスト | 可 | - | 金額タイプ（デフォルト非表示） |
| invoice_label | テキスト | 可 | - | 請求書ラベル |
| tax_exigibility | テキスト | 可 | - | 税徴収時期（デフォルト非表示） |
| price_include_override | テキスト | 可 | - | 価格込み設定（デフォルト非表示） |
| amount | 数値 | 可 | - | 税率（デフォルト非表示） |
| is_active | アイコン | 可 | - | 有効/無効 |
| include_base_amount | アイコン | 可 | - | 基本金額に含む（デフォルト非表示） |
| is_base_affected | アイコン | 可 | - | 基本金額影響（デフォルト非表示） |

## フォーム項目

| 項目名 | 型 | 必須 | バリデーション | 説明 |
|--------|-----|------|---------------|------|
| name | text | 是 | required | 税名 |
| type_tax_use | select | 是 | required | 税タイプ（販売/仕入/なし） |
| amount_type | select | 是 | required | 税計算方法 |
| tax_scope | select | - | - | 税スコープ |
| is_active | toggle | - | - | 有効/無効 |
| amount | number | 是 | min:0, max:99999999999 | 税率（%） |
| invoice_label | text | - | - | 請求書ラベル |
| tax_group_id | select | 是 | required | 税グループ |
| country_id | select | - | - | 国 |
| price_include_override | select | - | - | 価格込み設定 |
| include_base_amount | toggle | - | - | 基本金額に含む |
| is_base_affected | toggle | - | - | 基本金額に影響される |
| description | richtext | - | - | 説明 |
| invoice_legal_notes | richtext | - | - | 法的注記 |

## イベント仕様

### 1-新規作成ボタン押下

CreateActionにより新規税設定作成画面に遷移します。

### 2-行アクション

- **編集**：EditActionで編集画面へ遷移
- **表示**：ViewActionで詳細画面へ遷移
- **削除**：DeleteActionで削除（確認ダイアログあり）

### 3-一括削除

DeleteBulkActionにより選択した複数の税設定を一括削除します。

### 4-並び替え

テーブル行をドラッグ&ドロップで並び替え可能です（sortカラムで降順ソート）。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除ボタン押下 | account_taxes | DELETE | 税設定レコードの削除 |
| 一括削除 | account_taxes | DELETE | 複数税設定レコードの削除 |
| 並び替え | account_taxes | UPDATE | sortカラムの更新 |

### テーブル別更新項目詳細

#### account_taxes

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE id = {選択レコードID} | 税設定削除 |
| UPDATE | sort | 新しい順序値 | 並び替え時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| delete.notification.success.title | 成功 | 削除が完了しました | 削除成功時 |
| delete.notification.success.body | 成功 | 税設定が正常に削除されました | 削除成功時 |
| delete.notification.error.title | エラー | 削除に失敗しました | 関連データ存在時 |
| delete.notification.error.body | エラー | 関連するデータが存在するため削除できません | 関連データ存在時 |
| bulk-actions.delete.notification.success.title | 成功 | 一括削除が完了しました | 一括削除成功時 |
| bulk-actions.delete.notification.success.body | 成功 | 選択した税設定が正常に削除されました | 一括削除成功時 |
| bulk-actions.delete.notification.error.title | エラー | 一括削除に失敗しました | 関連データ存在時 |
| bulk-actions.delete.notification.error.body | エラー | 関連するデータが存在するため削除できません | 関連データ存在時 |

## 例外処理

| 例外条件 | 対応処理 | 表示メッセージ |
|---------|---------|--------------|
| データが見つからない | 空の一覧を表示 | - |
| 削除時に関連データ存在 | 削除を拒否 | delete.notification.error |
| QueryException発生時 | 操作をキャンセル | エラー通知を表示 |

## 備考

- 本画面はBaseTaxResourceのListTaxesを継承しており、会計モジュールの税一覧の基本機能を継承しています
- TaxResourceはBaseTaxResourceを継承し、Configurationクラスターに属します
- モデルはTax::classを使用します
- サブナビゲーション位置はStartに設定されています
- 並び替え機能（reorderable）でsortカラムを降順で管理します
- カラムマネージャにより2列でカラム選択が可能です
- 削除時にQueryException（外部キー制約違反等）が発生した場合はエラー通知を表示します
- 税グループの作成フォームがインライン（createOptionForm）で提供されています
- 高度なオプション（請求書ラベル、税グループ、国、価格込み設定、基本金額設定）がフィールドセットで提供されています
