# 画面設計書 201-税グループ一覧

## 概要

本ドキュメントは、Invoicesモジュールにおける税グループ一覧画面の設計仕様を定義します。

### 本画面の処理概要

税グループ一覧画面は、請求書処理において適用される税グループ（消費税や付加価値税などの税種別をグループ化した設定）を管理するための画面です。

**業務上の目的・背景**：ERPシステムにおいて、国や地域によって異なる税制度に対応するため、複数の税を論理的にグループ化して管理する必要があります。税グループは請求書作成時に適用される税計算の基礎となる重要な設定であり、正確な税務処理を実現するために不可欠です。会計部門や経理担当者が税制度の変更に迅速に対応できるよう、税グループの一元管理機能を提供します。

**画面へのアクセス方法**：サイドメニューから「Settings」クラスターを選択し、「Configuration」セクション内の「Tax Groups」（税グループ）ナビゲーションリンクをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 税グループの一覧表示・検索・ソート
2. 税グループの新規作成（作成画面への遷移）
3. 税グループの詳細表示・編集・削除
4. 一括削除操作
5. グループ化表示（名前、会社、国、作成者、作成日、更新日別）

**画面遷移**：
- 遷移元：ダッシュボード、Invoicesモジュールトップ、設定メニュー
- 遷移先：税グループ作成画面、税グループ詳細画面、税グループ編集画面

**権限による表示制御**：FilamentShieldによる権限管理が適用されており、税グループリソースへのアクセス権限を持つユーザーのみが本画面を利用可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-CF-002 | 税グループ管理 | 主機能 | 税グループの一覧表示、CRUD操作 |
| FN-ACC-022 | 税金グループ管理 | 補助機能 | Accountsモジュールの基底機能を継承 |

## 画面種別

一覧画面（ListRecords）

## URL/ルーティング

`/invoices/configuration/tax-groups`

## 画面構成

- **ヘッダーセクション**
  - 画面タイトル：「Tax Groups」
  - 新規作成ボタン（CreateAction）：プラスアイコン付き

- **テーブルセクション**
  - データテーブル：税グループ一覧
  - グループ化機能
  - 検索・ソート機能
  - レコードアクション（表示・編集・削除）
  - 一括アクション（一括削除）

## 入出力項目

本画面は一覧表示画面のため、直接の入力項目はありません。フィルタリング条件として検索キーワードが入力可能です。

## 表示項目

| 項目名 | 物理名 | 型 | 説明 | ソート | 検索 |
|--------|--------|-----|------|--------|------|
| 会社 | company.name | テキスト | 所属会社名 | 可 | 不可 |
| 国 | country.name | テキスト | 適用国名 | 可 | 不可 |
| 作成者 | createdBy.name | テキスト | レコード作成者名 | 可 | 不可 |
| 名前 | name | テキスト | 税グループ名 | 不可 | 可 |
| 小計表示順 | preceding_subtotal | テキスト | 請求書上での小計前表示設定 | 不可 | 可 |
| 作成日時 | created_at | 日時 | レコード作成日時 | 可 | 不可 |
| 更新日時 | updated_at | 日時 | レコード更新日時 | 可 | 不可 |

※作成日時・更新日時はデフォルトで非表示（トグル可能）

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの新規作成ボタン（CreateAction）をクリックすると、税グループ作成画面（`/invoices/configuration/tax-groups/create`）に遷移します。

### 2-表示アクション

テーブル行の表示アイコンをクリックすると、該当する税グループの詳細画面（`/invoices/configuration/tax-groups/{record}`）に遷移します。

### 3-編集アクション

テーブル行の編集アイコンをクリックすると、該当する税グループの編集画面（`/invoices/configuration/tax-groups/{record}/edit`）に遷移します。

### 4-削除アクション

テーブル行の削除アイコンをクリックすると、確認ダイアログが表示され、確認後に該当レコードを論理削除します。削除成功時には成功通知、失敗時（外部キー制約違反など）にはエラー通知が表示されます。

### 5-一括削除アクション

チェックボックスで複数レコードを選択し、一括削除ボタンをクリックすると、選択されたすべてのレコードを削除します。

### 6-グループ化切替

グループ化オプションを選択すると、選択した項目（名前、会社、国、作成者、作成日、更新日）でレコードをグループ化して表示します。グループは折りたたみ可能です。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | accounts_tax_groups | SELECT | 税グループ一覧を取得 |
| 削除アクション | accounts_tax_groups | DELETE | 指定レコードを削除 |
| 一括削除 | accounts_tax_groups | DELETE | 選択した複数レコードを削除 |

### テーブル別更新項目詳細

#### accounts_tax_groups

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | - | 全件または検索条件に合致するレコード | 関連テーブル（company, country, createdBy）をJOIN |
| DELETE | - | 指定されたID | 物理削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| delete.success.title | 成功 | 削除成功タイトル | 削除成功時 |
| delete.success.body | 成功 | 削除成功メッセージ | 削除成功時 |
| delete.error.title | エラー | 削除失敗タイトル | 削除失敗時（外部キー制約など） |
| delete.error.body | エラー | 削除失敗メッセージ | 削除失敗時 |
| bulk-delete.success.title | 成功 | 一括削除成功タイトル | 一括削除成功時 |
| bulk-delete.success.body | 成功 | 一括削除成功メッセージ | 一括削除成功時 |
| bulk-delete.error.title | エラー | 一括削除失敗タイトル | 一括削除失敗時 |
| bulk-delete.error.body | エラー | 一括削除失敗メッセージ | 一括削除失敗時 |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| データベース接続エラー | システムエラー画面を表示 |
| 削除時の外部キー制約違反 | エラー通知を表示し、削除をキャンセル |
| 権限不足 | アクセス拒否画面を表示（FilamentShield） |
| レコードが存在しない | 404エラー画面を表示 |

## 備考

- 本画面はAccountsモジュールのTaxGroupResourceを継承しており、基本的な機能はBaseクラスから提供されています。
- 税グループはInvoicesモジュールのConfigurationクラスターに属しています。
- 国際化対応として、ラベルやメッセージはすべて多言語リソースファイル（`invoices::filament/clusters/configurations/resources/tax-group`）から取得されます。
