# 画面設計書 202-支払条件一覧

## 概要

本ドキュメントは、Invoicesモジュールにおける支払条件一覧画面の設計仕様を定義します。

### 本画面の処理概要

支払条件一覧画面は、請求書や注文書に適用される支払条件（支払期限、早期支払割引など）を一元管理するための画面です。

**業務上の目的・背景**：取引先との契約において、支払期限や分割払いの条件、早期支払時の割引率などを統一的に管理する必要があります。支払条件を標準化することで、請求書作成時の条件設定が効率化され、キャッシュフロー管理や売掛金回収の予測精度が向上します。経理・財務部門が取引条件を一元管理し、営業部門が適切な条件を選択できる環境を提供します。

**画面へのアクセス方法**：サイドメニューから「Settings」クラスターを選択し、「Configuration」セクション内の「Payment Terms」（支払条件）ナビゲーションリンクをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 支払条件の一覧表示・検索・ソート
2. 支払条件の新規作成（作成画面への遷移）
3. 支払条件の詳細表示・編集・削除
4. 支払条件の復元（論理削除からの回復）
5. 一括削除・一括復元・完全削除操作
6. グループ化表示（会社、割引日数、早期支払割引、支払条件名、請求書表示、早期割引、割引率別）

**画面遷移**：
- 遷移元：ダッシュボード、Invoicesモジュールトップ、設定メニュー
- 遷移先：支払条件作成画面、支払条件詳細画面、支払条件編集画面、支払期限管理画面

**権限による表示制御**：FilamentShieldによる権限管理が適用されており、支払条件リソースへのアクセス権限を持つユーザーのみが本画面を利用可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-CF-003 | 支払条件管理 | 主機能 | 支払条件の一覧表示、CRUD操作 |
| FN-ACC-023 | 支払条件管理 | 補助機能 | Accountsモジュールの基底機能を継承 |

## 画面種別

一覧画面（ListRecords）

## URL/ルーティング

`/invoices/configuration/payment-terms`

## 画面構成

- **ヘッダーセクション**
  - 画面タイトル：「Payment Terms」
  - 新規作成ボタン（CreateAction）：プラスアイコン付き

- **テーブルセクション**
  - データテーブル：支払条件一覧
  - グループ化機能
  - 検索・ソート機能
  - レコードアクション（表示・編集・復元・削除・完全削除）
  - 一括アクション（一括削除・一括復元・一括完全削除）

## 入出力項目

本画面は一覧表示画面のため、直接の入力項目はありません。フィルタリング条件として検索キーワードが入力可能です。

## 表示項目

| 項目名 | 物理名 | 型 | 説明 | ソート | 検索 |
|--------|--------|-----|------|--------|------|
| 支払条件名 | name | テキスト | 支払条件の名称 | 可 | 可 |
| 会社 | company.name | テキスト | 所属会社名 | 可 | 可 |
| 作成日時 | created_at | 日時 | レコード作成日時 | 可 | 不可 |
| 更新日時 | updated_at | 日時 | レコード更新日時 | 可 | 不可 |

※作成日時・更新日時はデフォルトで非表示（トグル可能）

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの新規作成ボタン（CreateAction）をクリックすると、支払条件作成画面（`/invoices/configuration/payment-terms/create`）に遷移します。

### 2-表示アクション

テーブル行の表示アイコンをクリックすると、該当する支払条件の詳細画面（`/invoices/configuration/payment-terms/{record}`）に遷移します。

### 3-編集アクション

テーブル行の編集アイコンをクリックすると、該当する支払条件の編集画面（`/invoices/configuration/payment-terms/{record}/edit`）に遷移します。

### 4-削除アクション

テーブル行の削除アイコンをクリックすると、確認ダイアログが表示され、確認後に該当レコードを論理削除します。削除成功時には成功通知が表示されます。

### 5-復元アクション

論理削除されたレコードの復元アイコンをクリックすると、該当レコードを復元します。復元成功時には成功通知が表示されます。

### 6-完全削除アクション

論理削除されたレコードの完全削除アイコンをクリックすると、確認ダイアログが表示され、確認後に該当レコードを物理削除します。

### 7-一括削除アクション

チェックボックスで複数レコードを選択し、一括削除ボタンをクリックすると、選択されたすべてのレコードを論理削除します。

### 8-一括復元アクション

チェックボックスで複数の論理削除済みレコードを選択し、一括復元ボタンをクリックすると、選択されたすべてのレコードを復元します。

### 9-一括完全削除アクション

チェックボックスで複数の論理削除済みレコードを選択し、一括完全削除ボタンをクリックすると、選択されたすべてのレコードを物理削除します。

### 10-グループ化切替

グループ化オプションを選択すると、選択した項目でレコードをグループ化して表示します。グループは折りたたみ可能です。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | accounts_payment_terms | SELECT | 支払条件一覧を取得 |
| 削除アクション | accounts_payment_terms | UPDATE | deleted_atを現在日時で更新（論理削除） |
| 復元アクション | accounts_payment_terms | UPDATE | deleted_atをNULLに更新 |
| 完全削除 | accounts_payment_terms | DELETE | 指定レコードを物理削除 |

### テーブル別更新項目詳細

#### accounts_payment_terms

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | - | 全件または検索条件に合致するレコード | 関連テーブル（company）をJOIN |
| UPDATE（論理削除） | deleted_at | CURRENT_TIMESTAMP | SoftDeletes使用 |
| UPDATE（復元） | deleted_at | NULL | - |
| DELETE | - | 指定されたID | 物理削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| delete.notification.title | 成功 | 削除成功タイトル | 削除成功時 |
| delete.notification.body | 成功 | 削除成功メッセージ | 削除成功時 |
| restore.notification.title | 成功 | 復元成功タイトル | 復元成功時 |
| restore.notification.body | 成功 | 復元成功メッセージ | 復元成功時 |
| force-delete.notification.title | 成功 | 完全削除成功タイトル | 完全削除成功時 |
| force-delete.notification.body | 成功 | 完全削除成功メッセージ | 完全削除成功時 |
| bulk-delete.notification.title | 成功 | 一括削除成功タイトル | 一括削除成功時 |
| bulk-delete.notification.body | 成功 | 一括削除成功メッセージ | 一括削除成功時 |
| bulk-restore.notification.title | 成功 | 一括復元成功タイトル | 一括復元成功時 |
| bulk-restore.notification.body | 成功 | 一括復元成功メッセージ | 一括復元成功時 |
| bulk-force-delete.notification.title | 成功 | 一括完全削除成功タイトル | 一括完全削除成功時 |
| bulk-force-delete.notification.body | 成功 | 一括完全削除成功メッセージ | 一括完全削除成功時 |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| データベース接続エラー | システムエラー画面を表示 |
| 削除時の外部キー制約違反 | エラー通知を表示し、削除をキャンセル |
| 権限不足 | アクセス拒否画面を表示（FilamentShield） |
| レコードが存在しない | 404エラー画面を表示 |

## 備考

- 本画面はAccountsモジュールのPaymentTermResourceを継承しており、基本的な機能はBaseクラスから提供されています。
- 支払条件はInvoicesモジュールのConfigurationクラスターに属しています。
- サブナビゲーションとして、詳細表示、編集、支払期限管理へのナビゲーションが提供されます。
- 論理削除（SoftDeletes）が実装されており、削除されたレコードの復元が可能です。
- 国際化対応として、ラベルやメッセージはすべて多言語リソースファイルから取得されます。
