# 画面設計書 203-銀行口座一覧

## 概要

本ドキュメントは、Invoicesモジュールにおける銀行口座一覧画面の設計仕様を定義します。

### 本画面の処理概要

銀行口座一覧画面は、取引先やパートナーに紐づく銀行口座情報を管理するための画面です。

**業務上の目的・背景**：取引先への支払いや売上金の入金先となる銀行口座情報を一元管理することで、決済処理の効率化と正確性を担保します。銀行口座情報は請求書発行や支払処理において参照されるため、正確な情報管理が不可欠です。特に、送金可能な口座かどうかの区別や、口座保有者（パートナー）との紐付け管理が重要な機能となります。

**画面へのアクセス方法**：サイドメニューから「Settings」クラスターを選択し、「Configuration」セクション内の「Bank Accounts」（銀行口座）ナビゲーションリンクをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 銀行口座の一覧表示・検索・ソート・フィルタ
2. 銀行口座の新規作成（モーダルダイアログ）
3. 銀行口座の編集・削除
4. 銀行口座の復元（論理削除からの回復）
5. 一括削除・一括復元・完全削除操作
6. グループ化表示（銀行、送金可否、作成日別）
7. カラムの並び替え

**画面遷移**：
- 遷移元：ダッシュボード、Invoicesモジュールトップ、設定メニュー
- 遷移先：なし（モーダルダイアログで操作完結）

**権限による表示制御**：FilamentShieldによる権限管理が適用されており、銀行口座リソースへのアクセス権限を持つユーザーのみが本画面を利用可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-CF-004 | 銀行口座管理 | 主機能 | 銀行口座の一覧表示、CRUD操作 |
| FN-ACC-024 | 銀行口座管理 | 補助機能 | Accountsモジュールの基底機能を継承 |
| FN-PTN-003 | 銀行口座管理 | 補助機能 | Partnersモジュールの基底機能を継承 |

## 画面種別

一覧画面（ManageRecords / ListRecords）

## URL/ルーティング

`/invoices/configuration/bank-accounts`

## 画面構成

- **ヘッダーセクション**
  - 画面タイトル：「Bank Accounts」
  - 新規作成ボタン（CreateAction）：プラスアイコン付き

- **フィルターセクション**
  - 送金可否フィルター（三値フィルター）
  - 銀行フィルター（SelectFilter）
  - 口座保有者フィルター（SelectFilter）
  - 作成者フィルター（SelectFilter）

- **テーブルセクション**
  - データテーブル：銀行口座一覧（カラム並び替え可能）
  - グループ化機能
  - 検索・ソート機能
  - レコードアクション（編集・復元・削除・完全削除）
  - 一括アクション（一括削除・一括復元・一括完全削除）

## 入出力項目

### 入力項目（作成・編集モーダル）

| 項目名 | 物理名 | 型 | 必須 | 説明 | バリデーション |
|--------|--------|-----|------|------|---------------|
| 口座番号 | account_number | テキスト | 必須 | 銀行口座番号 | 最大255文字、ユニーク |
| 銀行 | bank_id | セレクト | 必須 | 銀行マスタから選択 | 存在する銀行ID |
| 口座保有者 | partner_id | セレクト | 必須 | パートナーマスタから選択 | 存在するパートナーID |

※Invoicesモジュールでは「送金可否」フィールドは非表示となっています。

## 表示項目

| 項目名 | 物理名 | 型 | 説明 | ソート | 検索 |
|--------|--------|-----|------|--------|------|
| 口座番号 | account_number | テキスト | 銀行口座番号 | 可 | 可 |
| 銀行 | bank.name | テキスト | 銀行名 | 可 | 可 |
| 口座保有者 | partner.name | テキスト | 口座保有者（パートナー）名 | 可 | 不可 |
| 削除日時 | deleted_at | 日時 | 論理削除日時 | 可 | 不可 |
| 作成日時 | created_at | 日時 | レコード作成日時 | 可 | 不可 |
| 更新日時 | updated_at | 日時 | レコード更新日時 | 可 | 不可 |

※削除日時・作成日時・更新日時はデフォルトで非表示（トグル可能）
※Invoicesモジュールでは「送金可否」カラムは非表示となっています。

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの新規作成ボタン（CreateAction）をクリックすると、銀行口座作成モーダルダイアログが表示されます。必須項目を入力し、保存ボタンを押下するとレコードが作成されます。

### 2-編集アクション

テーブル行の編集アイコンをクリックすると、銀行口座編集モーダルダイアログが表示されます。論理削除されたレコードでは非表示となります。編集成功時には成功通知が表示されます。

### 3-削除アクション

テーブル行の削除アイコンをクリックすると、確認ダイアログが表示され、確認後に該当レコードを論理削除します。削除成功時には成功通知が表示されます。

### 4-復元アクション

論理削除されたレコードの復元アイコンをクリックすると、該当レコードを復元します。復元成功時には成功通知が表示されます。

### 5-完全削除アクション

論理削除されたレコードの完全削除アイコンをクリックすると、確認ダイアログが表示され、確認後に該当レコードを物理削除します。

### 6-一括削除アクション

チェックボックスで複数レコードを選択し、一括削除ボタンをクリックすると、選択されたすべてのレコードを論理削除します。

### 7-一括復元アクション

チェックボックスで複数の論理削除済みレコードを選択し、一括復元ボタンをクリックすると、選択されたすべてのレコードを復元します。

### 8-一括完全削除アクション

チェックボックスで複数の論理削除済みレコードを選択し、一括完全削除ボタンをクリックすると、選択されたすべてのレコードを物理削除します。

### 9-グループ化切替

グループ化オプションを選択すると、選択した項目（銀行、送金可否、作成日）でレコードをグループ化して表示します。

### 10-フィルター適用

各フィルター条件を設定すると、該当する条件に合致するレコードのみが表示されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | partners_bank_accounts | SELECT | 銀行口座一覧を取得 |
| 新規作成 | partners_bank_accounts | INSERT | 新規レコードを作成 |
| 編集 | partners_bank_accounts | UPDATE | 指定レコードを更新 |
| 削除アクション | partners_bank_accounts | UPDATE | deleted_atを現在日時で更新（論理削除） |
| 復元アクション | partners_bank_accounts | UPDATE | deleted_atをNULLに更新 |
| 完全削除 | partners_bank_accounts | DELETE | 指定レコードを物理削除 |

### テーブル別更新項目詳細

#### partners_bank_accounts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | - | 全件または検索条件に合致するレコード | 関連テーブル（bank, partner, creator）をJOIN |
| INSERT | account_number | フォーム入力値 | - |
| INSERT | bank_id | フォーム入力値 | - |
| INSERT | partner_id | フォーム入力値 | - |
| INSERT | creator_id | 現在のログインユーザーID | - |
| INSERT | created_at | CURRENT_TIMESTAMP | - |
| INSERT | updated_at | CURRENT_TIMESTAMP | - |
| UPDATE | account_number | フォーム入力値 | - |
| UPDATE | bank_id | フォーム入力値 | - |
| UPDATE | partner_id | フォーム入力値 | - |
| UPDATE | updated_at | CURRENT_TIMESTAMP | - |
| UPDATE（論理削除） | deleted_at | CURRENT_TIMESTAMP | SoftDeletes使用 |
| UPDATE（復元） | deleted_at | NULL | - |
| DELETE | - | 指定されたID | 物理削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| edit.notification.title | 成功 | 編集成功タイトル | 編集成功時 |
| edit.notification.body | 成功 | 編集成功メッセージ | 編集成功時 |
| delete.notification.title | 成功 | 削除成功タイトル | 削除成功時 |
| delete.notification.body | 成功 | 削除成功メッセージ | 削除成功時 |
| restore.notification.title | 成功 | 復元成功タイトル | 復元成功時 |
| restore.notification.body | 成功 | 復元成功メッセージ | 復元成功時 |
| force-delete.notification.title | 成功 | 完全削除成功タイトル | 完全削除成功時 |
| force-delete.notification.body | 成功 | 完全削除成功メッセージ | 完全削除成功時 |
| bulk-delete.notification.title | 成功 | 一括削除成功タイトル | 一括削除成功時 |
| bulk-delete.notification.body | 成功 | 一括削除成功メッセージ | 一括削除成功時 |
| bulk-restore.notification.title | 成功 | 一括復元成功タイトル | 一括復元成功時 |
| bulk-restore.notification.body | 成功 | 一括復元成功メッセージ | 一括復元成功時 |
| bulk-force-delete.notification.title | 成功 | 一括完全削除成功タイトル | 一括完全削除成功時 |
| bulk-force-delete.notification.body | 成功 | 一括完全削除成功メッセージ | 一括完全削除成功時 |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| データベース接続エラー | システムエラー画面を表示 |
| ユニーク制約違反（口座番号重複） | バリデーションエラーを表示 |
| 削除時の外部キー制約違反 | エラー通知を表示し、削除をキャンセル |
| 権限不足 | アクセス拒否画面を表示（FilamentShield） |
| レコードが存在しない | 404エラー画面を表示 |

## 備考

- 本画面はAccountsモジュールおよびPartnersモジュールのBankAccountResourceを継承しており、基本的な機能はBaseクラスから提供されています。
- Invoicesモジュールでは、フォームから「送金可否」トグルが除外され、テーブルからも「送金可否」カラムが除外されています。
- 銀行口座はInvoicesモジュールのConfigurationクラスターに属しています。
- テーブルのカラムは並び替え可能（reorderableColumns）です。
- 銀行選択時、論理削除された銀行も表示されますが、選択不可（disabled）となっています。
- 国際化対応として、ラベルやメッセージはすべて多言語リソースファイルから取得されます。
