# 画面設計書 204-インコタームズ一覧

## 概要

本ドキュメントは、Invoicesモジュールにおけるインコタームズ一覧画面の設計仕様を定義します。

### 本画面の処理概要

インコタームズ一覧画面は、国際貿易取引における商品引き渡し条件（Incoterms: International Commercial Terms）を管理するための画面です。

**業務上の目的・背景**：国際貿易において、売主と買主の間で費用負担と危険負担の境界を明確にするため、国際商業会議所（ICC）が定めた標準的な取引条件であるインコタームズを管理します。請求書や受発注書に適切なインコタームズを設定することで、取引条件の曖昧さを排除し、国際取引における紛争を予防します。FOB、CIF、EXW等の標準的な取引条件コードを一元管理します。

**画面へのアクセス方法**：サイドメニューから「Settings」クラスターを選択し、「Configuration」セクション内の「Incoterms」（インコタームズ）ナビゲーションリンクをクリックしてアクセスします。

**主要な操作・処理内容**：
1. インコタームズの一覧表示・検索・ソート
2. インコタームズの新規作成（モーダルダイアログ）
3. インコタームズの表示・編集・削除
4. インコタームズの復元（論理削除からの回復）
5. 一括削除・一括復元・完全削除操作

**画面遷移**：
- 遷移元：ダッシュボード、Invoicesモジュールトップ、設定メニュー
- 遷移先：なし（モーダルダイアログで操作完結）

**権限による表示制御**：FilamentShieldによる権限管理が適用されており、インコタームズリソースへのアクセス権限を持つユーザーのみが本画面を利用可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-CF-005 | インコタームズ管理 | 主機能 | インコタームズの一覧表示、CRUD操作 |
| FN-ACC-025 | インコタームズ管理 | 補助機能 | Accountsモジュールの基底機能を継承 |

## 画面種別

一覧画面（ManageRecords / ListRecords）

## URL/ルーティング

`/invoices/configuration/incoterms`

## 画面構成

- **ヘッダーセクション**
  - 画面タイトル：「Incoterms」
  - 新規作成ボタン（CreateAction）：プラスアイコン付き

- **テーブルセクション**
  - データテーブル：インコタームズ一覧
  - 検索・ソート機能
  - レコードアクション（表示・編集・復元・削除・完全削除）
  - 一括アクション（一括削除・一括復元・一括完全削除）

## 入出力項目

### 入力項目（作成・編集モーダル）

| 項目名 | 物理名 | 型 | 必須 | 説明 | バリデーション |
|--------|--------|-----|------|------|---------------|
| コード | code | テキスト | 必須 | インコタームズコード（FOB、CIF等） | 最大3文字 |
| 名称 | name | テキスト | 必須 | インコタームズの正式名称 | - |
| 作成者ID | creator_id | Hidden | 必須 | 作成者のユーザーID | 自動設定（ログインユーザー） |

## 表示項目

| 項目名 | 物理名 | 型 | 説明 | ソート | 検索 |
|--------|--------|-----|------|--------|------|
| コード | code | テキスト | インコタームズコード | 可 | 可 |
| 名称 | name | テキスト | インコタームズの正式名称 | 可 | 可 |
| 作成者 | createdBy.name | テキスト | レコード作成者名 | 可 | 可 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの新規作成ボタン（CreateAction）をクリックすると、インコタームズ作成モーダルダイアログが表示されます。コードと名称を入力し、保存ボタンを押下するとレコードが作成されます。作成者IDは自動的に現在のログインユーザーが設定されます。

### 2-表示アクション

テーブル行の表示アイコンをクリックすると、インコタームズ詳細モーダルダイアログが表示されます。

### 3-編集アクション

テーブル行の編集アイコンをクリックすると、インコタームズ編集モーダルダイアログが表示されます。編集成功時には成功通知が表示されます。

### 4-削除アクション

テーブル行の削除アイコンをクリックすると、確認ダイアログが表示され、確認後に該当レコードを論理削除します。削除成功時には成功通知が表示されます。

### 5-復元アクション

論理削除されたレコードの復元アイコンをクリックすると、該当レコードを復元します。復元成功時には成功通知が表示されます。

### 6-完全削除アクション

論理削除されたレコードの完全削除アイコンをクリックすると、確認ダイアログが表示され、確認後に該当レコードを物理削除します。

### 7-一括削除アクション

チェックボックスで複数レコードを選択し、一括削除ボタンをクリックすると、選択されたすべてのレコードを論理削除します。

### 8-一括復元アクション

チェックボックスで複数の論理削除済みレコードを選択し、一括復元ボタンをクリックすると、選択されたすべてのレコードを復元します。

### 9-一括完全削除アクション

チェックボックスで複数の論理削除済みレコードを選択し、一括完全削除ボタンをクリックすると、選択されたすべてのレコードを物理削除します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | accounts_incoterms | SELECT | インコタームズ一覧を取得 |
| 新規作成 | accounts_incoterms | INSERT | 新規レコードを作成 |
| 編集 | accounts_incoterms | UPDATE | 指定レコードを更新 |
| 削除アクション | accounts_incoterms | UPDATE | deleted_atを現在日時で更新（論理削除） |
| 復元アクション | accounts_incoterms | UPDATE | deleted_atをNULLに更新 |
| 完全削除 | accounts_incoterms | DELETE | 指定レコードを物理削除 |

### テーブル別更新項目詳細

#### accounts_incoterms

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | - | 全件または検索条件に合致するレコード | 関連テーブル（createdBy）をJOIN |
| INSERT | code | フォーム入力値 | 最大3文字 |
| INSERT | name | フォーム入力値 | - |
| INSERT | creator_id | 現在のログインユーザーID | Hidden項目 |
| INSERT | created_at | CURRENT_TIMESTAMP | - |
| INSERT | updated_at | CURRENT_TIMESTAMP | - |
| UPDATE | code | フォーム入力値 | - |
| UPDATE | name | フォーム入力値 | - |
| UPDATE | updated_at | CURRENT_TIMESTAMP | - |
| UPDATE（論理削除） | deleted_at | CURRENT_TIMESTAMP | SoftDeletes使用 |
| UPDATE（復元） | deleted_at | NULL | - |
| DELETE | - | 指定されたID | 物理削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| edit.notification.title | 成功 | 編集成功タイトル | 編集成功時 |
| edit.notification.body | 成功 | 編集成功メッセージ | 編集成功時 |
| delete.notification.title | 成功 | 削除成功タイトル | 削除成功時 |
| delete.notification.body | 成功 | 削除成功メッセージ | 削除成功時 |
| restore.notification.title | 成功 | 復元成功タイトル | 復元成功時 |
| restore.notification.body | 成功 | 復元成功メッセージ | 復元成功時 |
| force-delete.notification.title | 成功 | 完全削除成功タイトル | 完全削除成功時 |
| force-delete.notification.body | 成功 | 完全削除成功メッセージ | 完全削除成功時 |
| bulk-delete.notification.title | 成功 | 一括削除成功タイトル | 一括削除成功時 |
| bulk-delete.notification.body | 成功 | 一括削除成功メッセージ | 一括削除成功時 |
| bulk-restore.notification.title | 成功 | 一括復元成功タイトル | 一括復元成功時 |
| bulk-restore.notification.body | 成功 | 一括復元成功メッセージ | 一括復元成功時 |
| bulk-force-delete.notification.title | 成功 | 一括完全削除成功タイトル | 一括完全削除成功時 |
| bulk-force-delete.notification.body | 成功 | 一括完全削除成功メッセージ | 一括完全削除成功時 |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| データベース接続エラー | システムエラー画面を表示 |
| コード長超過（3文字以上） | バリデーションエラーを表示 |
| 削除時の外部キー制約違反 | エラー通知を表示し、削除をキャンセル |
| 権限不足 | アクセス拒否画面を表示（FilamentShield） |
| レコードが存在しない | 404エラー画面を表示 |

## 備考

- 本画面はAccountsモジュールのIncoTermResourceを継承しており、基本的な機能はBaseクラスから提供されています。
- インコタームズはInvoicesモジュールのConfigurationクラスターに属しています。
- コードは国際商業会議所（ICC）が定めた標準コード（FOB、CIF、EXW等）を想定しており、最大3文字に制限されています。
- ナビゲーションアイコンには`heroicon-o-globe-alt`が使用されており、国際取引を表現しています。
- 国際化対応として、ラベルやメッセージはすべて多言語リソースファイル（`invoices::filament/clusters/configurations/resources/incoterm`）から取得されます。
