# 画面設計書 205-商品設定

## 概要

本ドキュメントは、Invoicesモジュールにおける商品設定画面の設計仕様を定義します。

### 本画面の処理概要

商品設定画面は、請求書処理において使用される商品に関するシステム設定を管理するための画面です。

**業務上の目的・背景**：請求書モジュールにおける商品管理の動作設定を一元管理します。特に、商品の単位管理（UOM: Unit of Measure）機能の有効化/無効化を制御し、商品を異なる単位で販売・購入する際の設定を行います。この設定により、例えば「kg単位で仕入れて個数単位で販売する」といった柔軟な単位変換処理が可能になります。

**画面へのアクセス方法**：サイドメニューから「Settings」クラスターを選択し、「Invoices」グループ内の「Products」（商品設定）ナビゲーションリンクをクリックしてアクセスします。

**主要な操作・処理内容**：
1. 単位管理（UOM）機能の有効化/無効化設定
2. 設定の保存

**画面遷移**：
- 遷移元：ダッシュボード、Invoicesモジュールトップ、設定メニュー
- 遷移先：なし（設定保存後も同一画面に留まる）

**権限による表示制御**：FilamentShieldによる権限管理が適用されており、商品設定ページへのアクセス権限を持つユーザーのみが本画面を利用可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-INV-ST-001 | 商品設定管理 | 主機能 | 商品関連のシステム設定管理 |

## 画面種別

設定画面（SettingsPage）

## URL/ルーティング

`/settings/invoices/products`

## 画面構成

- **ヘッダーセクション**
  - 画面タイトル：「Manage Products」（商品管理）
  - パンくずリスト：「Manage Products」

- **設定フォームセクション**
  - 単位管理（UOM）設定トグル

- **フッターセクション**
  - 保存ボタン

## 入出力項目

### 入力項目

| 項目名 | 物理名 | 型 | 必須 | 説明 | 初期値 |
|--------|--------|-----|------|------|--------|
| 単位管理 | enable_uom | トグル | - | 単位管理（UOM）機能の有効化/無効化 | 設定ファイルの値 |

## 表示項目

本画面は設定画面のため、表示専用項目はありません。入力項目が表示と兼ねています。

## イベント仕様

### 1-単位管理トグル変更

トグルのオン/オフを切り替えると、単位管理（UOM）機能の有効/無効状態が変更されます。この変更は保存ボタン押下時にデータベースに反映されます。

### 2-保存ボタン押下

保存ボタンを押下すると、フォームの内容がProductSettings設定クラスに保存されます。保存成功時には成功通知が表示されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | settings | SELECT | 現在の設定値を取得 |
| 保存ボタン押下 | settings | UPDATE/INSERT | 設定値を更新または新規作成 |

### テーブル別更新項目詳細

#### settings（Spatie Laravel Settings使用）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | enable_uom | ProductSettings::class | Spatie Settings |
| UPDATE | enable_uom | フォーム入力値（boolean） | - |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| save.success | 成功 | 設定が保存されました | 保存成功時 |
| save.error | エラー | 設定の保存に失敗しました | 保存失敗時 |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| データベース接続エラー | システムエラー画面を表示 |
| 権限不足 | アクセス拒否画面を表示（FilamentShield） |
| 設定クラス読み込みエラー | システムエラー画面を表示 |

## 備考

- 本画面はFilamentのSettingsPageを継承しており、Spatie Laravel Settingsパッケージを使用して設定を永続化しています。
- 設定クラスはProductSettings（`Webkul\Invoice\Settings\ProductSettings`）です。
- SettingsクラスターのInvoicesナビゲーショングループに属しています。
- ナビゲーションアイコンには`heroicon-o-cube`が使用されており、商品を表現しています。
- ナビゲーション順序は1に設定されています。
- 単位管理（UOM）機能を有効にすると、商品を異なる単位で販売・購入する機能が利用可能になります（例：キログラム単位で仕入れて個数単位で販売）。
