# 画面設計書 206-パートナー一覧

## 概要

本ドキュメントは、Partnersモジュールにおけるパートナー一覧画面の設計仕様を定義します。

### 本画面の処理概要

パートナー一覧画面は、取引先（顧客、仕入先、代理店等）やコンタクト情報を管理するための画面です。

**業務上の目的・背景**：ERPシステムにおいて、すべての取引関係者（パートナー）を一元管理することは、営業活動、請求処理、仕入管理などの基盤となる重要な機能です。パートナーには個人（Individual）と法人（Company）の2種類があり、それぞれに適した情報管理と表示を提供します。また、タグ付けによる分類、親会社との関連付け、担当者の設定など、柔軟な顧客管理を可能にします。

**画面へのアクセス方法**：サイドメニューから「Partners」モジュールを選択し、パートナー一覧にアクセスします。

**主要な操作・処理内容**：
1. パートナーのカード形式一覧表示
2. 高度なフィルタリング（QueryBuilder使用）
3. プリセットビュー（個人、法人、アーカイブ）の切り替え
4. パートナーの新規作成（作成画面への遷移）
5. パートナーの表示・編集・削除・復元
6. 一括削除・一括復元・一括完全削除操作
7. グループ化表示（アカウントタイプ、親会社、敬称、職位、業種別）

**画面遷移**：
- 遷移元：ダッシュボード、他モジュールからの参照
- 遷移先：パートナー作成画面、パートナー詳細画面、パートナー編集画面

**権限による表示制御**：FilamentShieldによる権限管理が適用されており、パートナーリソースへのアクセス権限を持つユーザーのみが本画面を利用可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PTN-001 | パートナー管理 | 主機能 | パートナーの一覧表示、CRUD操作 |

## 画面種別

一覧画面（ListRecords）- グリッドカード表示

## URL/ルーティング

`/partners/partners`

## 画面構成

- **ヘッダーセクション**
  - 画面タイトル（多言語対応）
  - 新規作成ボタン（CreateAction）：プラスアイコン付き

- **プリセットビュータブ**
  - 個人（Individuals）：個人アカウントタイプのみ表示
  - 法人（Companies）：法人アカウントタイプのみ表示
  - アーカイブ（Archived）：論理削除されたレコードのみ表示

- **フィルターセクション（モーダル）**
  - QueryBuilderによる高度なフィルタリング
  - スライドオーバー形式で表示

- **カードグリッドセクション**
  - パートナーカードのグリッド表示（レスポンシブ）
  - SM: 1列、MD: 2列、XL: 3列、2XL: 4列

- **ページネーション**
  - 16、32、64、全件表示の切り替え

## 入出力項目

本画面は一覧表示画面のため、直接の入力項目はありません。フィルタリング条件として各種フィルターが入力可能です。

## 表示項目（カード表示）

| 項目名 | 物理名 | 型 | 説明 | 表示条件 |
|--------|--------|-----|------|----------|
| アバター | avatar | 画像 | パートナーのプロフィール画像 | 常時 |
| 名前 | name | テキスト | パートナー名（太字） | 常時 |
| 親会社 | parent.name | テキスト | 所属する親会社名 | 親会社が設定されている場合 |
| 職位 | job_title | テキスト | 役職名 | 職位が設定されている場合 |
| メール | email | テキスト | メールアドレス（20文字制限） | メールが設定されている場合 |
| 電話 | phone | テキスト | 電話番号（30文字制限） | 電話が設定されている場合 |
| タグ | tags.name | バッジ | 設定されたタグ一覧（色付き） | タグが設定されている場合 |

## フィルター項目

| フィルター名 | 物理名 | 型 | 説明 |
|-------------|--------|-----|------|
| アカウントタイプ | account_type | 複数選択 | Individual/Company |
| 名前 | name | テキスト | 部分一致検索 |
| メール | email | テキスト | 部分一致検索 |
| 職位 | job_title | テキスト | 部分一致検索 |
| ウェブサイト | website | テキスト | 部分一致検索 |
| 税番号 | tax_id | テキスト | 部分一致検索 |
| 電話 | phone | テキスト | 部分一致検索 |
| 携帯 | mobile | テキスト | 部分一致検索 |
| 会社登記番号 | company_registry | テキスト | 部分一致検索 |
| 参照 | reference | テキスト | 部分一致検索 |
| 親会社 | parent | リレーション | 複数選択可能 |
| 作成者 | creator | リレーション | 複数選択可能 |
| 担当者 | user | リレーション | 複数選択可能 |
| 敬称 | title | リレーション | 複数選択可能 |
| 所属会社 | company | リレーション | 複数選択可能 |
| 業種 | industry | リレーション | 複数選択可能 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの新規作成ボタン（CreateAction）をクリックすると、パートナー作成画面（`/partners/partners/create`）に遷移します。

### 2-表示アクション

カードまたは行の表示アイコンをクリックすると、該当するパートナーの詳細画面（`/partners/partners/{record}`）に遷移します。論理削除されたレコードでは非表示となります。

### 3-編集アクション

カードまたは行の編集アイコンをクリックすると、該当するパートナーの編集画面（`/partners/partners/{record}/edit`）に遷移します。論理削除されたレコードでは非表示となります。編集成功時には成功通知が表示されます。

### 4-削除アクション

カードまたは行の削除アイコンをクリックすると、確認ダイアログが表示され、確認後に該当レコードを論理削除します。削除成功時には成功通知が表示されます。

### 5-復元アクション

論理削除されたレコードの復元アイコンをクリックすると、該当レコードを復元します。復元成功時には成功通知が表示されます。

### 6-完全削除アクション

論理削除されたレコードの完全削除アイコンをクリックすると、確認ダイアログが表示され、確認後に該当レコードを物理削除します。外部キー制約違反の場合はエラー通知が表示されます。

### 7-一括削除アクション

チェックボックスで複数レコードを選択し、一括削除ボタンをクリックすると、選択されたすべてのレコードを論理削除します。

### 8-一括復元アクション

チェックボックスで複数の論理削除済みレコードを選択し、一括復元ボタンをクリックすると、選択されたすべてのレコードを復元します。

### 9-一括完全削除アクション

チェックボックスで複数の論理削除済みレコードを選択し、一括完全削除ボタンをクリックすると、選択されたすべてのレコードを物理削除します。外部キー制約違反の場合はエラー通知が表示されます。

### 10-プリセットビュー切替

タブをクリックすると、該当するプリセット条件でフィルタリングされた一覧が表示されます。

### 11-グループ化切替

グループ化オプションを選択すると、選択した項目でレコードをグループ化して表示します。

### 12-フィルター適用

フィルターボタンをクリックするとスライドオーバーでフィルターパネルが表示され、各種条件を設定してフィルタリングできます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | partners_partners | SELECT | パートナー一覧を取得 |
| 削除アクション | partners_partners | UPDATE | deleted_atを現在日時で更新（論理削除） |
| 復元アクション | partners_partners | UPDATE | deleted_atをNULLに更新 |
| 完全削除 | partners_partners | DELETE | 指定レコードを物理削除 |

### テーブル別更新項目詳細

#### partners_partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | - | account_type != ADDRESS | 住所タイプは除外 |
| SELECT | - | WITH tags | タグ情報を事前読み込み |
| UPDATE（論理削除） | deleted_at | CURRENT_TIMESTAMP | SoftDeletes使用 |
| UPDATE（復元） | deleted_at | NULL | - |
| DELETE | - | 指定されたID | 物理削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| edit.notification.title | 成功 | 編集成功タイトル | 編集成功時 |
| edit.notification.body | 成功 | 編集成功メッセージ | 編集成功時 |
| delete.notification.title | 成功 | 削除成功タイトル | 削除成功時 |
| delete.notification.body | 成功 | 削除成功メッセージ | 削除成功時 |
| restore.notification.title | 成功 | 復元成功タイトル | 復元成功時 |
| restore.notification.body | 成功 | 復元成功メッセージ | 復元成功時 |
| force-delete.notification.success.title | 成功 | 完全削除成功タイトル | 完全削除成功時 |
| force-delete.notification.success.body | 成功 | 完全削除成功メッセージ | 完全削除成功時 |
| force-delete.notification.error.title | エラー | 完全削除失敗タイトル | 外部キー制約違反時 |
| force-delete.notification.error.body | エラー | 完全削除失敗メッセージ | 外部キー制約違反時 |
| bulk-delete.notification.title | 成功 | 一括削除成功タイトル | 一括削除成功時 |
| bulk-delete.notification.body | 成功 | 一括削除成功メッセージ | 一括削除成功時 |
| bulk-restore.notification.title | 成功 | 一括復元成功タイトル | 一括復元成功時 |
| bulk-restore.notification.body | 成功 | 一括復元成功メッセージ | 一括復元成功時 |
| bulk-force-delete.notification.success.title | 成功 | 一括完全削除成功タイトル | 一括完全削除成功時 |
| bulk-force-delete.notification.success.body | 成功 | 一括完全削除成功メッセージ | 一括完全削除成功時 |
| bulk-force-delete.notification.error.title | エラー | 一括完全削除失敗タイトル | 外部キー制約違反時 |
| bulk-force-delete.notification.error.body | エラー | 一括完全削除失敗メッセージ | 外部キー制約違反時 |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| データベース接続エラー | システムエラー画面を表示 |
| 削除時の外部キー制約違反（QueryException） | エラー通知を表示し、削除をキャンセル |
| 権限不足 | アクセス拒否画面を表示（FilamentShield） |
| レコードが存在しない | 404エラー画面を表示 |

## 備考

- 本画面はカードグリッド形式（contentGrid）で表示され、レスポンシブデザインに対応しています。
- アカウントタイプがADDRESS（住所）のレコードは一覧から除外されます。
- デフォルトソートは作成日時の降順（created_at DESC）です。
- フィルターはモーダル形式（FiltersLayout::Modal）で、スライドオーバーとして表示されます。
- タグは設定された色でバッジ表示され、視覚的な識別が可能です。
- プリセットビュー機能（HasTableViews）により、よく使う条件でのフィルタリングが簡単に行えます。
- 論理削除（SoftDeletes）が実装されており、削除されたレコードの復元が可能です。
- 国際化対応として、ラベルやメッセージはすべて多言語リソースファイルから取得されます。
