# 画面設計書 207-パートナー作成

## 概要

本ドキュメントは、Partnersモジュールにおけるパートナー作成画面の設計仕様を定義します。

### 本画面の処理概要

パートナー作成画面は、新規の取引先（顧客、仕入先、代理店等）やコンタクト情報を登録するための画面です。

**業務上の目的・背景**：新規取引先の登録は、営業活動や取引開始の第一歩となる重要な業務プロセスです。パートナー情報には、基本情報（名前、連絡先）、所属会社、住所、営業・購買関連の情報など、多岐にわたる項目が含まれます。個人（Individual）と法人（Company）の2種類のアカウントタイプに対応し、それぞれに適した入力フォームを提供します。

**画面へのアクセス方法**：パートナー一覧画面の新規作成ボタンをクリック、または直接URLにアクセスします。

**主要な操作・処理内容**：
1. アカウントタイプ（個人/法人）の選択
2. 基本情報の入力（名前、連絡先、税番号など）
3. 所属会社の選択（個人の場合）
4. 住所情報の入力
5. アバター画像のアップロード
6. タグの設定
7. 営業・購買関連情報の入力
8. パートナーの登録保存

**画面遷移**：
- 遷移元：パートナー一覧画面
- 遷移先：パートナー詳細画面（作成成功時）

**権限による表示制御**：FilamentShieldによる権限管理が適用されており、パートナー作成権限を持つユーザーのみが本画面を利用可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PTN-001 | パートナー管理 | 主機能 | パートナーの新規作成 |

## 画面種別

作成画面（CreateRecord）

## URL/ルーティング

`/partners/partners/create`

## 画面構成

- **ヘッダーセクション**
  - 画面タイトル（多言語対応）
  - サブナビゲーション（クラスターに応じて表示）

- **基本情報セクション**
  - アカウントタイプ選択（ラジオボタン）
  - 名前入力
  - 所属会社選択（個人の場合のみ表示）
  - アバター画像アップロード
  - 連絡先情報（税番号、職位、電話、携帯、メール、ウェブサイト）
  - 敬称選択
  - タグ選択

- **住所セクション（Fieldset）**
  - 住所1、住所2
  - 市区町村、郵便番号
  - 国、都道府県

- **営業・購買タブ（Tabs）**
  - 営業情報（担当者）
  - その他情報（会社ID、参照、業種）

- **フッターセクション**
  - 保存ボタン
  - キャンセルボタン

## 入出力項目

### 入力項目

| 項目名 | 物理名 | 型 | 必須 | 説明 | バリデーション |
|--------|--------|-----|------|------|---------------|
| アカウントタイプ | account_type | ラジオ | 必須 | Individual/Company | デフォルト：Individual |
| 名前 | name | テキスト | 必須 | パートナー名 | 最大255文字 |
| 所属会社 | parent_id | セレクト | - | 親会社（個人の場合のみ表示） | account_type=companyまたはsub_type=companyのパートナーのみ選択可能 |
| アバター | avatar | 画像 | - | プロフィール画像 | 画像形式、partners/avatarディレクトリに保存 |
| 税番号 | tax_id | テキスト | - | 税登録番号（例：29ABCDE1234F1Z5） | 最大255文字 |
| 職位 | job_title | テキスト | - | 役職名（例：CEO） | 最大255文字 |
| 電話 | phone | テキスト | - | 電話番号 | 電話番号形式、最大255文字 |
| 携帯 | mobile | テキスト | - | 携帯電話番号 | 電話番号形式、最大255文字 |
| メール | email | テキスト | - | メールアドレス | メール形式、最大255文字、ユニーク |
| ウェブサイト | website | テキスト | - | ウェブサイトURL | URL形式、最大255文字 |
| 敬称 | title_id | セレクト | - | 敬称マスタから選択 | 存在する敬称ID |
| タグ | tags | 複数選択 | - | タグマスタから選択 | 複数選択可能 |
| 住所1 | street1 | テキスト | - | 住所（1行目） | 最大255文字 |
| 住所2 | street2 | テキスト | - | 住所（2行目） | 最大255文字 |
| 市区町村 | city | テキスト | - | 市区町村名 | 最大255文字 |
| 郵便番号 | zip | テキスト | - | 郵便番号 | 最大255文字 |
| 国 | country_id | セレクト | - | 国マスタから選択 | 存在する国ID |
| 都道府県 | state_id | セレクト | - | 都道府県マスタから選択 | 選択した国に属する都道府県のみ |
| 担当者 | user_id | セレクト | - | ユーザーマスタから選択 | 存在するユーザーID |
| 会社ID | company_registry | テキスト | - | 法人登記番号 | 最大255文字 |
| 参照 | reference | テキスト | - | 参照コード | 最大255文字 |
| 業種 | industry_id | セレクト | - | 業種マスタから選択 | 存在する業種ID |

## 表示項目

本画面は作成画面のため、表示専用項目はありません。入力項目が表示と兼ねています。

## イベント仕様

### 1-アカウントタイプ変更

アカウントタイプ（Individual/Company）を切り替えると、以下の動作が発生します：
- 名前フィールドのプレースホルダーが変更される（Individual: 'Jhon Doe'、Company: 'ACME Corp'）
- 所属会社フィールドの表示/非表示が切り替わる（Individualの場合のみ表示）

### 2-国選択変更

国を選択すると、都道府県フィールドの選択肢が選択した国に紐づくものにフィルタリングされます。都道府県の選択値はリセットされます。

### 3-所属会社の新規作成

所属会社選択フィールドから新規作成を選択すると、パートナー作成フォームがモーダルで表示されます。この場合、アカウントタイプは自動的にCompanyに設定されます。

### 4-敬称の新規作成

敬称選択フィールドから新規作成を選択すると、敬称作成フォーム（名前、略称）がモーダルで表示されます。

### 5-タグの新規作成

タグ選択フィールドから新規作成を選択すると、タグ作成フォーム（名前、色）がモーダルで表示されます。

### 6-都道府県の新規作成

都道府県選択フィールドから新規作成を選択すると、都道府県作成フォーム（名前、コード、国）がモーダルで表示されます。国はデフォルトで現在選択中の国が設定されます。

### 7-保存ボタン押下

保存ボタンを押下すると、入力内容のバリデーションが実行され、問題がなければパートナーが作成されます。作成成功時には成功通知が表示され、パートナー詳細画面にリダイレクトされます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | partners_partners | INSERT | 新規パートナーレコードを作成 |
| 敬称新規作成 | partners_titles | INSERT | 新規敬称レコードを作成 |
| タグ新規作成 | partners_tags | INSERT | 新規タグレコードを作成 |
| タグ紐付け | partners_partner_tag | INSERT | パートナーとタグの関連を作成 |
| 都道府県新規作成 | states | INSERT | 新規都道府県レコードを作成 |

### テーブル別更新項目詳細

#### partners_partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | account_type | フォーム入力値 | Individual/Company |
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | parent_id | フォーム入力値 | 個人の場合のみ |
| INSERT | avatar | アップロードファイルパス | - |
| INSERT | tax_id | フォーム入力値 | - |
| INSERT | job_title | フォーム入力値 | - |
| INSERT | phone | フォーム入力値 | - |
| INSERT | mobile | フォーム入力値 | - |
| INSERT | email | フォーム入力値 | ユニーク |
| INSERT | website | フォーム入力値 | - |
| INSERT | title_id | フォーム入力値 | - |
| INSERT | street1 | フォーム入力値 | - |
| INSERT | street2 | フォーム入力値 | - |
| INSERT | city | フォーム入力値 | - |
| INSERT | zip | フォーム入力値 | - |
| INSERT | country_id | フォーム入力値 | - |
| INSERT | state_id | フォーム入力値 | - |
| INSERT | user_id | フォーム入力値 | - |
| INSERT | company_registry | フォーム入力値 | - |
| INSERT | reference | フォーム入力値 | - |
| INSERT | industry_id | フォーム入力値 | - |
| INSERT | created_at | CURRENT_TIMESTAMP | - |
| INSERT | updated_at | CURRENT_TIMESTAMP | - |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| notification.title | 成功 | 作成成功タイトル | 作成成功時 |
| notification.body | 成功 | 作成成功メッセージ | 作成成功時 |
| validation.error | エラー | バリデーションエラーメッセージ | バリデーション失敗時 |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| データベース接続エラー | システムエラー画面を表示 |
| メールアドレス重複（ユニーク制約違反） | バリデーションエラーを表示 |
| 権限不足 | アクセス拒否画面を表示（FilamentShield） |
| ファイルアップロードエラー | エラー通知を表示 |

## 備考

- 本画面はCreateRecordを継承しており、Filament標準の作成ページ機能を利用しています。
- 作成成功後は詳細画面（ViewPartner）にリダイレクトされます。
- アバター画像はpartners/avatarディレクトリに保存され、公開（public）visibility で設定されます。
- 所属会社選択時、会社タイプ（account_type=company または sub_type=company）のパートナーのみが選択肢として表示されます。
- 所属会社の新規作成時、アカウントタイプは自動的にCompanyに設定されます。
- 国際化対応として、ラベルやメッセージはすべて多言語リソースファイル（`partners::filament/resources/partner`）から取得されます。
