# 画面設計書 208-パートナー編集

## 概要

本ドキュメントは、Partnersモジュールにおけるパートナー編集画面の設計仕様を定義します。

### 本画面の処理概要

パートナー編集画面は、既存の取引先（顧客、仕入先、代理店等）やコンタクト情報を更新するための画面です。

**業務上の目的・背景**：取引先情報は、連絡先変更、担当者変更、住所変更など、様々な理由で更新が必要になります。正確かつ最新の取引先情報を維持することは、営業活動、請求処理、コミュニケーションの品質を担保するために重要です。

**画面へのアクセス方法**：パートナー一覧画面またはパートナー詳細画面から編集アクションをクリック、または直接URLにアクセスします。

**主要な操作・処理内容**：
1. 既存パートナー情報の表示・編集
2. アカウントタイプ（個人/法人）の変更
3. 基本情報の更新（名前、連絡先、税番号など）
4. 所属会社の変更（個人の場合）
5. 住所情報の更新
6. アバター画像の変更
7. タグの追加・削除
8. 営業・購買関連情報の更新
9. チャッター機能によるコミュニケーション
10. パートナーの削除

**画面遷移**：
- 遷移元：パートナー一覧画面、パートナー詳細画面
- 遷移先：パートナー詳細画面（保存成功時）

**権限による表示制御**：FilamentShieldによる権限管理が適用されており、パートナー編集権限を持つユーザーのみが本画面を利用可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PTN-001 | パートナー管理 | 主機能 | パートナーの編集・更新 |

## 画面種別

編集画面（EditRecord）

## URL/ルーティング

`/partners/partners/{record}/edit`

## 画面構成

- **ヘッダーセクション**
  - 画面タイトル（多言語対応）
  - ヘッダーアクション
    - チャッターアクション（コミュニケーション機能）
    - 表示アクション（詳細画面へ遷移）
    - 削除アクション

- **基本情報セクション**
  - アカウントタイプ選択（ラジオボタン）
  - 名前入力
  - 所属会社選択（個人の場合のみ表示）
  - アバター画像アップロード
  - 連絡先情報（税番号、職位、電話、携帯、メール、ウェブサイト）
  - 敬称選択
  - タグ選択

- **住所セクション（Fieldset）**
  - 住所1、住所2
  - 市区町村、郵便番号
  - 国、都道府県

- **営業・購買タブ（Tabs）**
  - 営業情報（担当者）
  - その他情報（会社ID、参照、業種）

- **フッターセクション**
  - 保存ボタン
  - キャンセルボタン

## 入出力項目

### 入力項目

| 項目名 | 物理名 | 型 | 必須 | 説明 | バリデーション |
|--------|--------|-----|------|------|---------------|
| アカウントタイプ | account_type | ラジオ | 必須 | Individual/Company | - |
| 名前 | name | テキスト | 必須 | パートナー名 | 最大255文字 |
| 所属会社 | parent_id | セレクト | - | 親会社（個人の場合のみ表示） | account_type=companyまたはsub_type=companyのパートナーのみ選択可能 |
| アバター | avatar | 画像 | - | プロフィール画像 | 画像形式、partners/avatarディレクトリに保存 |
| 税番号 | tax_id | テキスト | - | 税登録番号 | 最大255文字 |
| 職位 | job_title | テキスト | - | 役職名 | 最大255文字 |
| 電話 | phone | テキスト | - | 電話番号 | 電話番号形式、最大255文字 |
| 携帯 | mobile | テキスト | - | 携帯電話番号 | 電話番号形式、最大255文字 |
| メール | email | テキスト | - | メールアドレス | メール形式、最大255文字、ユニーク（自レコード除外） |
| ウェブサイト | website | テキスト | - | ウェブサイトURL | URL形式、最大255文字 |
| 敬称 | title_id | セレクト | - | 敬称マスタから選択 | 存在する敬称ID |
| タグ | tags | 複数選択 | - | タグマスタから選択 | 複数選択可能 |
| 住所1 | street1 | テキスト | - | 住所（1行目） | 最大255文字 |
| 住所2 | street2 | テキスト | - | 住所（2行目） | 最大255文字 |
| 市区町村 | city | テキスト | - | 市区町村名 | 最大255文字 |
| 郵便番号 | zip | テキスト | - | 郵便番号 | 最大255文字 |
| 国 | country_id | セレクト | - | 国マスタから選択 | 存在する国ID |
| 都道府県 | state_id | セレクト | - | 都道府県マスタから選択 | 選択した国に属する都道府県のみ |
| 担当者 | user_id | セレクト | - | ユーザーマスタから選択 | 存在するユーザーID |
| 会社ID | company_registry | テキスト | - | 法人登記番号 | 最大255文字 |
| 参照 | reference | テキスト | - | 参照コード | 最大255文字 |
| 業種 | industry_id | セレクト | - | 業種マスタから選択 | 存在する業種ID |

## 表示項目

本画面は編集画面のため、表示専用項目はありません。入力項目が既存データで初期化されて表示されます。

## イベント仕様

### 1-アカウントタイプ変更

アカウントタイプ（Individual/Company）を切り替えると、以下の動作が発生します：
- 名前フィールドのプレースホルダーが変更される
- 所属会社フィールドの表示/非表示が切り替わる（Individualの場合のみ表示）

### 2-国選択変更

国を選択すると、都道府県フィールドの選択肢が選択した国に紐づくものにフィルタリングされます。都道府県の選択値はリセットされます。

### 3-チャッターアクション

ヘッダーのチャッターアイコンをクリックすると、コミュニケーションパネルが開き、コメントやアクティビティログを確認・追加できます。

### 4-表示アクション

ヘッダーの表示アイコンをクリックすると、パートナー詳細画面に遷移します。

### 5-削除アクション

ヘッダーの削除アイコンをクリックすると、確認ダイアログが表示され、確認後にパートナーを論理削除します。削除成功時には成功通知が表示されます。

### 6-保存ボタン押下

保存ボタンを押下すると、入力内容のバリデーションが実行され、問題がなければパートナー情報が更新されます。更新成功時には成功通知が表示され、パートナー詳細画面にリダイレクトされます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | partners_partners | UPDATE | パートナーレコードを更新 |
| タグ変更 | partners_partner_tag | DELETE/INSERT | パートナーとタグの関連を更新 |
| 削除アクション | partners_partners | UPDATE | deleted_atを更新（論理削除） |

### テーブル別更新項目詳細

#### partners_partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | account_type | フォーム入力値 | - |
| UPDATE | name | フォーム入力値 | 必須 |
| UPDATE | parent_id | フォーム入力値 | 個人の場合のみ |
| UPDATE | avatar | アップロードファイルパス | - |
| UPDATE | tax_id | フォーム入力値 | - |
| UPDATE | job_title | フォーム入力値 | - |
| UPDATE | phone | フォーム入力値 | - |
| UPDATE | mobile | フォーム入力値 | - |
| UPDATE | email | フォーム入力値 | ユニーク（自レコード除外） |
| UPDATE | website | フォーム入力値 | - |
| UPDATE | title_id | フォーム入力値 | - |
| UPDATE | street1 | フォーム入力値 | - |
| UPDATE | street2 | フォーム入力値 | - |
| UPDATE | city | フォーム入力値 | - |
| UPDATE | zip | フォーム入力値 | - |
| UPDATE | country_id | フォーム入力値 | - |
| UPDATE | state_id | フォーム入力値 | - |
| UPDATE | user_id | フォーム入力値 | - |
| UPDATE | company_registry | フォーム入力値 | - |
| UPDATE | reference | フォーム入力値 | - |
| UPDATE | industry_id | フォーム入力値 | - |
| UPDATE | updated_at | CURRENT_TIMESTAMP | - |
| UPDATE（削除） | deleted_at | CURRENT_TIMESTAMP | 論理削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| notification.title | 成功 | 更新成功タイトル | 更新成功時 |
| notification.body | 成功 | 更新成功メッセージ | 更新成功時 |
| header-actions.delete.notification.title | 成功 | 削除成功タイトル | 削除成功時 |
| header-actions.delete.notification.body | 成功 | 削除成功メッセージ | 削除成功時 |
| validation.error | エラー | バリデーションエラーメッセージ | バリデーション失敗時 |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| データベース接続エラー | システムエラー画面を表示 |
| メールアドレス重複（ユニーク制約違反） | バリデーションエラーを表示 |
| レコードが存在しない | 404エラー画面を表示 |
| 権限不足 | アクセス拒否画面を表示（FilamentShield） |
| ファイルアップロードエラー | エラー通知を表示 |

## 備考

- 本画面はEditRecordを継承しており、Filament標準の編集ページ機能を利用しています。
- HasRecordNavigationTabsトレイトを使用しており、レコードナビゲーション機能が有効です。
- 更新成功後は詳細画面（ViewPartner）にリダイレクトされます。
- チャッター機能（ChatterAction）により、パートナーに関するコメントやアクティビティログを管理できます。
- メールアドレスのユニークバリデーションは、自レコードを除外して実行されます（ignoreRecord: true）。
- 国際化対応として、ラベルやメッセージはすべて多言語リソースファイル（`partners::filament/resources/partner/pages/edit-partner`）から取得されます。
