# 画面設計書 209-パートナー詳細

## 概要

本ドキュメントは、Partnersモジュールにおけるパートナー詳細画面の設計仕様を定義します。

### 本画面の処理概要

パートナー詳細画面は、取引先（顧客、仕入先、代理店等）やコンタクトの詳細情報を表示するための画面です。

**業務上の目的・背景**：パートナー情報を一目で確認できる画面を提供することで、営業活動、顧客対応、取引管理における意思決定を支援します。アカウントタイプ、連絡先情報、住所、営業関連情報など、パートナーに関するあらゆる情報を閲覧可能です。

**画面へのアクセス方法**：パートナー一覧画面から表示アクションをクリック、作成・編集画面から保存後にリダイレクト、または直接URLにアクセスします。

**主要な操作・処理内容**：
1. パートナー基本情報の表示
2. 連絡先情報（メール、電話、ウェブサイト等）の表示
3. 住所情報の表示
4. タグ情報の表示
5. 営業・購買関連情報の表示
6. チャッター機能によるコミュニケーション履歴の確認
7. 編集画面への遷移
8. パートナーの削除

**画面遷移**：
- 遷移元：パートナー一覧画面、パートナー作成画面、パートナー編集画面
- 遷移先：パートナー編集画面

**権限による表示制御**：FilamentShieldによる権限管理が適用されており、パートナー閲覧権限を持つユーザーのみが本画面を利用可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PTN-001 | パートナー管理 | 主機能 | パートナーの詳細表示 |

## 画面種別

詳細画面（ViewRecord）

## URL/ルーティング

`/partners/partners/{record}`

## 画面構成

- **ヘッダーセクション**
  - 画面タイトル（多言語対応）
  - ヘッダーアクション
    - チャッターアクション（コミュニケーション機能）
    - 編集アクション（編集画面へ遷移）
    - 削除アクション

- **基本情報セクション**
  - アカウントタイプ（バッジ表示）
  - 名前（太字、大サイズ）
  - 所属会社（個人の場合のみ表示）
  - アバター画像（円形表示）
  - 連絡先情報
    - 税番号
    - 職位
    - 電話（アイコン付き）
    - 携帯（アイコン付き）
    - メール（アイコン付き）
    - ウェブサイト（アイコン付き）
  - 敬称
  - タグ（色付きバッジ）

- **住所セクション（Fieldset）**
  - 住所1、住所2
  - 市区町村、郵便番号
  - 国、都道府県

- **営業・購買タブ（Tabs）**
  - 営業情報セクション
    - 担当者
  - その他セクション
    - 会社ID
    - 参照
    - 業種

## 入出力項目

本画面は詳細表示画面のため、入力項目はありません。

## 表示項目

| 項目名 | 物理名 | 型 | 説明 | アイコン |
|--------|--------|-----|------|---------|
| アカウントタイプ | account_type | バッジ | Individual/Company | - |
| 名前 | name | テキスト（太字・大） | パートナー名 | - |
| 所属会社 | parent.name | テキスト | 親会社名（個人のみ） | - |
| アバター | avatar | 画像 | プロフィール画像（円形） | - |
| 税番号 | tax_id | テキスト | 税登録番号 | - |
| 職位 | job_title | テキスト | 役職名 | - |
| 電話 | phone | テキスト | 電話番号 | heroicon-o-phone |
| 携帯 | mobile | テキスト | 携帯電話番号 | heroicon-o-device-phone-mobile |
| メール | email | テキスト | メールアドレス | heroicon-o-envelope |
| ウェブサイト | website | テキスト | ウェブサイトURL | heroicon-o-globe-alt |
| 敬称 | title.name | テキスト | 敬称 | - |
| タグ | tags.name | バッジ | タグ一覧（色付き） | - |
| 住所1 | street1 | テキスト | 住所（1行目） | - |
| 住所2 | street2 | テキスト | 住所（2行目） | - |
| 市区町村 | city | テキスト | 市区町村名 | - |
| 郵便番号 | zip | テキスト | 郵便番号 | - |
| 国 | country.name | テキスト | 国名 | - |
| 都道府県 | state.name | テキスト | 都道府県名 | - |
| 担当者 | user.name | テキスト | 担当ユーザー名 | - |
| 会社ID | company_registry | テキスト | 法人登記番号 | - |
| 参照 | reference | テキスト | 参照コード | - |
| 業種 | industry.name | テキスト | 業種名 | - |

※各項目は値が未設定の場合「—」（ダッシュ）で表示されます。

## イベント仕様

### 1-チャッターアクション

ヘッダーのチャッターアイコンをクリックすると、コミュニケーションパネルが開き、コメントやアクティビティログを確認・追加できます。

### 2-編集アクション

ヘッダーの編集アイコンをクリックすると、パートナー編集画面（`/partners/partners/{record}/edit`）に遷移します。

### 3-削除アクション

ヘッダーの削除アイコンをクリックすると、確認ダイアログが表示され、確認後にパートナーを論理削除します。削除成功時には成功通知が表示されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | partners_partners | SELECT | パートナー情報を取得 |
| 削除アクション | partners_partners | UPDATE | deleted_atを更新（論理削除） |

### テーブル別更新項目詳細

#### partners_partners

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | - | 指定されたIDのレコード | 関連テーブル（parent, title, country, state, user, industry, tags）をJOIN |
| UPDATE（削除） | deleted_at | CURRENT_TIMESTAMP | 論理削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| header-actions.delete.notification.title | 成功 | 削除成功タイトル | 削除成功時 |
| header-actions.delete.notification.body | 成功 | 削除成功メッセージ | 削除成功時 |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| データベース接続エラー | システムエラー画面を表示 |
| レコードが存在しない | 404エラー画面を表示 |
| 権限不足 | アクセス拒否画面を表示（FilamentShield） |

## 備考

- 本画面はViewRecordを継承しており、Filament標準の詳細表示ページ機能を利用しています。
- HasRecordNavigationTabsトレイトを使用しており、レコードナビゲーション機能が有効です。
- チャッター機能（ChatterAction）により、パートナーに関するコメントやアクティビティログを確認できます。
- アカウントタイプはバッジ形式でprimaryカラーで表示されます。
- 名前はFontWeight::Bold、TextSize::Largeで強調表示されます。
- 所属会社はアカウントタイプがIndividualの場合のみ表示されます。
- アバター画像は円形（circular）で100x100pxで表示されます。
- タグは設定された色でバッジ表示され、カンマ区切りで表示されます（タグがある場合のみ表示）。
- 値が未設定の項目はプレースホルダーとして「—」が表示されます。
- 国際化対応として、ラベルやメッセージはすべて多言語リソースファイル（`partners::filament/resources/partner`）から取得されます。
