# 画面設計書 21-財務ポジション編集

## 概要

本ドキュメントは、Aureus ERPシステムにおける財務ポジション編集画面の設計仕様を定義します。財務ポジション（Fiscal Position）は、取引先の所在地や税務状況に応じて適用される税金や勘定科目を自動的にマッピングするための設定です。

### 本画面の処理概要

**業務上の目的・背景**：
財務ポジションは、国際取引や異なる税務管轄区域間での取引において、適切な税率や勘定科目を自動的に適用するために必要不可欠な機能です。例えば、EU域内取引での付加価値税（VAT）の免除設定や、特定地域への輸出における税務処理の自動化を実現します。この編集画面では、既存の財務ポジション設定を更新し、ビジネス要件の変化に対応することができます。

**画面へのアクセス方法**：
1. サイドメニューから「会計」モジュールを選択
2. 設定メニューから「財務ポジション」を選択して一覧画面へ遷移
3. 一覧から編集したいレコードを選択し、詳細画面へ遷移
4. ヘッダーの「編集」ボタンをクリック、または一覧のアクションから「編集」を選択

**主要な操作・処理内容**：
1. 財務ポジション名の変更
2. 外国VAT番号の更新
3. 適用対象の国・国グループの変更
4. 郵便番号範囲（From/To）の設定
5. 自動検出フラグの切り替え
6. 備考・メモの編集
7. 保存ボタンで変更を確定
8. 削除ボタンでレコードを削除

**画面遷移**：
- 遷移元：財務ポジション一覧画面、財務ポジション詳細画面
- 遷移先：財務ポジション詳細画面（保存成功時）、財務ポジション一覧画面（削除時）

**権限による表示制御**：
会計モジュールへのアクセス権限を持つユーザーのみがこの画面にアクセスできます。編集・削除操作には適切な権限が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-025 | 財務ポジション管理 | 主機能 | 財務ポジションの編集・更新 |
| FN-ACC-025 | 財務ポジション管理 | 補助機能 | 財務ポジションの削除 |
| SCR-ACC-012 | FiscalPositionResource | 遷移先機能 | 詳細画面への遷移 |

## 画面種別

編集（Edit）

## URL/ルーティング

`/admin/accounts/fiscal-positions/{record}/edit`

## 画面構成

- ヘッダーアクション
  - 表示ボタン（ViewAction）
  - 削除ボタン（DeleteAction）
- サブナビゲーション（画面上部）
  - 詳細タブ
  - 編集タブ
  - 税マッピングタブ
- メインフォーム
  - セクション
    - 2カラムグリッド内の入力フィールド群
    - リッチエディタ（備考）

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 初期値 | 備考 |
|--------|--------|----------|----------|------|--------|------|
| 名称 | name | 入力 | string | ○ | - | 財務ポジション名 |
| 外国VAT | foreign_vat | 入力 | string | ○ | - | 外国のVAT番号 |
| 国 | country_id | 入力 | integer | - | null | 国マスタとのリレーション |
| 国グループ | country_group_id | 入力 | integer | - | null | 国グループマスタとのリレーション |
| 郵便番号（From） | zip_from | 入力 | string | ○ | - | 適用開始郵便番号 |
| 郵便番号（To） | zip_to | 入力 | string | ○ | - | 適用終了郵便番号 |
| 自動検出 | auto_reply | 入力 | boolean | - | false | 自動的に検出するかどうか |
| 備考 | notes | 入力 | text | - | null | リッチテキスト形式のメモ |
| 会社ID | company_id | 隠し | integer | ○ | 現在ユーザーのデフォルト会社 | 自動設定 |

## 表示項目

編集画面のため、入出力項目と同一。

## イベント仕様

### 1-保存ボタン押下

1. フォームバリデーション実行
2. `mutateFormDataBeforeSave`でcompany_idを現在ユーザーのデフォルト会社に設定
3. データベースへの更新処理
4. 成功通知を表示
5. 詳細画面へリダイレクト

### 2-削除ボタン押下

1. 確認ダイアログ表示
2. ユーザーが確認した場合、レコードを削除
3. 成功通知を表示
4. 一覧画面へリダイレクト

### 3-表示ボタン押下

1. 詳細画面へ遷移

### 4-サブナビゲーションタブ切り替え

1. 選択されたタブに対応する画面へ遷移
   - 詳細：ViewFiscalPosition
   - 編集：EditFiscalPosition（現在の画面）
   - 税マッピング：ManageFiscalPositionTax

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | fiscal_positions | UPDATE | 財務ポジション情報の更新 |
| 削除ボタン押下 | fiscal_positions | DELETE | 財務ポジションレコードの削除 |

### テーブル別更新項目詳細

#### fiscal_positions

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 必須 |
| UPDATE | foreign_vat | フォーム入力値 | 必須 |
| UPDATE | country_id | 選択された国のID | nullable |
| UPDATE | country_group_id | 選択された国グループのID | nullable |
| UPDATE | zip_from | フォーム入力値 | 必須 |
| UPDATE | zip_to | フォーム入力値 | 必須 |
| UPDATE | auto_reply | フォーム入力値（true/false） | - |
| UPDATE | notes | フォーム入力値 | nullable |
| UPDATE | company_id | Auth::user()->default_company_id | 自動設定 |
| UPDATE | updated_at | 現在日時 | 自動更新 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| edit-fiscal-position.notification.title | 成功 | 保存成功タイトル | 保存処理成功時 |
| edit-fiscal-position.notification.body | 成功 | 保存成功メッセージ本文 | 保存処理成功時 |
| edit-fiscal-position.header-actions.delete.notification.title | 成功 | 削除成功タイトル | 削除処理成功時 |
| edit-fiscal-position.header-actions.delete.notification.body | 成功 | 削除成功メッセージ本文 | 削除処理成功時 |

## 例外処理

| 例外種別 | 発生条件 | 対処方法 |
|---------|---------|---------|
| レコード未存在 | URLパラメータのrecordが存在しない場合 | 404エラーページを表示 |
| 権限不足 | 編集権限がないユーザーがアクセス | 403エラーまたはリダイレクト |
| バリデーションエラー | 必須項目未入力など | フォームにエラーメッセージを表示 |
| データベースエラー | 更新処理失敗時 | エラー通知を表示 |

## 備考

- 本画面はFilament PHPのEditRecordページを継承して実装されている
- サブナビゲーションは画面上部（Top）に配置される
- company_idはログインユーザーのデフォルト会社が自動的に設定される
- 国と国グループはリレーション選択により検索・プリロード可能
