# 画面設計書 210-タグ管理

## 概要

本ドキュメントは、Partnersモジュールにおけるタグ管理画面の設計仕様を定義します。

### 本画面の処理概要

タグ管理画面は、パートナー（取引先）に付与するタグを管理するための画面です。

**業務上の目的・背景**：パートナーを分類・グループ化するためのタグ機能は、顧客セグメンテーション、マーケティング活動、営業戦略の実行において重要な役割を果たします。タグにより、「VIP顧客」「新規開拓中」「重点取引先」など、自由度の高い分類が可能になります。タグには任意の色を設定でき、一覧表示時に視覚的な識別を容易にします。

**画面へのアクセス方法**：サイドメニューから「Partners」モジュールを選択し、タグ管理にアクセスします。

**主要な操作・処理内容**：
1. タグの一覧表示・検索
2. タグの新規作成（モーダルダイアログ）
3. タグの編集・削除・復元
4. 一括削除・一括復元・一括完全削除操作
5. タブ切替（全件/アーカイブ済み）

**画面遷移**：
- 遷移元：ダッシュボード、Partnersモジュールトップ
- 遷移先：なし（モーダルダイアログで操作完結）

**権限による表示制御**：FilamentShieldによる権限管理が適用されており、タグリソースへのアクセス権限を持つユーザーのみが本画面を利用可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PTN-004 | タグ管理 | 主機能 | タグの一覧表示、CRUD操作 |

## 画面種別

管理画面（ManageRecords）

## URL/ルーティング

`/partners/tags`

## 画面構成

- **ヘッダーセクション**
  - 画面タイトル
  - 新規作成ボタン（CreateAction）：プラスアイコン付き

- **タブセクション**
  - 全件タブ（All）：件数バッジ付き
  - アーカイブ済みタブ（Archived）：件数バッジ付き

- **テーブルセクション**
  - データテーブル：タグ一覧
  - 検索機能
  - レコードアクション（編集・復元・削除・完全削除）
  - 一括アクション（一括削除・一括復元・一括完全削除）

## 入出力項目

### 入力項目（作成・編集モーダル）

| 項目名 | 物理名 | 型 | 必須 | 説明 | バリデーション |
|--------|--------|-----|------|------|---------------|
| 名前 | name | テキスト | 必須 | タグ名 | 最大255文字、ユニーク |
| 色 | color | カラーピッカー | - | タグの表示色 | HEXカラーコード |

## 表示項目

| 項目名 | 物理名 | 型 | 説明 | ソート | 検索 |
|--------|--------|-----|------|--------|------|
| 名前 | name | テキスト | タグ名 | 不可 | 可 |
| 色 | color | カラー | タグの表示色 | 不可 | 不可 |

## イベント仕様

### 1-新規作成ボタン押下

ヘッダーの新規作成ボタン（CreateAction）をクリックすると、タグ作成モーダルダイアログが表示されます。名前と色を入力し、保存ボタンを押下するとレコードが作成されます。作成者IDは自動的に現在のログインユーザーが設定されます（mutateDataUsing）。作成成功時には成功通知が表示されます。

### 2-編集アクション

テーブル行の編集アイコンをクリックすると、タグ編集モーダルダイアログが表示されます。論理削除されたレコードでは非表示となります。編集成功時には成功通知が表示されます。

### 3-削除アクション

テーブル行の削除アイコンをクリックすると、確認ダイアログが表示され、確認後に該当レコードを論理削除します。削除成功時には成功通知が表示されます。

### 4-復元アクション

論理削除されたレコードの復元アイコンをクリックすると、該当レコードを復元します。復元成功時には成功通知が表示されます。

### 5-完全削除アクション

論理削除されたレコードの完全削除アイコンをクリックすると、確認ダイアログが表示され、確認後に該当レコードを物理削除します。

### 6-一括削除アクション

チェックボックスで複数レコードを選択し、一括削除ボタンをクリックすると、選択されたすべてのレコードを論理削除します。

### 7-一括復元アクション

チェックボックスで複数の論理削除済みレコードを選択し、一括復元ボタンをクリックすると、選択されたすべてのレコードを復元します。

### 8-一括完全削除アクション

チェックボックスで複数の論理削除済みレコードを選択し、一括完全削除ボタンをクリックすると、選択されたすべてのレコードを物理削除します。

### 9-タブ切替

タブをクリックすると、該当する条件でフィルタリングされた一覧が表示されます。
- 全件タブ：すべてのアクティブなタグを表示
- アーカイブ済みタブ：論理削除されたタグのみを表示（onlyTrashed）

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 一覧表示 | partners_tags | SELECT | タグ一覧を取得 |
| 新規作成 | partners_tags | INSERT | 新規レコードを作成 |
| 編集 | partners_tags | UPDATE | 指定レコードを更新 |
| 削除アクション | partners_tags | UPDATE | deleted_atを現在日時で更新（論理削除） |
| 復元アクション | partners_tags | UPDATE | deleted_atをNULLに更新 |
| 完全削除 | partners_tags | DELETE | 指定レコードを物理削除 |

### テーブル別更新項目詳細

#### partners_tags

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | - | 全件または検索条件に合致するレコード | - |
| INSERT | name | フォーム入力値 | 必須、ユニーク |
| INSERT | color | フォーム入力値 | HEXカラーコード |
| INSERT | creator_id | 現在のログインユーザーID | mutateDataUsing |
| INSERT | created_at | CURRENT_TIMESTAMP | - |
| INSERT | updated_at | CURRENT_TIMESTAMP | - |
| UPDATE | name | フォーム入力値 | - |
| UPDATE | color | フォーム入力値 | - |
| UPDATE | updated_at | CURRENT_TIMESTAMP | - |
| UPDATE（論理削除） | deleted_at | CURRENT_TIMESTAMP | SoftDeletes使用 |
| UPDATE（復元） | deleted_at | NULL | - |
| DELETE | - | 指定されたID | 物理削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| create.notification.title | 成功 | 作成成功タイトル | 作成成功時 |
| create.notification.body | 成功 | 作成成功メッセージ | 作成成功時 |
| edit.notification.title | 成功 | 編集成功タイトル | 編集成功時 |
| edit.notification.body | 成功 | 編集成功メッセージ | 編集成功時 |
| delete.notification.title | 成功 | 削除成功タイトル | 削除成功時 |
| delete.notification.body | 成功 | 削除成功メッセージ | 削除成功時 |
| restore.notification.title | 成功 | 復元成功タイトル | 復元成功時 |
| restore.notification.body | 成功 | 復元成功メッセージ | 復元成功時 |
| force-delete.notification.title | 成功 | 完全削除成功タイトル | 完全削除成功時 |
| force-delete.notification.body | 成功 | 完全削除成功メッセージ | 完全削除成功時 |
| bulk-delete.notification.title | 成功 | 一括削除成功タイトル | 一括削除成功時 |
| bulk-delete.notification.body | 成功 | 一括削除成功メッセージ | 一括削除成功時 |
| bulk-restore.notification.title | 成功 | 一括復元成功タイトル | 一括復元成功時 |
| bulk-restore.notification.body | 成功 | 一括復元成功メッセージ | 一括復元成功時 |
| bulk-force-delete.notification.title | 成功 | 一括完全削除成功タイトル | 一括完全削除成功時 |
| bulk-force-delete.notification.body | 成功 | 一括完全削除成功メッセージ | 一括完全削除成功時 |

## 例外処理

| 例外状況 | 対応処理 |
|---------|---------|
| データベース接続エラー | システムエラー画面を表示 |
| ユニーク制約違反（名前重複） | バリデーションエラーを表示 |
| 削除時の外部キー制約違反 | エラー通知を表示し、削除をキャンセル |
| 権限不足 | アクセス拒否画面を表示（FilamentShield） |
| レコードが存在しない | 404エラー画面を表示 |

## 備考

- 本画面はManageRecordsを継承しており、モーダルダイアログベースでのCRUD操作を提供しています。
- 論理削除（SoftDeletes）が実装されており、削除されたレコードの復元が可能です。
- タブ機能により、アクティブなタグとアーカイブ済みタグを簡単に切り替えられます。
- 各タブには件数バッジが表示され、該当するレコード数を即座に確認できます。
- 色はカラーピッカーで選択可能で、HEXカラーコードとして保存されます。
- 新規作成時、creator_idはmutateDataUsingによって自動的に現在のログインユーザーIDが設定されます。
- shouldRegisterNavigationがfalseに設定されているため、デフォルトではナビゲーションに表示されません。
- 国際化対応として、ラベルやメッセージはすべて多言語リソースファイル（`partners::filament/resources/tag`）から取得されます。
