# 画面設計書 211-銀行口座管理

## 概要

本ドキュメントは、Aureus ERPシステムのパートナーモジュールにおける「銀行口座管理」画面の設計仕様を定義します。

### 本画面の処理概要

本画面は、パートナー（取引先・顧客・仕入先）に紐づく銀行口座情報を一元的に管理するための画面です。Filament PHPのManageRecords機能を利用し、一覧表示・新規作成・編集・削除・アーカイブ管理を同一画面上で実行できます。

**業務上の目的・背景**：企業活動において、取引先への支払いや顧客からの入金を処理するために、正確な銀行口座情報の管理が不可欠です。本画面では、パートナーごとの銀行口座を登録・管理し、送金可否フラグによって支払処理に使用可能な口座を識別できます。これにより、経理・財務部門の支払業務効率化と誤送金リスクの低減を実現します。

**画面へのアクセス方法**：サイドメニューの「パートナー」モジュールから「設定」配下の「銀行口座管理」をクリックしてアクセスします。ナビゲーションには直接表示されず、設定画面群の一部として構成されています。

**主要な操作・処理内容**：
1. 銀行口座の一覧表示と検索・フィルタリング
2. 新規銀行口座の登録（口座番号、銀行、パートナー、送金可否を設定）
3. 既存銀行口座情報の編集
4. 銀行口座のソフトデリート（アーカイブ）
5. アーカイブされた銀行口座の復元または完全削除
6. 一括操作（復元・削除・完全削除）

**画面遷移**：本画面はManageRecords型のため、作成・編集はモーダルダイアログで行われ、画面遷移は発生しません。パートナー詳細画面からこの画面への遷移が可能です。

**権限による表示制御**：システムのロールおよび権限設定に基づき、表示・編集・削除の操作可否が制御されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PAR-003 | 銀行口座管理 | 主機能 | 銀行口座の一覧表示・作成・編集・削除 |
| FN-PAR-001 | パートナー一覧 | 遷移先機能 | パートナー選択時の参照 |

## 画面種別

管理（Manage）- 一覧表示と作成・編集・削除を統合した管理画面

## URL/ルーティング

```
/partners/bank-accounts
```

## 画面構成

- ヘッダーエリア
  - 画面タイトル
  - 新規作成ボタン（プラスアイコン付き）
- タブエリア
  - 「すべて」タブ（全件数をバッジ表示）
  - 「アーカイブ」タブ（アーカイブ件数をバッジ表示）
- テーブルエリア
  - 列の並び替え可能
  - グループ化対応
  - フィルタリング機能
- 一括操作エリア
  - 復元
  - 削除
  - 完全削除

## 入出力項目

### 入力項目（作成・編集フォーム）

| 項目名 | 項目ID | データ型 | 必須 | 最大長 | 入力形式 | 説明 |
|--------|--------|----------|------|--------|----------|------|
| 口座番号 | account_number | string | ○ | 255 | テキスト | 銀行口座番号（一意制約あり） |
| 送金可否 | can_send_money | boolean | - | - | トグル | この口座から送金可能かどうか |
| 銀行 | bank_id | integer | ○ | - | セレクト | 銀行マスタから選択（検索・新規作成可能） |
| 口座名義人 | partner_id | integer | ○ | - | セレクト | パートナーマスタから選択 |

## 表示項目

### テーブル表示項目

| 項目名 | 項目ID | データ型 | 検索 | ソート | 表示制御 | 説明 |
|--------|--------|----------|------|--------|----------|------|
| 口座番号 | account_number | string | ○ | ○ | 常時表示 | 銀行口座番号 |
| 銀行名 | bank.name | string | ○ | ○ | 常時表示 | 関連する銀行の名称 |
| 口座名義人 | partner.name | string | - | ○ | 常時表示 | パートナー名 |
| 送金可否 | can_send_money | boolean | - | ○ | 常時表示 | アイコンで表示 |
| 削除日時 | deleted_at | datetime | - | ○ | 非表示（トグル可） | ソフトデリート日時 |
| 作成日時 | created_at | datetime | - | ○ | 非表示（トグル可） | レコード作成日時 |
| 更新日時 | updated_at | datetime | - | ○ | 非表示（トグル可） | レコード更新日時 |

### グループ化オプション

| グループ名 | 項目ID | 説明 |
|------------|--------|------|
| 銀行 | bank.name | 銀行別にグループ化 |
| 送金可否 | can_send_money | 送金可否フラグ別にグループ化 |
| 作成日 | created_at | 作成日別にグループ化（日付単位） |

### フィルタオプション

| フィルタ名 | 項目ID | フィルタ種別 | 説明 |
|------------|--------|--------------|------|
| 送金可否 | can_send_money | 三項選択 | 送金可/不可/すべて |
| 銀行 | bank_id | リレーション選択 | 銀行で絞り込み |
| 口座名義人 | partner_id | リレーション選択 | パートナーで絞り込み |
| 作成者 | creator_id | リレーション選択 | 作成者で絞り込み |

## イベント仕様

### 1-新規作成ボタン押下

1. 作成モーダルダイアログが表示される
2. 必須項目を入力し保存ボタンを押下
3. バリデーションチェック実行
4. 成功時：データベースに新規レコード挿入、成功通知表示、一覧更新
5. 失敗時：エラーメッセージ表示

### 2-編集アクション押下

1. 対象レコードの編集モーダルダイアログが表示される
2. 既存データが入力欄にプリセット
3. 変更後保存ボタンを押下
4. バリデーションチェック実行
5. 成功時：データベースのレコード更新、成功通知表示、一覧更新

### 3-削除アクション押下

1. 確認ダイアログ表示
2. 確認後、ソフトデリート実行（deleted_atに日時設定）
3. 成功通知表示
4. 一覧から非表示（「アーカイブ」タブで表示）

### 4-復元アクション押下

1. アーカイブ済みレコードに対して実行可能
2. deleted_atをNULLに設定
3. 成功通知表示
4. 「すべて」タブに再表示

### 5-完全削除アクション押下

1. 確認ダイアログ表示
2. 確認後、物理削除実行
3. 成功通知表示
4. レコードが完全に削除

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | partners_bank_accounts | INSERT | 銀行口座情報の新規登録 |
| 編集 | partners_bank_accounts | UPDATE | 銀行口座情報の更新 |
| 削除（ソフト） | partners_bank_accounts | UPDATE | deleted_atカラムに日時を設定 |
| 復元 | partners_bank_accounts | UPDATE | deleted_atカラムをNULLに設定 |
| 完全削除 | partners_bank_accounts | DELETE | レコードの物理削除 |

### テーブル別更新項目詳細

#### partners_bank_accounts

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | account_number | フォーム入力値 | 一意制約あり |
| INSERT/UPDATE | can_send_money | フォーム入力値 | デフォルトfalse |
| INSERT/UPDATE | bank_id | フォーム入力値 | 銀行ID |
| INSERT/UPDATE | partner_id | フォーム入力値 | パートナーID |
| INSERT | creator_id | Auth::id() | 作成時に自動設定 |
| INSERT | account_holder_name | partner.name | bootメソッドで自動設定 |
| UPDATE（削除） | deleted_at | 現在日時 | ソフトデリート |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示タイミング |
|-------------|------|----------------|----------------|
| MSG-001 | 成功 | 銀行口座を作成しました | 新規作成成功時 |
| MSG-002 | 成功 | 銀行口座を更新しました | 編集成功時 |
| MSG-003 | 成功 | 銀行口座を削除しました | ソフトデリート成功時 |
| MSG-004 | 成功 | 銀行口座を復元しました | 復元成功時 |
| MSG-005 | 成功 | 銀行口座を完全に削除しました | 完全削除成功時 |
| MSG-006 | 成功 | 銀行口座を一括復元しました | 一括復元成功時 |
| MSG-007 | 成功 | 銀行口座を一括削除しました | 一括削除成功時 |
| MSG-008 | 成功 | 銀行口座を一括で完全削除しました | 一括完全削除成功時 |

## 例外処理

| 例外状況 | 対応処理 | ユーザーへの通知 |
|---------|---------|-----------------|
| 口座番号重複 | INSERT/UPDATE拒否 | バリデーションエラーメッセージ表示 |
| 必須項目未入力 | 保存処理中断 | 該当項目にエラーメッセージ表示 |
| 関連データ存在（完全削除時） | 削除処理中断 | 関連データ存在のエラーメッセージ表示 |
| 通信エラー | 処理中断 | エラー通知表示 |
| 権限不足 | アクション非表示/無効化 | アクションが表示されない |

## 備考

- 本画面はFilament PHPのManageRecordsクラスを継承して実装
- SoftDeletes対応により、削除したデータは「アーカイブ」タブで管理可能
- 銀行選択時、削除済み銀行も表示されるが選択不可（「(Deleted)」表示）
- 口座名義人（account_holder_name）はパートナー名から自動設定される
- 列の並び替え機能（reorderableColumns）が有効
