# 画面設計書 212-敬称管理

## 概要

本ドキュメントは、Aureus ERPシステムのパートナーモジュールにおける「敬称管理」画面の設計仕様を定義します。

### 本画面の処理概要

本画面は、パートナー（顧客・取引先）に対して使用する敬称（Mr.、Mrs.、Dr.など）を管理するための画面です。Filament PHPのManageRecords機能を利用し、敬称の一覧表示・新規作成・編集・削除を同一画面上で実行できるシンプルなマスタ管理画面です。

**業務上の目的・背景**：ビジネスにおいて、取引先や顧客への正式な文書・メール・請求書等で適切な敬称を使用することは、プロフェッショナルなコミュニケーションに不可欠です。本画面では、システム全体で使用する敬称のマスタデータを一元管理し、パートナー登録時に選択可能な敬称リストを提供します。

**画面へのアクセス方法**：サイドメニューの「パートナー」モジュールから「設定」配下の「敬称管理」をクリックしてアクセスします。ナビゲーションには直接表示されず、設定画面群の一部として構成されています。

**主要な操作・処理内容**：
1. 敬称の一覧表示と検索
2. 新規敬称の登録（名前と略称を設定）
3. 既存敬称情報の編集
4. 敬称の削除
5. 一括削除操作

**画面遷移**：本画面はManageRecords型のため、作成・編集はモーダルダイアログで行われ、画面遷移は発生しません。

**権限による表示制御**：システムのロールおよび権限設定に基づき、表示・編集・削除の操作可否が制御されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PAR-004 | 敬称管理 | 主機能 | 敬称の一覧表示・作成・編集・削除 |
| FN-PAR-001 | パートナー作成 | 使用元機能 | パートナー登録時の敬称選択 |

## 画面種別

管理（Manage）- 一覧表示と作成・編集・削除を統合した管理画面

## URL/ルーティング

```
/partners/titles
```

## 画面構成

- ヘッダーエリア
  - 画面タイトル
  - 新規作成ボタン
- テーブルエリア
  - 敬称一覧テーブル
  - 検索機能
- 一括操作エリア
  - 一括削除

## 入出力項目

### 入力項目（作成・編集フォーム）

| 項目名 | 項目ID | データ型 | 必須 | 最大長 | 入力形式 | 説明 |
|--------|--------|----------|------|--------|----------|------|
| 名前 | name | string | ○ | 255 | テキスト | 敬称のフルネーム（例：Mister, Doctor） |
| 略称 | short_name | string | ○ | 255 | テキスト | 敬称の略称（例：Mr., Dr.） |

## 表示項目

### テーブル表示項目

| 項目名 | 項目ID | データ型 | 検索 | ソート | 表示制御 | 説明 |
|--------|--------|----------|------|--------|----------|------|
| 名前 | name | string | ○ | - | 常時表示 | 敬称のフルネーム |
| 略称 | short_name | string | ○ | - | 常時表示 | 敬称の略称 |
| 作成日時 | created_at | datetime | - | ○ | 非表示（トグル可） | レコード作成日時 |
| 更新日時 | updated_at | datetime | - | ○ | 非表示（トグル可） | レコード更新日時 |

## イベント仕様

### 1-新規作成ボタン押下

1. 作成モーダルダイアログが表示される
2. 名前と略称を入力
3. 保存ボタンを押下
4. バリデーションチェック実行
5. 成功時：データベースに新規レコード挿入、成功通知表示、一覧更新
6. 失敗時：エラーメッセージ表示

### 2-編集アクション押下

1. 対象レコードの編集モーダルダイアログが表示される
2. 既存データが入力欄にプリセット
3. 変更後保存ボタンを押下
4. バリデーションチェック実行
5. 成功時：データベースのレコード更新、成功通知表示、一覧更新

### 3-削除アクション押下

1. 確認ダイアログ表示
2. 確認後、物理削除実行
3. 成功通知表示
4. 一覧から削除

### 4-一括削除アクション押下

1. 選択された複数レコードに対して確認ダイアログ表示
2. 確認後、物理削除実行
3. 成功通知表示
4. 一覧から削除

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | partners_titles | INSERT | 敬称情報の新規登録 |
| 編集 | partners_titles | UPDATE | 敬称情報の更新 |
| 削除 | partners_titles | DELETE | レコードの物理削除 |
| 一括削除 | partners_titles | DELETE | 複数レコードの物理削除 |

### テーブル別更新項目詳細

#### partners_titles

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | name | フォーム入力値 | 敬称フルネーム |
| INSERT/UPDATE | short_name | フォーム入力値 | 敬称略称 |
| INSERT | creator_id | Auth::id() | 作成時に自動設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示タイミング |
|-------------|------|----------------|----------------|
| MSG-001 | 成功 | 敬称を更新しました | 編集成功時 |
| MSG-002 | 成功 | 敬称を削除しました | 削除成功時 |
| MSG-003 | 成功 | 敬称を一括削除しました | 一括削除成功時 |

## 例外処理

| 例外状況 | 対応処理 | ユーザーへの通知 |
|---------|---------|-----------------|
| 必須項目未入力 | 保存処理中断 | 該当項目にエラーメッセージ表示 |
| 最大文字数超過 | 保存処理中断 | 文字数制限エラーメッセージ表示 |
| 関連データ存在（削除時） | 削除処理中断 | 関連データ存在のエラーメッセージ表示 |
| 通信エラー | 処理中断 | エラー通知表示 |

## 備考

- 本画面はFilament PHPのManageRecordsクラスを継承して実装
- SoftDeletesは使用していない（物理削除のみ）
- シンプルなマスタ管理画面として、最小限の機能で構成
- パートナー登録画面で敬称選択肢として利用される
