# 画面設計書 213-業種管理

## 概要

本ドキュメントは、Aureus ERPシステムのパートナーモジュールにおける「業種管理」画面の設計仕様を定義します。

### 本画面の処理概要

本画面は、パートナー（顧客・取引先）の業種情報を管理するための画面です。Filament PHPのManageRecords機能を利用し、業種の一覧表示・新規作成・編集・削除・アーカイブ管理を同一画面上で実行できます。

**業務上の目的・背景**：取引先の業種を分類・管理することで、業種別の営業戦略立案、業種特性に応じた与信管理、業界動向分析などのビジネスインサイトを得ることができます。本画面では、システム全体で使用する業種マスタを一元管理し、パートナー登録時に選択可能な業種リストを提供します。

**画面へのアクセス方法**：サイドメニューの「パートナー」モジュールから「設定」配下の「業種管理」をクリックしてアクセスします。ナビゲーションには直接表示されず、設定画面群の一部として構成されています。

**主要な操作・処理内容**：
1. 業種の一覧表示と検索・ソート
2. 新規業種の登録（名前と説明を設定）
3. 既存業種情報の編集
4. 業種のソフトデリート（アーカイブ）
5. アーカイブされた業種の復元または完全削除
6. 一括操作（復元・削除・完全削除）

**画面遷移**：本画面はManageRecords型のため、作成・編集はモーダルダイアログで行われ、画面遷移は発生しません。

**権限による表示制御**：システムのロールおよび権限設定に基づき、表示・編集・削除の操作可否が制御されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PAR-005 | 業種管理 | 主機能 | 業種の一覧表示・作成・編集・削除 |
| FN-PAR-001 | パートナー作成 | 使用元機能 | パートナー登録時の業種選択 |

## 画面種別

管理（Manage）- 一覧表示と作成・編集・削除を統合した管理画面

## URL/ルーティング

```
/partners/industries
```

## 画面構成

- ヘッダーエリア
  - 画面タイトル
  - 新規作成ボタン
- タブエリア
  - 「すべて」タブ
  - 「アーカイブ」タブ
- テーブルエリア
  - 業種一覧テーブル
  - 検索・ソート機能
- 一括操作エリア
  - 復元
  - 削除
  - 完全削除

## 入出力項目

### 入力項目（作成・編集フォーム）

| 項目名 | 項目ID | データ型 | 必須 | 最大長 | 入力形式 | 説明 |
|--------|--------|----------|------|--------|----------|------|
| 名前 | name | string | ○ | 255 | テキスト | 業種名（一意制約あり） |
| 説明 | description | string | ○ | 255 | テキスト | 業種の詳細説明（一意制約あり） |

## 表示項目

### テーブル表示項目

| 項目名 | 項目ID | データ型 | 検索 | ソート | 表示制御 | 説明 |
|--------|--------|----------|------|--------|----------|------|
| 名前 | name | string | ○ | ○ | 常時表示 | 業種名 |
| 説明 | description | string | ○ | ○ | 常時表示 | 業種の詳細説明 |

## イベント仕様

### 1-新規作成ボタン押下

1. 作成モーダルダイアログが表示される
2. 名前と説明を入力
3. 保存ボタンを押下
4. バリデーションチェック実行（一意制約含む）
5. 成功時：データベースに新規レコード挿入、成功通知表示、一覧更新
6. 失敗時：エラーメッセージ表示

### 2-編集アクション押下

1. 対象レコードの編集モーダルダイアログが表示される
2. 既存データが入力欄にプリセット
3. 変更後保存ボタンを押下
4. バリデーションチェック実行
5. 成功時：データベースのレコード更新、成功通知表示、一覧更新
6. 削除済みレコードの場合は編集アクションが非表示

### 3-削除アクション押下

1. 確認ダイアログ表示
2. 確認後、ソフトデリート実行（deleted_atに日時設定）
3. 成功通知表示
4. 一覧から非表示（「アーカイブ」タブで表示）

### 4-復元アクション押下

1. アーカイブ済みレコードに対して実行可能
2. deleted_atをNULLに設定
3. 成功通知表示
4. 「すべて」タブに再表示

### 5-完全削除アクション押下

1. 確認ダイアログ表示
2. 確認後、物理削除実行
3. 成功通知表示
4. レコードが完全に削除

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | partners_industries | INSERT | 業種情報の新規登録 |
| 編集 | partners_industries | UPDATE | 業種情報の更新 |
| 削除（ソフト） | partners_industries | UPDATE | deleted_atカラムに日時を設定 |
| 復元 | partners_industries | UPDATE | deleted_atカラムをNULLに設定 |
| 完全削除 | partners_industries | DELETE | レコードの物理削除 |

### テーブル別更新項目詳細

#### partners_industries

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | name | フォーム入力値 | 一意制約あり |
| INSERT/UPDATE | description | フォーム入力値 | 一意制約あり |
| INSERT | creator_id | Auth::id() | 作成時に自動設定 |
| UPDATE（削除） | deleted_at | 現在日時 | ソフトデリート |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示タイミング |
|-------------|------|----------------|----------------|
| MSG-001 | 成功 | 業種を更新しました | 編集成功時 |
| MSG-002 | 成功 | 業種を復元しました | 復元成功時 |
| MSG-003 | 成功 | 業種を削除しました | ソフトデリート成功時 |
| MSG-004 | 成功 | 業種を完全に削除しました | 完全削除成功時 |
| MSG-005 | 成功 | 業種を一括復元しました | 一括復元成功時 |
| MSG-006 | 成功 | 業種を一括削除しました | 一括削除成功時 |
| MSG-007 | 成功 | 業種を一括で完全削除しました | 一括完全削除成功時 |

## 例外処理

| 例外状況 | 対応処理 | ユーザーへの通知 |
|---------|---------|-----------------|
| 名前重複 | INSERT/UPDATE拒否 | バリデーションエラーメッセージ表示 |
| 説明重複 | INSERT/UPDATE拒否 | バリデーションエラーメッセージ表示 |
| 必須項目未入力 | 保存処理中断 | 該当項目にエラーメッセージ表示 |
| 最大文字数超過 | 保存処理中断 | 文字数制限エラーメッセージ表示 |
| 関連データ存在（完全削除時） | 削除処理中断 | 関連データ存在のエラーメッセージ表示 |

## 備考

- 本画面はFilament PHPのManageRecordsクラスを継承して実装
- SoftDeletes対応により、削除したデータは「アーカイブ」タブで管理可能
- nameとdescriptionの両方に一意制約があり、重複登録を防止
- 削除済みレコードに対しては編集アクションが非表示（hidden）となる
