# 画面設計書 214-銀行管理

## 概要

本ドキュメントは、Aureus ERPシステムのパートナーモジュールにおける「銀行管理」画面の設計仕様を定義します。

### 本画面の処理概要

本画面は、システムで使用する銀行情報を管理するための画面です。Filament PHPのManageRecords機能を利用し、銀行の一覧表示・新規作成・編集・削除・アーカイブ管理を同一画面上で実行できます。銀行口座管理で参照される銀行マスタとして機能します。

**業務上の目的・背景**：銀行送金・入出金処理において、取引先銀行の正確な情報管理は不可欠です。本画面では、銀行名、銀行コード、住所、連絡先などの銀行基本情報を一元管理し、銀行口座登録時に選択可能な銀行リストを提供します。

**画面へのアクセス方法**：サイドメニューの「パートナー」モジュールから「設定」配下の「銀行管理」をクリックしてアクセスします。ナビゲーションには直接表示されず、設定画面群の一部として構成されています。

**主要な操作・処理内容**：
1. 銀行の一覧表示と検索・ソート
2. 新規銀行の登録（基本情報と住所情報を設定）
3. 既存銀行情報の編集
4. 銀行のソフトデリート（アーカイブ）
5. アーカイブされた銀行の復元または完全削除
6. 一括操作（復元・削除・完全削除）

**画面遷移**：本画面はManageRecords型のため、作成・編集はモーダルダイアログで行われ、画面遷移は発生しません。

**権限による表示制御**：システムのロールおよび権限設定に基づき、表示・編集・削除の操作可否が制御されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PAR-006 | 銀行管理 | 主機能 | 銀行の一覧表示・作成・編集・削除 |
| FN-PAR-003 | 銀行口座管理 | 使用元機能 | 銀行口座登録時の銀行選択 |

## 画面種別

管理（Manage）- 一覧表示と作成・編集・削除を統合した管理画面

## URL/ルーティング

```
/partners/banks
```

## 画面構成

- ヘッダーエリア
  - 画面タイトル
  - 新規作成ボタン
- タブエリア
  - 「すべて」タブ
  - 「アーカイブ」タブ
- テーブルエリア
  - 銀行一覧テーブル
  - 検索・ソート機能
  - グループ化機能
- 一括操作エリア
  - 復元
  - 削除
  - 完全削除

## 入出力項目

### 入力項目（作成・編集フォーム）

#### 基本情報セクション

| 項目名 | 項目ID | データ型 | 必須 | 最大長 | 入力形式 | 説明 |
|--------|--------|----------|------|--------|----------|------|
| 銀行名 | name | string | ○ | 255 | テキスト | 銀行の正式名称 |
| 銀行コード | code | string | - | 255 | テキスト | 銀行識別コード（金融機関コード等） |
| メールアドレス | email | string | - | 255 | メール | 銀行の連絡先メールアドレス |
| 電話番号 | phone | string | - | 255 | 電話番号 | 銀行の連絡先電話番号 |

#### 住所セクション

| 項目名 | 項目ID | データ型 | 必須 | 最大長 | 入力形式 | 説明 |
|--------|--------|----------|------|--------|----------|------|
| 国 | country_id | integer | - | - | セレクト | 国マスタから選択（検索可能・連動） |
| 都道府県/州 | state_id | integer | - | - | セレクト | 選択した国に紐づく都道府県/州から選択 |
| 住所1 | street1 | string | - | 255 | テキスト | 番地等 |
| 住所2 | street2 | string | - | 255 | テキスト | 建物名等 |
| 市区町村 | city | string | - | 255 | テキスト | 市区町村名 |
| 郵便番号 | zip | string | - | 255 | テキスト | 郵便番号 |

## 表示項目

### テーブル表示項目

| 項目名 | 項目ID | データ型 | 検索 | ソート | 表示制御 | 説明 |
|--------|--------|----------|------|--------|----------|------|
| 銀行名 | name | string | ○ | ○ | 常時表示 | 銀行の正式名称 |
| 銀行コード | code | string | ○ | ○ | 常時表示 | 銀行識別コード |
| 国 | country.name | string | - | ○ | 常時表示 | 銀行所在国 |
| 削除日時 | deleted_at | datetime | - | ○ | 非表示（トグル可） | ソフトデリート日時 |
| 作成日時 | created_at | datetime | - | ○ | 非表示（トグル可） | レコード作成日時 |
| 更新日時 | updated_at | datetime | - | ○ | 非表示（トグル可） | レコード更新日時 |

### グループ化オプション

| グループ名 | 項目ID | 説明 |
|------------|--------|------|
| 国 | country.name | 国別にグループ化 |
| 作成日 | created_at | 作成日別にグループ化（日付単位） |

## イベント仕様

### 1-新規作成ボタン押下

1. 作成モーダルダイアログが表示される（2セクション構成）
2. 基本情報と住所情報を入力
3. 保存ボタンを押下
4. バリデーションチェック実行
5. 成功時：データベースに新規レコード挿入、成功通知表示、一覧更新
6. 失敗時：エラーメッセージ表示

### 2-国選択変更

1. 国セレクトボックスの選択を変更
2. 都道府県/州セレクトボックスがリセット（null）
3. 選択した国に紐づく都道府県/州リストが読み込まれる

### 3-編集アクション押下

1. 対象レコードの編集モーダルダイアログが表示される
2. 既存データが入力欄にプリセット
3. 変更後保存ボタンを押下
4. バリデーションチェック実行
5. 成功時：データベースのレコード更新、成功通知表示、一覧更新
6. 削除済みレコードの場合は編集アクションが非表示

### 4-削除アクション押下

1. 確認ダイアログ表示
2. 確認後、ソフトデリート実行（deleted_atに日時設定）
3. 成功通知表示
4. 一覧から非表示（「アーカイブ」タブで表示）

### 5-復元アクション押下

1. アーカイブ済みレコードに対して実行可能
2. deleted_atをNULLに設定
3. 成功通知表示
4. 「すべて」タブに再表示

### 6-完全削除アクション押下

1. 確認ダイアログ表示
2. 確認後、物理削除実行
3. 成功通知表示
4. レコードが完全に削除

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 新規作成 | banks | INSERT | 銀行情報の新規登録 |
| 編集 | banks | UPDATE | 銀行情報の更新 |
| 削除（ソフト） | banks | UPDATE | deleted_atカラムに日時を設定 |
| 復元 | banks | UPDATE | deleted_atカラムをNULLに設定 |
| 完全削除 | banks | DELETE | レコードの物理削除 |

### テーブル別更新項目詳細

#### banks

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | name | フォーム入力値 | 必須 |
| INSERT/UPDATE | code | フォーム入力値 | 銀行コード |
| INSERT/UPDATE | email | フォーム入力値 | メールアドレス |
| INSERT/UPDATE | phone | フォーム入力値 | 電話番号 |
| INSERT/UPDATE | country_id | フォーム入力値 | 国ID |
| INSERT/UPDATE | state_id | フォーム入力値 | 都道府県/州ID |
| INSERT/UPDATE | street1 | フォーム入力値 | 住所1 |
| INSERT/UPDATE | street2 | フォーム入力値 | 住所2 |
| INSERT/UPDATE | city | フォーム入力値 | 市区町村 |
| INSERT/UPDATE | zip | フォーム入力値 | 郵便番号 |
| INSERT | creator_id | Auth::id() | 作成時に自動設定 |
| UPDATE（削除） | deleted_at | 現在日時 | ソフトデリート |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示タイミング |
|-------------|------|----------------|----------------|
| MSG-001 | 成功 | 銀行を更新しました | 編集成功時 |
| MSG-002 | 成功 | 銀行を復元しました | 復元成功時 |
| MSG-003 | 成功 | 銀行を削除しました | ソフトデリート成功時 |
| MSG-004 | 成功 | 銀行を完全に削除しました | 完全削除成功時 |
| MSG-005 | 成功 | 銀行を一括復元しました | 一括復元成功時 |
| MSG-006 | 成功 | 銀行を一括削除しました | 一括削除成功時 |
| MSG-007 | 成功 | 銀行を一括で完全削除しました | 一括完全削除成功時 |

## 例外処理

| 例外状況 | 対応処理 | ユーザーへの通知 |
|---------|---------|-----------------|
| 必須項目未入力 | 保存処理中断 | 該当項目にエラーメッセージ表示 |
| メールアドレス形式不正 | 保存処理中断 | バリデーションエラーメッセージ表示 |
| 電話番号形式不正 | 保存処理中断 | バリデーションエラーメッセージ表示 |
| 関連データ存在（完全削除時） | 削除処理中断 | 関連データ存在のエラーメッセージ表示 |

## 備考

- 本画面はFilament PHPのManageRecordsクラスを継承して実装
- SoftDeletes対応により、削除したデータは「アーカイブ」タブで管理可能
- 国と都道府県/州は連動選択（国選択時に都道府県/州リストがフィルタリング）
- creator_idはHiddenフィールドで現在ログインユーザーのIDが自動設定される
- 削除済みレコードに対しては編集アクションが非表示（hidden）となる
- フォームは2カラムレイアウトで表示される
