# 画面設計書 215-プラグイン一覧

## 概要

本ドキュメントは、Aureus ERPシステムのプラグインマネージャーモジュールにおける「プラグイン一覧」画面の設計仕様を定義します。

### 本画面の処理概要

本画面は、システムに登録されているプラグインの一覧表示と、プラグインのインストール・アンインストールを管理するための画面です。グリッドレイアウトでプラグインカード形式で表示され、各プラグインの状態確認や操作が可能です。

**業務上の目的・背景**：Aureus ERPはプラグインアーキテクチャを採用しており、必要な機能モジュールを選択的にインストール・有効化できます。本画面では、利用可能なプラグインの一覧表示、インストール状態の確認、プラグインのインストール・アンインストール操作を提供し、システムの機能拡張を柔軟に管理できます。

**画面へのアクセス方法**：サイドメニューの「設定」または「プラグイン管理」からアクセスします。

**主要な操作・処理内容**：
1. プラグインの一覧表示（グリッドカード形式）
2. プラグインの詳細表示（モーダルダイアログ）
3. プラグインのインストール
4. プラグインのアンインストール
5. プラグイン表示順序の変更（ドラッグ＆ドロップ）

**画面遷移**：本画面はListRecords型で、詳細表示はモーダルダイアログで行われます。

**権限による表示制御**：システム管理者権限を持つユーザーのみがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PLG-001 | プラグイン管理 | 主機能 | プラグインの一覧表示・インストール・アンインストール |

## 画面種別

一覧（List）- グリッドカード形式の一覧表示画面

## URL/ルーティング

```
/plugin-manager/plugins
```

## 画面構成

- ヘッダーエリア
  - 画面タイトル
- グリッドエリア
  - プラグインカード（レスポンシブグリッド）
    - sm: 1列
    - md: 2列
    - lg: 2列
    - xl: 3列
    - 2xl: 4列
- ページネーション
  - 16, 24, 32件表示切替

## プラグインカード表示項目

### カード表示項目

| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| アイコン | id（SVG参照） | image | プラグインアイコン（100x100px） |
| プラグイン名 | name | string | プラグイン名（大文字始まり） |
| バージョン | latest_version | string | バージョン番号（バッジ表示、デフォルト1.0.0） |
| 概要 | summary | string | プラグイン概要（最大80文字、折り返し） |
| インストール状態 | is_installed | boolean | インストール済み/未インストール（バッジ表示） |
| 依存関係数 | dependencies_count | integer | 依存プラグイン数（バッジ表示） |

### 詳細表示（Infolist）項目

| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| プラグイン名 | name | string | プラグイン名（太字・大サイズ） |
| バージョン | latest_version | string | バージョン番号（バッジ、info色） |
| インストール状態 | is_installed | boolean | アイコン表示（チェック/バツ） |
| 作成者 | author | string | 作成者名（バッジ表示） |
| ライセンス | license | string | ライセンス種別（バッジ、success色、デフォルトMIT） |
| 概要 | summary | string | プラグイン概要（全幅） |
| 依存プラグイン | dependencies | array | 依存プラグイン一覧（名前、インストール状態） |
| 依存されているプラグイン | dependents | array | このプラグインに依存するプラグイン一覧 |

## イベント仕様

### 1-プラグイン表示アクション押下

1. プラグイン詳細のモーダルダイアログが表示される
2. 基本情報と依存関係が表示される
3. インストール/アンインストール状態に応じたアクションが表示される

### 2-インストールアクション押下

1. 確認ダイアログが表示される
   - タイトル：「{プラグイン名}をインストール」
   - 説明：インストールの確認メッセージ
2. 確認後、artisanコマンド `{plugin_name}:install` を実行
3. 成功時：
   - is_installed、is_activeをtrueに更新
   - 成功通知表示
   - 画面リダイレクト（リフレッシュ）
4. 失敗時：
   - エラー通知表示（persistent）

### 3-アンインストールアクション押下

1. 確認モーダルが表示される（ExtraLargeサイズ）
   - 依存プラグイン一覧
   - 影響を受けるテーブルとレコード数
2. 確認後、以下の処理を実行：
   - 依存プラグインのダウンマイグレーション実行
   - 対象プラグインのダウンマイグレーション実行
   - 設定のダウンマイグレーション実行
   - is_installed、is_activeをfalseに更新
3. 成功時：成功通知表示、画面リダイレクト
4. 失敗時：エラー通知表示（persistent）

### 4-並び替え操作

1. プラグインカードをドラッグ＆ドロップ
2. sortカラムの値が更新される

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| インストール | plugins | UPDATE | is_installed, is_activeをtrueに設定 |
| アンインストール | plugins | UPDATE | is_installed, is_activeをfalseに設定 |
| アンインストール | migrations | DELETE | マイグレーション履歴を削除 |
| 並び替え | plugins | UPDATE | sortカラムを更新 |

### テーブル別更新項目詳細

#### plugins

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| インストール | is_installed | true | インストール状態フラグ |
| インストール | is_active | true | 有効化フラグ |
| アンインストール | is_installed | false | インストール状態フラグ |
| アンインストール | is_active | false | 有効化フラグ |
| 並び替え | sort | 新しい順序値 | 表示順序 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示タイミング |
|-------------|------|----------------|----------------|
| MSG-001 | 成功 | プラグインがインストールされました | インストール成功時 |
| MSG-002 | エラー | インストールに失敗しました | インストール失敗時 |
| MSG-003 | 成功 | プラグインがアンインストールされました | アンインストール成功時 |
| MSG-004 | エラー | アンインストールに失敗しました | アンインストール失敗時 |

## 例外処理

| 例外状況 | 対応処理 | ユーザーへの通知 |
|---------|---------|-----------------|
| インストールコマンド実行失敗 | ロールバック | エラー通知（詳細メッセージ）表示 |
| マイグレーションダウン失敗 | 処理中断 | エラー通知（詳細メッセージ）表示 |
| パッケージ情報取得失敗 | 処理中断 | エラー通知表示 |
| 依存プラグイン未インストール | 警告表示 | アンインストールモーダルに表示 |

## 備考

- 本画面はFilament PHPのListRecordsクラスを継承して実装
- 除外プラグイン（accounts、products、payments、full-calendar）は一覧に表示されない
- コアプラグイン（isCore=true）も一覧に表示されない
- プラグインアイコンは `/svg/{icon}.svg` から取得
- アンインストール時は依存プラグインも連鎖的にアンインストールされる
- マイグレーションファイルからテーブル名を正規表現で抽出し、影響データ数を表示
- 並び替え機能はsortカラムを使用したSortableTraitで実装
- デフォルトソート：sort昇順
- ページネーション：16, 24, 32件から選択可能
