# 画面設計書 216-商品一覧

## 概要

本ドキュメントは、Aureus ERPシステムの商品モジュールにおける「商品一覧」画面の設計仕様を定義します。

### 本画面の処理概要

本画面は、システムに登録されている商品（製品・サービス）の一覧を表示し、商品の検索・フィルタリング・操作を行うための画面です。TableViews機能によるプリセットビュー（タブ）を活用し、商品タイプ別の絞り込みや、お気に入り・アーカイブ済み商品の管理が可能です。

**業務上の目的・背景**：商品は企業活動の中核を成す重要なマスタデータです。本画面では、販売・購買・在庫管理で使用される商品情報を一元的に管理し、効率的な商品検索と運用を支援します。商品タイプ（物品/サービス）による分類、お気に入り機能、高度なフィルタリング機能を提供します。

**画面へのアクセス方法**：サイドメニューの「商品」モジュールから「商品一覧」をクリックしてアクセスします。

**主要な操作・処理内容**：
1. 商品の一覧表示（親商品のみ、バリアントは除外）
2. プリセットビューによるタブ切り替え（物品/サービス/お気に入り/アーカイブ）
3. 高度なフィルタリング（QueryBuilder）
4. 商品の表示・編集・削除
5. 一括印刷（バーコードラベル）
6. ソフトデリート/復元/完全削除
7. ドラッグ＆ドロップによる並び替え

**画面遷移**：
- 新規作成ボタン → 商品作成画面
- 表示アクション → 商品詳細画面
- 編集アクション → 商品編集画面

**権限による表示制御**：システムのロールおよび権限設定に基づき、表示・編集・削除の操作可否が制御されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PRD-001 | 商品管理 | 主機能 | 商品の一覧表示・検索・フィルタリング |
| FN-PRD-002 | 商品作成 | 遷移先機能 | 新規商品の登録 |
| FN-PRD-003 | 商品編集 | 遷移先機能 | 商品情報の編集 |
| FN-PRD-004 | 商品詳細 | 遷移先機能 | 商品情報の閲覧 |

## 画面種別

一覧（List）- テーブル形式の一覧表示画面

## URL/ルーティング

```
/products/products
```

## 画面構成

- ヘッダーエリア
  - 画面タイトル
  - 新規作成ボタン（プラスアイコン付き）
- タブエリア（プリセットビュー）
  - 「物品」タブ（お気に入り、デフォルト）
  - 「サービス」タブ（お気に入り）
  - 「お気に入り」タブ（お気に入り）
  - 「アーカイブ」タブ（お気に入り）
- フィルタエリア
  - フィルタトリガーボタン（スライドオーバー表示）
- テーブルエリア
  - 列の並び替え可能
  - 列の表示/非表示切り替え（2カラム管理）
  - グループ化機能
  - ドラッグ＆ドロップ並び替え
- 一括操作エリア
  - 印刷
  - 復元
  - 削除
  - 完全削除

## プリセットビュー（タブ）

| ビュー名 | アイコン | フィルタ条件 | デフォルト |
|---------|---------|-------------|-----------|
| 物品 | heroicon-s-squares-plus | type = GOODS | ○ |
| サービス | heroicon-s-sparkles | type = SERVICE | - |
| お気に入り | heroicon-s-star | is_favorite = true | - |
| アーカイブ | heroicon-s-archive-box | onlyTrashed() | - |

## 表示項目

### テーブル表示項目

| 項目名 | 項目ID | データ型 | 検索 | ソート | 表示制御 | 説明 |
|--------|--------|----------|------|--------|----------|------|
| お気に入り | is_favorite | boolean | - | - | 常時表示 | 星アイコン、クリックでトグル |
| 画像 | images | array | - | - | 常時表示 | 円形、スタック表示、最大3枚 |
| 商品名 | name | string | ○ | ○ | 常時表示 | 商品の名称 |
| バリアント数 | variants_count | integer | - | ○ | 常時表示 | 関連バリアント数 |
| 参照コード | reference | string | ○ | ○ | 常時表示 | 商品参照コード |
| タグ | tags.name | string | - | - | トグル表示 | バッジ形式で表示 |
| 担当者 | responsible.name | string | - | ○ | 非表示（トグル可） | 商品担当者 |
| バーコード | barcode | string | ○ | ○ | 非表示（トグル可） | 商品バーコード |
| 会社 | company.name | string | - | ○ | 非表示（トグル可） | 所属会社 |
| 販売価格 | price | decimal | - | ○ | 常時表示 | 販売単価 |
| 原価 | cost | decimal | - | ○ | 常時表示 | 仕入原価 |
| カテゴリ | category.name | string | - | ○ | 非表示（トグル可） | 商品カテゴリ |
| タイプ | type | enum | - | ○ | 非表示（トグル可） | 物品/サービス |
| 削除日時 | deleted_at | datetime | - | ○ | 非表示（トグル可） | ソフトデリート日時 |
| 作成日時 | created_at | datetime | - | ○ | 非表示（トグル可） | レコード作成日時 |
| 更新日時 | updated_at | datetime | - | ○ | 非表示（トグル可） | レコード更新日時 |

### グループ化オプション

| グループ名 | 項目ID | 説明 |
|------------|--------|------|
| タイプ | type | 商品タイプ別にグループ化 |
| カテゴリ | category.name | カテゴリ別にグループ化 |
| 作成日 | created_at | 作成日別にグループ化（日付単位） |

### フィルタオプション（QueryBuilder）

| フィルタ名 | 項目ID | フィルタ種別 | アイコン |
|------------|--------|--------------|---------|
| 商品名 | name | テキスト制約 | - |
| 参照コード | reference | テキスト制約 | heroicon-o-link |
| バーコード | barcode | テキスト制約 | heroicon-o-bars-4 |
| お気に入り | is_favorite | ブーリアン制約 | heroicon-o-star |
| 販売価格 | price | 数値制約 | heroicon-o-banknotes |
| 原価 | cost | 数値制約 | heroicon-o-banknotes |
| 重量 | weight | 数値制約 | heroicon-o-scale |
| 体積 | volume | 数値制約 | heroicon-o-beaker |
| タイプ | type | 選択制約（複数） | heroicon-o-queue-list |
| タグ | tags | リレーション制約 | heroicon-o-tag |
| 作成日時 | created_at | 日付制約 | - |
| 更新日時 | updated_at | 日付制約 | - |
| 担当者 | responsible | リレーション制約 | heroicon-o-user |
| 会社 | company | リレーション制約 | heroicon-o-building-office |
| 作成者 | creator | リレーション制約 | heroicon-o-user |

## イベント仕様

### 1-新規作成ボタン押下

1. 商品作成画面（/products/products/create）へ遷移

### 2-お気に入りアイコンクリック

1. 対象商品のis_favoriteをトグル
2. 即座にデータベース更新
3. アイコン表示が切り替わる（塗りつぶし/アウトライン）

### 3-表示アクション押下

1. 商品詳細画面（/products/products/{id}）へ遷移
2. 削除済みレコードの場合は非表示

### 4-編集アクション押下

1. 商品編集画面（/products/products/{id}/edit）へ遷移
2. 削除済みレコードの場合は非表示

### 5-削除アクション押下

1. 確認ダイアログ表示
2. ソフトデリート実行
3. 成功通知表示
4. 「アーカイブ」タブに移動

### 6-復元アクション押下

1. アーカイブ済みレコードに対して実行
2. deleted_atをNULLに設定
3. 成功通知表示

### 7-完全削除アクション押下

1. 確認ダイアログ表示
2. 物理削除を試行
3. 成功時：成功通知表示
4. 失敗時（参照整合性違反）：エラー通知表示

### 8-印刷アクション押下

1. 印刷設定フォームがモーダル表示
   - 印刷枚数（1〜100）
   - フォーマット選択（dymo/2x7価格/4x7価格/4x12/4x12価格）
2. 設定後、PDFを生成・ダウンロード

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| お気に入りトグル | products_products | UPDATE | is_favoriteを反転 |
| 削除（ソフト） | products_products | UPDATE | deleted_atに日時設定 |
| 復元 | products_products | UPDATE | deleted_atをNULLに設定 |
| 完全削除 | products_products | DELETE | レコードの物理削除 |
| 並び替え | products_products | UPDATE | sortカラムを更新 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示タイミング |
|-------------|------|----------------|----------------|
| MSG-001 | 成功 | 商品を復元しました | 復元成功時 |
| MSG-002 | 成功 | 商品を削除しました | ソフトデリート成功時 |
| MSG-003 | 成功 | 商品を完全に削除しました | 完全削除成功時 |
| MSG-004 | エラー | 商品を削除できません。関連データが存在します | 完全削除失敗時 |
| MSG-005 | 成功 | 商品を一括復元しました | 一括復元成功時 |
| MSG-006 | 成功 | 商品を一括削除しました | 一括削除成功時 |
| MSG-007 | 成功 | 商品を一括で完全削除しました | 一括完全削除成功時 |
| MSG-008 | エラー | 一部の商品を削除できませんでした | 一括完全削除失敗時 |

## 例外処理

| 例外状況 | 対応処理 | ユーザーへの通知 |
|---------|---------|-----------------|
| 完全削除時の参照整合性違反 | 削除処理キャンセル | エラー通知表示 |
| 一括完全削除時の部分失敗 | 処理キャンセル | エラー通知表示 |
| PDF生成失敗 | 処理中断 | エラー通知表示 |

## 備考

- 本画面はFilament PHPのListRecordsクラスを継承し、HasTableViewsトレイトを使用
- 一覧には親商品のみ表示（parent_id = null）、バリアントは除外
- SoftDeletes対応により、削除したデータは「アーカイブ」タブで管理可能
- 列の並び替え機能（reorderableColumns）が有効
- 列の表示管理は2カラムレイアウト（columnManagerColumns(2)）
- フィルタはモーダル形式でスライドオーバー表示
- 印刷機能はDomPDFライブラリを使用
- デフォルトソート：sort降順
- ドラッグ＆ドロップ並び替えはsortカラムを使用
