# 画面設計書 217-商品作成

## 概要

本ドキュメントは、Aureus ERPシステムの商品モジュールにおける「商品作成」画面の設計仕様を定義します。

### 本画面の処理概要

本画面は、新規商品（製品・サービス）を登録するための画面です。商品の基本情報、画像、在庫関連情報、価格情報、設定情報を入力し、商品マスタに登録します。

**業務上の目的・背景**：商品は販売・購買・在庫管理の基礎となる重要なマスタデータです。本画面では、商品の各種属性（名前、説明、タイプ、価格、カテゴリ等）を設定し、システムに新規登録します。物品タイプの場合は在庫管理用の追加情報（重量・体積）も設定可能です。

**画面へのアクセス方法**：商品一覧画面の「新規作成」ボタンをクリック、またはURL直接アクセス。

**主要な操作・処理内容**：
1. 商品基本情報の入力（名前、説明、タグ）
2. 商品画像のアップロード
3. 在庫情報の設定（物品タイプのみ：重量・体積）
4. 設定情報の入力（タイプ、参照コード、バーコード、カテゴリ、会社）
5. 価格情報の入力（販売価格、原価）
6. 登録完了後、商品詳細画面へ遷移

**画面遷移**：
- 前の画面 ← 商品一覧画面
- 次の画面 → 商品詳細画面（登録成功時）

**権限による表示制御**：商品作成権限を持つユーザーのみがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PRD-002 | 商品作成 | 主機能 | 商品の新規登録 |
| FN-PRD-001 | 商品一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-PRD-004 | 商品詳細 | 遷移先機能 | 登録完了後の遷移先 |

## 画面種別

作成（Create）- 新規レコード作成画面

## URL/ルーティング

```
/products/products/create
```

## 画面構成

- ヘッダーエリア
  - 画面タイトル
  - 保存ボタン
- メインコンテンツエリア（3カラムレイアウト）
  - 左側エリア（2カラム分）
    - 基本情報セクション
    - 画像セクション
    - 在庫セクション（物品タイプのみ表示）
  - 右側エリア（1カラム分）
    - 設定セクション
    - 価格セクション

## 入出力項目

### 基本情報セクション

| 項目名 | 項目ID | データ型 | 必須 | 最大長 | 入力形式 | 説明 |
|--------|--------|----------|------|--------|----------|------|
| 商品名 | name | string | ○ | 255 | テキスト | 商品の名称（大きめフォント、オートフォーカス） |
| 説明 | description | string | - | - | リッチエディタ | 商品の詳細説明（HTML対応） |
| タグ | tags | array | - | - | マルチセレクト | 商品タグ（複数選択可、新規作成可能） |

### 画像セクション

| 項目名 | 項目ID | データ型 | 必須 | 最大長 | 入力形式 | 説明 |
|--------|--------|----------|------|--------|----------|------|
| 商品画像 | images | array | - | - | ファイルアップロード | 商品画像（複数アップロード可） |

### 在庫セクション（物品タイプのみ）

| 項目名 | 項目ID | データ型 | 必須 | 最大長 | 入力形式 | 説明 |
|--------|--------|----------|------|--------|----------|------|
| 重量 | weight | decimal | - | - | 数値 | 商品重量（0〜99999999999） |
| 体積 | volume | decimal | - | - | 数値 | 商品体積（0〜99999999999） |

### 設定セクション

| 項目名 | 項目ID | データ型 | 必須 | 最大長 | 入力形式 | 説明 |
|--------|--------|----------|------|--------|----------|------|
| タイプ | type | enum | - | - | ラジオボタン | 物品/サービス（デフォルト：物品） |
| 参照コード | reference | string | - | 255 | テキスト | 商品参照コード |
| バーコード | barcode | string | - | 255 | テキスト | 商品バーコード |
| カテゴリ | category_id | integer | ○ | - | セレクト | 商品カテゴリ（検索可能、新規作成可能） |
| 会社 | company_id | integer | - | - | セレクト | 所属会社（削除済みも表示、選択不可） |

### 価格セクション

| 項目名 | 項目ID | データ型 | 必須 | 最大長 | 入力形式 | 説明 |
|--------|--------|----------|------|--------|----------|------|
| 販売価格 | price | decimal | ○ | - | 数値 | 販売単価（デフォルト0.00、0以上） |
| 原価 | cost | decimal | - | - | 数値 | 仕入原価（デフォルト0.00、0以上） |

### 隠しフィールド

| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| 単位ID | uom_id | integer | デフォルトUOMのID |
| 購買単位ID | uom_po_id | integer | デフォルトUOMのID |

## イベント仕様

### 1-タイプ選択変更

1. ラジオボタンで「物品」または「サービス」を選択
2. 「物品」選択時：在庫セクションが表示される
3. 「サービス」選択時：在庫セクションが非表示になる
4. フォームが動的に再描画（live()）

### 2-カテゴリ選択

1. セレクトボックスでカテゴリを選択
2. 検索可能（searchable）
3. プリロード済み（preload）
4. 新規作成可能（createOptionForm）

### 3-会社選択

1. セレクトボックスで会社を選択
2. 削除済み会社も表示される（withTrashed）
3. 削除済み会社は「(Deleted)」表示で選択不可
4. デフォルト：ログインユーザーのデフォルト会社

### 4-タグ選択

1. マルチセレクトでタグを選択
2. 複数選択可能
3. 検索可能
4. 新規タグ作成可能（products_tagsテーブルに追加）

### 5-画像アップロード

1. ファイル選択ダイアログを開く
2. 画像ファイルを選択（複数可）
3. アップロード完了後、プレビュー表示

### 6-保存ボタン押下

1. バリデーションチェック実行
2. 成功時：
   - creator_idに現在ログインユーザーIDを設定
   - データベースに新規レコード挿入
   - 成功通知表示
   - 商品詳細画面へリダイレクト
3. 失敗時：エラーメッセージ表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 商品保存 | products_products | INSERT | 商品情報の新規登録 |
| タグ関連付け | products_product_tag | INSERT | 商品とタグの関連付け |

### テーブル別更新項目詳細

#### products_products

| 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----------------|-----------------|------|
| name | フォーム入力値 | 必須 |
| description | フォーム入力値 | リッチテキスト |
| type | フォーム入力値 | デフォルトGOODS |
| reference | フォーム入力値 | 参照コード |
| barcode | フォーム入力値 | バーコード |
| price | フォーム入力値 | デフォルト0.00 |
| cost | フォーム入力値 | デフォルト0.00 |
| weight | フォーム入力値 | 物品タイプのみ |
| volume | フォーム入力値 | 物品タイプのみ |
| images | フォーム入力値 | JSON配列 |
| category_id | フォーム入力値 | 必須 |
| company_id | フォーム入力値 | 会社ID |
| uom_id | UOM::first()->id | デフォルト単位 |
| uom_po_id | UOM::first()->id | デフォルト購買単位 |
| creator_id | Auth::id() | mutateFormDataBeforeCreateで設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示タイミング |
|-------------|------|----------------|----------------|
| MSG-001 | 成功 | 商品を作成しました | 作成成功時 |

## 例外処理

| 例外状況 | 対応処理 | ユーザーへの通知 |
|---------|---------|-----------------|
| 必須項目未入力 | 保存処理中断 | 該当項目にエラーメッセージ表示 |
| 画像アップロード失敗 | アップロード中断 | エラーメッセージ表示 |
| カテゴリ未存在 | 保存処理中断 | エラーメッセージ表示 |
| データベースエラー | ロールバック | エラー通知表示 |

## 備考

- 本画面はFilament PHPのCreateRecordクラスを継承して実装
- 作成成功後、商品詳細画面（ViewProduct）へリダイレクト
- creator_idはmutateFormDataBeforeCreateメソッドで自動設定
- フォームは3カラムレイアウト（左2:右1）
- 在庫セクションは商品タイプが「物品」の場合のみ表示（visible条件）
- タグは新規作成可能で、一意制約（products_tags）あり
- 会社選択では削除済み会社も表示されるが選択不可（disableOptionWhen）
- カテゴリのデフォルト値はCategory::first()のID
- UOMのデフォルト値はUOM::first()のID
