# 画面設計書 218-商品編集

## 概要

本ドキュメントは、Aureus ERPシステムの商品モジュールにおける「商品編集」画面の設計仕様を定義します。

### 本画面の処理概要

本画面は、既存の商品（製品・サービス）情報を編集・更新するための画面です。商品作成画面と同様のフォーム構成で、既存データを編集できます。また、バーコードラベル印刷、チャッター（コミュニケーション機能）、削除操作も可能です。

**業務上の目的・背景**：商品情報は販売価格の変更、説明文の更新、カテゴリ変更など、運用中に頻繁に更新が必要です。本画面では、商品の各種属性を効率的に編集し、関連するバリアント商品への情報伝播も自動的に行います。

**画面へのアクセス方法**：商品一覧画面または商品詳細画面から「編集」アクションをクリック。

**主要な操作・処理内容**：
1. 商品情報の編集（作成画面と同様のフィールド）
2. バーコードラベル印刷
3. チャッター機能（コメント・メモ・活動ログ）
4. 商品の削除
5. バリアント商品への情報伝播（is_storable）

**画面遷移**：
- 前の画面 ← 商品一覧画面 / 商品詳細画面
- 次の画面 → 商品詳細画面（保存成功時）

**権限による表示制御**：商品編集権限を持つユーザーのみがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PRD-003 | 商品編集 | 主機能 | 商品情報の更新 |
| FN-PRD-001 | 商品一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-PRD-004 | 商品詳細 | 遷移元/先機能 | 詳細画面からの遷移、保存後の遷移先 |

## 画面種別

編集（Edit）- 既存レコード編集画面

## URL/ルーティング

```
/products/products/{record}/edit
```

## 画面構成

- ヘッダーエリア
  - 画面タイトル
  - ヘッダーアクション
    - チャッターボタン
    - 印刷ボタン
    - 削除ボタン
  - 保存ボタン
- サブナビゲーション（レコードナビゲーションタブ）
- メインコンテンツエリア（3カラムレイアウト）
  - 商品作成画面と同様のフォーム構成

## ヘッダーアクション

### チャッターアクション

コミュニケーション・活動ログ機能を提供するパネルを開きます。

### 印刷アクション

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 説明 |
|--------|--------|----------|------|----------|------|
| 印刷枚数 | quantity | integer | ○ | 数値 | 1〜100枚 |
| フォーマット | format | string | ○ | ラジオ | dymo/2x7価格/4x7価格/4x12/4x12価格 |

### 削除アクション

商品のソフトデリートを実行します。

## 入出力項目

商品作成画面（No.217）と同一のフォーム構成です。詳細は商品作成画面の設計書を参照してください。

## イベント仕様

### 1-チャッターボタン押下

1. チャッターパネルが開く
2. コメント、メモ、活動ログを表示
3. 新規コメント・活動の追加が可能

### 2-印刷ボタン押下

1. 印刷設定フォームがモーダル表示
2. 印刷枚数とフォーマットを選択
3. 確定後、PDFを生成・ダウンロード
4. ファイル名：Product-{商品名}.pdf

### 3-削除ボタン押下

1. 確認ダイアログ表示
2. 確認後、ソフトデリート実行
3. 成功通知表示
4. 一覧画面へリダイレクト

### 4-保存ボタン押下

1. バリデーションチェック実行
2. 成功時：
   - データベースのレコード更新
   - バリアント商品のis_storableを同期更新
   - 成功通知表示
   - 商品詳細画面へリダイレクト
3. 失敗時：エラーメッセージ表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 商品保存 | products_products | UPDATE | 商品情報の更新 |
| バリアント同期 | products_products | UPDATE | is_storableの伝播 |
| タグ関連付け | products_product_tag | DELETE/INSERT | タグの再関連付け |
| 削除 | products_products | UPDATE | deleted_atに日時設定 |

### テーブル別更新項目詳細

#### products_products（商品更新）

商品作成画面と同様の項目が更新されます。

#### products_products（バリアント同期）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| afterSave | is_storable | 親商品のis_storable | バリアント全件に伝播 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示タイミング |
|-------------|------|----------------|----------------|
| MSG-001 | 成功 | 商品を更新しました | 更新成功時 |
| MSG-002 | 成功 | 商品を削除しました | 削除成功時 |

## 例外処理

| 例外状況 | 対応処理 | ユーザーへの通知 |
|---------|---------|-----------------|
| 必須項目未入力 | 保存処理中断 | 該当項目にエラーメッセージ表示 |
| 画像アップロード失敗 | アップロード中断 | エラーメッセージ表示 |
| レコード未存在 | 処理中断 | 404エラー表示 |
| データベースエラー | ロールバック | エラー通知表示 |

## 備考

- 本画面はFilament PHPのEditRecordクラスを継承して実装
- HasRecordNavigationTabsトレイトを使用し、レコード間のナビゲーションを提供
- 更新成功後、商品詳細画面（ViewProduct）へリダイレクト
- afterSaveメソッドでバリアント商品のis_storableを自動同期
- 印刷機能はDomPDFライブラリを使用
- 削除は確認ダイアログ付きソフトデリート
- フォーム構成は商品作成画面（No.217）と同一
