# 画面設計書 219-商品詳細

## 概要

本ドキュメントは、Aureus ERPシステムの商品モジュールにおける「商品詳細」画面の設計仕様を定義します。

### 本画面の処理概要

本画面は、商品（製品・サービス）の詳細情報を閲覧するための画面です。Infolist形式で商品の各種属性を表示し、編集画面への遷移、印刷、削除などの操作が可能です。

**業務上の目的・背景**：商品情報の確認は、営業、購買、在庫管理など様々な業務で頻繁に行われます。本画面では、商品の全情報を見やすく整理して表示し、必要に応じて編集・印刷・削除などの操作に素早くアクセスできます。

**画面へのアクセス方法**：商品一覧画面から「表示」アクションをクリック、または商品作成・編集完了後の遷移先。

**主要な操作・処理内容**：
1. 商品情報の閲覧
2. バーコードラベル印刷
3. チャッター機能（コミュニケーション・活動ログ）
4. 商品の削除
5. 編集画面への遷移（ヘッダーの編集リンク）

**画面遷移**：
- 前の画面 ← 商品一覧画面 / 商品作成画面 / 商品編集画面
- 次の画面 → 商品編集画面

**権限による表示制御**：商品閲覧権限を持つユーザーがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PRD-004 | 商品詳細 | 主機能 | 商品情報の閲覧 |
| FN-PRD-001 | 商品一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-PRD-003 | 商品編集 | 遷移先機能 | 編集画面への遷移 |

## 画面種別

詳細（View）- レコード詳細表示画面

## URL/ルーティング

```
/products/products/{record}
```

## 画面構成

- ヘッダーエリア
  - 画面タイトル
  - ヘッダーアクション
    - チャッターボタン
    - 印刷ボタン
    - 削除ボタン
  - 編集リンク
- サブナビゲーション（レコードナビゲーションタブ）
- メインコンテンツエリア（3カラムレイアウト）
  - 左側エリア（2カラム分）
    - 基本情報セクション
    - 画像セクション（画像がある場合のみ）
    - 在庫セクション（物品タイプのみ）
  - 右側エリア（1カラム分）
    - レコード情報セクション
    - 設定セクション
    - 価格セクション

## 表示項目

### 基本情報セクション

| 項目名 | 項目ID | データ型 | アイコン | 説明 |
|--------|--------|----------|---------|------|
| 商品名 | name | string | - | 商品の名称 |
| 説明 | description | html | - | 商品の詳細説明（HTML表示） |
| タグ | tags.name | array | - | バッジ形式で表示、太字 |

### 画像セクション

| 項目名 | 項目ID | データ型 | 表示条件 | 説明 |
|--------|--------|----------|---------|------|
| 商品画像 | images | array | 画像がある場合のみ | 画像ギャラリー表示 |

### 在庫セクション（物品タイプのみ）

| 項目名 | 項目ID | データ型 | アイコン | 説明 |
|--------|--------|----------|---------|------|
| 重量 | weight | decimal | heroicon-o-scale | 商品重量 |
| 体積 | volume | decimal | heroicon-o-beaker | 商品体積 |

### レコード情報セクション

| 項目名 | 項目ID | データ型 | アイコン | 説明 |
|--------|--------|----------|---------|------|
| 作成日時 | created_at | datetime | heroicon-o-calendar | レコード作成日時 |
| 作成者 | creator.name | string | heroicon-o-user | 作成したユーザー |
| 更新日時 | updated_at | datetime | heroicon-o-calendar | 最終更新日時 |

### 設定セクション

| 項目名 | 項目ID | データ型 | アイコン | 説明 |
|--------|--------|----------|---------|------|
| タイプ | type | enum | heroicon-o-queue-list | 物品/サービス |
| 参照コード | reference | string | heroicon-o-identification | 商品参照コード |
| バーコード | barcode | string | heroicon-o-bars-4 | 商品バーコード |
| カテゴリ | category.full_name | string | heroicon-o-folder | 商品カテゴリ（フルパス） |
| 会社 | company.name | string | heroicon-o-building-office | 所属会社 |

### 価格セクション

| 項目名 | 項目ID | データ型 | アイコン | 説明 |
|--------|--------|----------|---------|------|
| 販売価格 | price | decimal | heroicon-o-banknotes | 販売単価 |
| 原価 | cost | decimal | heroicon-o-banknotes | 仕入原価 |

## ヘッダーアクション

### チャッターアクション

コミュニケーション・活動ログ機能を提供するパネルを開きます。

### 印刷アクション

商品編集画面（No.218）と同様の印刷機能です。

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 説明 |
|--------|--------|----------|------|----------|------|
| 印刷枚数 | quantity | integer | ○ | 数値 | 1〜100枚 |
| フォーマット | format | string | ○ | ラジオ | dymo/2x7価格/4x7価格/4x12/4x12価格 |

### 削除アクション

商品のソフトデリートを実行します。

## イベント仕様

### 1-チャッターボタン押下

1. チャッターパネルが開く
2. コメント、メモ、活動ログを表示
3. 新規コメント・活動の追加が可能

### 2-印刷ボタン押下

1. 印刷設定フォームがモーダル表示
2. 印刷枚数とフォーマットを選択
3. 確定後、PDFを生成・ダウンロード
4. ファイル名：Product-{商品名}.pdf

### 3-削除ボタン押下

1. 確認ダイアログ表示
2. 確認後、ソフトデリート実行
3. 成功通知表示
4. 一覧画面へリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除 | products_products | UPDATE | deleted_atに日時設定 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示タイミング |
|-------------|------|----------------|----------------|
| MSG-001 | 成功 | 商品を削除しました | 削除成功時 |

## 例外処理

| 例外状況 | 対応処理 | ユーザーへの通知 |
|---------|---------|-----------------|
| レコード未存在 | 処理中断 | 404エラー表示 |
| PDF生成失敗 | 処理中断 | エラー通知表示 |
| 権限不足 | アクセス拒否 | 403エラー表示 |

## 備考

- 本画面はFilament PHPのViewRecordクラスを継承して実装
- HasRecordNavigationTabsトレイトを使用し、レコード間のナビゲーションを提供
- Infolistは3カラムレイアウト（左2:右1）
- 画像セクションは商品に画像がある場合のみ表示（visible条件）
- 在庫セクションは商品タイプがGOODSの場合のみ表示（visible条件）
- 各項目は値がない場合「—」を表示（placeholder）
- 印刷機能は商品編集画面と同一の実装
- 印刷機能はDomPDFライブラリを使用
