# 画面設計書 22-財務ポジション詳細

## 概要

本ドキュメントは、Aureus ERPシステムにおける財務ポジション詳細画面の設計仕様を定義します。財務ポジション（Fiscal Position）の登録内容を閲覧するための画面です。

### 本画面の処理概要

**業務上の目的・背景**：
財務ポジションは、国際取引や異なる税務管轄区域間での取引において、適切な税率や勘定科目を自動的に適用するための設定です。この詳細画面では、登録されている財務ポジションの設定内容を確認し、必要に応じて編集画面への遷移や削除操作を行うことができます。税務担当者や経理担当者が設定内容を確認する際に使用されます。

**画面へのアクセス方法**：
1. サイドメニューから「会計」モジュールを選択
2. 設定メニューから「財務ポジション」を選択して一覧画面へ遷移
3. 一覧から表示したいレコードを選択
4. 一覧のアクションから「表示」を選択、または行をクリック

**主要な操作・処理内容**：
1. 財務ポジション情報の閲覧（読み取り専用）
2. 編集ボタンで編集画面へ遷移
3. 削除ボタンでレコードを削除
4. サブナビゲーションで関連画面（税マッピング）へ遷移

**画面遷移**：
- 遷移元：財務ポジション一覧画面
- 遷移先：財務ポジション編集画面、財務ポジション税管理画面、財務ポジション一覧画面（削除時）

**権限による表示制御**：
会計モジュールへのアクセス権限を持つユーザーのみがこの画面にアクセスできます。編集・削除操作には適切な権限が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-025 | 財務ポジション管理 | 主機能 | 財務ポジションの詳細表示 |
| FN-ACC-025 | 財務ポジション管理 | 補助機能 | 財務ポジションの削除 |
| SCR-ACC-012 | FiscalPositionResource | 遷移先機能 | 編集画面への遷移 |

## 画面種別

詳細（View）

## URL/ルーティング

`/admin/accounts/fiscal-positions/{record}`

## 画面構成

- ヘッダーアクション
  - 編集ボタン（EditAction）
  - 削除ボタン（DeleteAction）
- サブナビゲーション（画面上部）
  - 詳細タブ
  - 編集タブ
  - 税マッピングタブ
- メイン情報表示エリア
  - セクション
    - 2カラムグリッド内の情報表示項目群
    - 備考表示エリア（マークダウン形式）

## 入出力項目

本画面は表示専用のため、入力項目はありません。

## 表示項目

| 項目名 | 項目ID | データ型 | 表示形式 | アイコン | 備考 |
|--------|--------|----------|----------|---------|------|
| 名称 | name | string | テキスト | heroicon-o-document-text | 財務ポジション名 |
| 外国VAT | foreign_vat | string | テキスト | heroicon-o-document | 外国のVAT番号 |
| 国 | country.name | string | テキスト | heroicon-o-globe-alt | リレーション経由 |
| 国グループ | countryGroup.name | string | テキスト | heroicon-o-map | リレーション経由 |
| 郵便番号（From） | zip_from | string | テキスト | heroicon-o-map-pin | 適用開始郵便番号 |
| 郵便番号（To） | zip_to | string | テキスト | heroicon-o-map-pin | 適用終了郵便番号 |
| 自動検出 | auto_reply | boolean | アイコン | - | true/false表示 |
| 備考 | notes | text | マークダウン | - | リッチテキスト |

## イベント仕様

### 1-編集ボタン押下

1. 編集画面（EditFiscalPosition）へ遷移

### 2-削除ボタン押下

1. 確認ダイアログ表示
2. ユーザーが確認した場合、レコードを削除
3. 成功通知を表示
4. 一覧画面へリダイレクト

### 3-サブナビゲーションタブ切り替え

1. 選択されたタブに対応する画面へ遷移
   - 詳細：ViewFiscalPosition（現在の画面）
   - 編集：EditFiscalPosition
   - 税マッピング：ManageFiscalPositionTax

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | fiscal_positions | SELECT | 財務ポジション情報の取得 |
| 削除ボタン押下 | fiscal_positions | DELETE | 財務ポジションレコードの削除 |

### テーブル別更新項目詳細

#### fiscal_positions（SELECT）

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SELECT | id | URLパラメータのrecord | 主キー |
| SELECT | name | - | 表示用 |
| SELECT | foreign_vat | - | 表示用 |
| SELECT | country_id | - | リレーション用 |
| SELECT | country_group_id | - | リレーション用 |
| SELECT | zip_from | - | 表示用 |
| SELECT | zip_to | - | 表示用 |
| SELECT | auto_reply | - | 表示用 |
| SELECT | notes | - | 表示用 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| view-fiscal-position.header-actions.delete.notification.title | 成功 | 削除成功タイトル | 削除処理成功時 |
| view-fiscal-position.header-actions.delete.notification.body | 成功 | 削除成功メッセージ本文 | 削除処理成功時 |

## 例外処理

| 例外種別 | 発生条件 | 対処方法 |
|---------|---------|---------|
| レコード未存在 | URLパラメータのrecordが存在しない場合 | 404エラーページを表示 |
| 権限不足 | 閲覧権限がないユーザーがアクセス | 403エラーまたはリダイレクト |
| リレーション先不在 | country_id等の参照先が削除されている場合 | プレースホルダー「-」を表示 |

## 備考

- 本画面はFilament PHPのViewRecordページを継承して実装されている
- サブナビゲーションは画面上部（Top）に配置される
- 各表示項目には値がない場合プレースホルダー「-」が表示される
- 備考（notes）はマークダウン形式で表示される
- 2カラムグリッドレイアウトで情報を整理して表示
