# 画面設計書 220-価格表一覧

## 概要

本ドキュメントは、Aureus ERPシステムの商品モジュールにおける「価格表一覧」画面の設計仕様を定義します。

### 本画面の処理概要

本画面は、システムに登録されている価格表（Price List）の一覧を表示し、価格表の管理を行うための画面です。価格表は商品の価格を通貨・会社・条件によって管理するためのマスタデータです。

**業務上の目的・背景**：多通貨対応や顧客別価格設定など、柔軟な価格管理を実現するために価格表機能が必要です。本画面では、価格表の一覧表示、新規作成、編集、削除などの基本的なCRUD操作を提供します。

**画面へのアクセス方法**：サイドメニューの「商品」モジュールから「価格表」をクリックしてアクセスします。

**主要な操作・処理内容**：
1. 価格表の一覧表示
2. 新規価格表の作成
3. 既存価格表の表示・編集
4. 価格表の削除
5. 一括削除操作

**画面遷移**：
- 新規作成ボタン → 価格表作成画面
- 表示アクション → 価格表詳細画面
- 編集アクション → 価格表編集画面

**権限による表示制御**：システムのロールおよび権限設定に基づき、表示・編集・削除の操作可否が制御されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PRD-010 | 価格表管理 | 主機能 | 価格表の一覧表示・作成・編集・削除 |

## 画面種別

一覧（List）- テーブル形式の一覧表示画面

## URL/ルーティング

```
/products/price-lists
```

## 画面構成

- ヘッダーエリア
  - 画面タイトル
  - 新規作成ボタン
- テーブルエリア
  - 価格表一覧テーブル（現在カラム未定義）
- 一括操作エリア
  - 一括削除

## 入出力項目

### 関連するデータモデル

価格表（PriceList）は以下の項目を持ちます：

| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| ID | id | integer | プライマリキー |
| 名前 | name | string | 価格表名 |
| 有効フラグ | is_active | boolean | 価格表の有効/無効 |
| 通貨 | currency_id | integer | 通貨への外部キー |
| 会社 | company_id | integer | 会社への外部キー |
| 作成者 | creator_id | integer | 作成ユーザーへの外部キー |
| 表示順序 | sort | integer | 並び替え用 |

**注意**：現在のソースコードでは、テーブルのカラム定義とフォーム定義が空（コメントのみ）となっています。

## 表示項目

### テーブル表示項目

現在未定義（コード上でコメントアウト状態）

想定される表示項目：

| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| 名前 | name | string | 価格表名 |
| 通貨 | currency.name | string | 通貨名 |
| 会社 | company.name | string | 会社名 |
| 有効 | is_active | boolean | 有効/無効状態 |
| 作成日時 | created_at | datetime | レコード作成日時 |

## イベント仕様

### 1-新規作成ボタン押下

1. 価格表作成画面（/products/price-lists/create）へ遷移

### 2-表示アクション押下

1. 価格表詳細画面（/products/price-lists/{id}）へ遷移

### 3-編集アクション押下

1. 価格表編集画面（/products/price-lists/{id}/edit）へ遷移

### 4-削除アクション押下

1. 確認ダイアログ表示
2. 確認後、物理削除実行
3. 成功通知表示
4. 一覧から削除

### 5-一括削除アクション押下

1. 選択されたレコードに対して確認ダイアログ表示
2. 確認後、物理削除実行
3. 成功通知表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除 | products_product_price_lists | DELETE | レコードの物理削除 |
| 一括削除 | products_product_price_lists | DELETE | 複数レコードの物理削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示タイミング |
|-------------|------|----------------|----------------|
| MSG-001 | 成功 | 価格表を削除しました | 削除成功時 |

## 例外処理

| 例外状況 | 対応処理 | ユーザーへの通知 |
|---------|---------|-----------------|
| 関連データ存在（削除時） | 削除処理中断 | 関連データ存在のエラーメッセージ表示 |
| 権限不足 | アクセス拒否 | 403エラー表示 |

## 備考

- 本画面はFilament PHPのListRecordsクラスを継承して実装
- 現在のソースコードではテーブル列とフォーム項目が未定義（開発途中）
- SoftDeletesは使用していない（物理削除のみ）
- ナビゲーションラベルは「Price Lists」（ハードコード）
- テーブルにはViewAction、EditActionが設定されている
- 一括削除にDeleteBulkActionが設定されている
- Sortable対応（sortカラムによる並び替え）
- 関連画面：
  - CreatePriceList（作成画面）
  - EditPriceList（編集画面）
  - ViewPriceList（詳細画面）
