# 画面設計書 221-価格表作成

## 概要

本ドキュメントは、Aureus ERPシステムの商品モジュールにおける「価格表作成」画面の設計仕様を定義する。

### 本画面の処理概要

本画面は、新規価格表を作成するための登録画面である。価格表は、商品の販売価格を管理するための重要なマスタデータであり、通貨や会社との関連付けを行うことができる。

**業務上の目的・背景**：企業では、顧客セグメントや販売チャネル、地域などに応じて異なる価格体系を設定する必要がある。本画面は、そのような複数の価格表を柔軟に管理するために用意されている。価格表を適切に設定することで、販売戦略に応じた価格設定が可能となり、収益最適化を実現する。

**画面へのアクセス方法**：メインメニューから「商品」モジュールを選択し、「価格表」サブメニューから「価格表一覧」画面に遷移後、画面右上の「新規作成」ボタンをクリックして本画面にアクセスする。

**主要な操作・処理内容**：
1. 価格表名の入力：識別しやすい名称を設定
2. 通貨の選択：価格表で使用する通貨を指定
3. 会社の選択：価格表を紐付ける会社を指定
4. 有効/無効フラグの設定：価格表の使用可否を制御
5. 並び順の設定：表示順序を制御（自動設定）
6. 作成ボタンの押下：入力内容を保存

**画面遷移**：価格表一覧画面から遷移し、作成完了後は価格表詳細画面へ遷移する。キャンセル時は価格表一覧画面へ戻る。

**権限による表示制御**：価格表の作成権限を持つユーザーのみがこの画面にアクセスできる。権限がない場合は、メニューおよび作成ボタンが非表示となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PRD-023 | 価格表作成 | 主機能 | 新規価格表データの作成・保存処理 |
| FN-PRD-022 | 価格表一覧 | 遷移先機能 | 一覧画面への戻り遷移 |
| FN-PRD-025 | 価格表表示 | 遷移先機能 | 作成完了後の詳細画面への遷移 |

## 画面種別

登録画面（CreateRecord）

## URL/ルーティング

```
/admin/products/price-lists/create
```

## 画面構成

- ヘッダー部
  - 画面タイトル「価格表作成」
  - パンくずリスト
- フォーム部
  - 価格表情報入力セクション
- フッター部
  - 作成ボタン
  - キャンセルボタン

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | 必須 | データ型 | 最大長 | 初期値 | 説明 |
|--------|--------|----------|------|----------|--------|--------|------|
| 価格表名 | name | 入力 | ○ | 文字列 | 255 | - | 価格表の識別名称 |
| 通貨 | currency_id | 入力 | - | 数値（外部キー） | - | - | 通貨マスタへの参照 |
| 会社 | company_id | 入力 | - | 数値（外部キー） | - | ログインユーザーの所属会社 | 会社マスタへの参照 |
| 有効 | is_active | 入力 | - | 真偽値 | - | true | 価格表の有効/無効フラグ |
| 並び順 | sort | 出力 | - | 数値 | - | 自動採番 | 表示順序（システム自動設定） |
| 作成者ID | creator_id | 出力 | - | 数値（外部キー） | - | ログインユーザーID | 作成者の参照 |

## 表示項目

本画面は登録画面のため、該当なし。

## イベント仕様

### 1-作成ボタン押下

入力されたフォームデータのバリデーションを実行し、問題がなければ価格表データをデータベースに保存する。保存成功後、価格表詳細画面へリダイレクトする。

- **前提条件**：必須項目（価格表名）が入力されていること
- **処理フロー**：
  1. クライアントサイドバリデーション
  2. サーバーサイドバリデーション
  3. creator_idに現在のログインユーザーIDを設定
  4. sortに自動採番値を設定（SortableTrait使用）
  5. データベースへの保存処理
  6. 成功通知の表示
  7. 詳細画面へのリダイレクト

### 2-キャンセルボタン押下

入力内容を破棄し、価格表一覧画面へ遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成ボタン押下 | products_product_price_lists | INSERT | 新規価格表レコードの作成 |

### テーブル別更新項目詳細

#### products_product_price_lists

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | id | 自動採番 | プライマリキー |
| INSERT | name | フォーム入力値 | 価格表名 |
| INSERT | currency_id | フォーム入力値 | 通貨への外部キー |
| INSERT | company_id | フォーム入力値またはログインユーザーの所属会社ID | 会社への外部キー |
| INSERT | creator_id | ログインユーザーID | 作成者への外部キー |
| INSERT | is_active | フォーム入力値（デフォルト: true） | 有効フラグ |
| INSERT | sort | 自動採番（SortableTrait） | 並び順 |
| INSERT | created_at | システム日時 | 作成日時 |
| INSERT | updated_at | システム日時 | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-001 | 成功 | 価格表が正常に作成されました | 作成処理成功時 |
| MSG-002 | エラー | 価格表名は必須です | 価格表名未入力時 |
| MSG-003 | エラー | 価格表名は255文字以内で入力してください | 価格表名が最大長超過時 |

## 例外処理

| 例外パターン | 処理内容 | 画面表示 |
|-------------|---------|---------|
| バリデーションエラー | 保存処理を中断 | 該当項目にエラーメッセージを表示 |
| データベース接続エラー | トランザクションロールバック | システムエラーメッセージを表示 |
| 権限不足 | 処理を拒否 | 403エラーページを表示 |

## 備考

- 本画面はFilament PHPフレームワークのCreateRecordを継承して実装されている
- 並び順はSpatie EloquentSortableパッケージにより自動管理される
- 作成者IDはシステムが自動的にログインユーザーのIDを設定する
