# 画面設計書 222-価格表編集

## 概要

本ドキュメントは、Aureus ERPシステムの商品モジュールにおける「価格表編集」画面の設計仕様を定義する。

### 本画面の処理概要

本画面は、既存の価格表情報を編集・更新するための画面である。価格表名や通貨、会社、有効フラグなどの情報を変更し、保存することができる。

**業務上の目的・背景**：ビジネス環境の変化や組織変更に伴い、既存の価格表情報を修正する必要がある。本画面は、価格表マスタのメンテナンス業務を効率的に行うために提供されている。価格表の有効/無効の切り替えや、名称変更などの日常的な管理作業を支援する。

**画面へのアクセス方法**：価格表一覧画面でレコードの編集アイコンをクリックするか、価格表詳細画面のヘッダーにある「編集」ボタンをクリックして本画面にアクセスする。

**主要な操作・処理内容**：
1. 既存データの表示：データベースから価格表情報を読み込み、フォームに表示
2. 価格表名の変更：識別名称を修正
3. 通貨の変更：使用する通貨を変更
4. 会社の変更：紐付ける会社を変更
5. 有効/無効フラグの変更：価格表の使用可否を変更
6. 保存ボタンの押下：変更内容をデータベースに反映
7. 削除ボタンの押下：価格表を削除

**画面遷移**：価格表一覧画面または価格表詳細画面から遷移する。ヘッダーには「表示」ボタンと「削除」ボタンが配置されており、詳細画面への遷移や削除操作が可能。

**権限による表示制御**：価格表の編集権限を持つユーザーのみがこの画面にアクセスできる。削除権限がない場合は削除ボタンが非表示となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PRD-024 | 価格表編集 | 主機能 | 価格表データの更新処理 |
| FN-PRD-022 | 価格表一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-PRD-025 | 価格表表示 | 遷移先機能 | 詳細画面への遷移（表示ボタン） |

## 画面種別

編集画面（EditRecord）

## URL/ルーティング

```
/admin/products/price-lists/{record}/edit
```

## 画面構成

- ヘッダー部
  - 画面タイトル「価格表編集」
  - パンくずリスト
  - ヘッダーアクション
    - 表示ボタン（ViewAction）
    - 削除ボタン（DeleteAction）
- フォーム部
  - 価格表情報編集セクション
- フッター部
  - 保存ボタン
  - キャンセルボタン

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | 必須 | データ型 | 最大長 | 初期値 | 説明 |
|--------|--------|----------|------|----------|--------|--------|------|
| 価格表ID | id | 出力 | - | 数値 | - | 既存データ | プライマリキー（編集不可） |
| 価格表名 | name | 入力 | ○ | 文字列 | 255 | 既存データ | 価格表の識別名称 |
| 通貨 | currency_id | 入力 | - | 数値（外部キー） | - | 既存データ | 通貨マスタへの参照 |
| 会社 | company_id | 入力 | - | 数値（外部キー） | - | 既存データ | 会社マスタへの参照 |
| 有効 | is_active | 入力 | - | 真偽値 | - | 既存データ | 価格表の有効/無効フラグ |
| 並び順 | sort | 出力 | - | 数値 | - | 既存データ | 表示順序 |

## 表示項目

本画面は編集画面のため、入力項目と同一。

## イベント仕様

### 1-保存ボタン押下

入力されたフォームデータのバリデーションを実行し、問題がなければ価格表データを更新する。

- **前提条件**：必須項目（価格表名）が入力されていること
- **処理フロー**：
  1. クライアントサイドバリデーション
  2. サーバーサイドバリデーション
  3. データベースの更新処理
  4. 成功通知の表示
  5. 現在の画面を維持

### 2-表示ボタン押下

編集内容を破棄せず、価格表詳細画面へ遷移する。

### 3-削除ボタン押下

確認ダイアログを表示し、確認後に価格表を削除する。削除成功後は価格表一覧画面へ遷移する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | products_product_price_lists | UPDATE | 価格表レコードの更新 |
| 削除ボタン押下 | products_product_price_lists | DELETE | 価格表レコードの削除 |

### テーブル別更新項目詳細

#### products_product_price_lists

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 価格表名 |
| UPDATE | currency_id | フォーム入力値 | 通貨への外部キー |
| UPDATE | company_id | フォーム入力値 | 会社への外部キー |
| UPDATE | is_active | フォーム入力値 | 有効フラグ |
| UPDATE | updated_at | システム日時 | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-001 | 成功 | 価格表が正常に更新されました | 更新処理成功時 |
| MSG-002 | 成功 | 価格表が正常に削除されました | 削除処理成功時 |
| MSG-003 | エラー | 価格表名は必須です | 価格表名未入力時 |
| MSG-004 | 確認 | この価格表を削除してもよろしいですか？ | 削除ボタン押下時 |

## 例外処理

| 例外パターン | 処理内容 | 画面表示 |
|-------------|---------|---------|
| レコード未発見 | 処理を中断 | 404エラーページを表示 |
| バリデーションエラー | 保存処理を中断 | 該当項目にエラーメッセージを表示 |
| データベース接続エラー | トランザクションロールバック | システムエラーメッセージを表示 |
| 外部キー制約違反（削除時） | 削除処理を中断 | 関連データ存在のエラーメッセージを表示 |
| 権限不足 | 処理を拒否 | 403エラーページを表示 |

## 備考

- 本画面はFilament PHPフレームワークのEditRecordを継承して実装されている
- ヘッダーアクションとしてViewActionとDeleteActionが定義されている
- 削除処理は物理削除となる（ソフトデリートではない）
