# 画面設計書 223-価格表詳細

## 概要

本ドキュメントは、Aureus ERPシステムの商品モジュールにおける「価格表詳細」画面の設計仕様を定義する。

### 本画面の処理概要

本画面は、特定の価格表の詳細情報を閲覧するための画面である。価格表の基本情報（名称、通貨、会社、有効状態など）を参照することができる。

**業務上の目的・背景**：価格表の設定内容を確認する必要がある場面で使用される。営業担当者が顧客への見積り作成時に適用する価格表を確認したり、管理者が価格表の設定内容を監査したりする際に利用される。読み取り専用の表示画面であるため、誤操作による変更を防ぐことができる。

**画面へのアクセス方法**：価格表一覧画面でレコードの表示アイコンをクリックするか、価格表編集画面のヘッダーにある「表示」ボタンをクリックして本画面にアクセスする。

**主要な操作・処理内容**：
1. 価格表情報の表示：データベースから価格表情報を読み込み、画面に表示
2. 編集画面への遷移：ヘッダーの「編集」ボタンで編集画面へ移動

**画面遷移**：価格表一覧画面または価格表編集画面から遷移する。ヘッダーには「編集」ボタンが配置されており、編集画面への遷移が可能。

**権限による表示制御**：価格表の閲覧権限を持つユーザーがこの画面にアクセスできる。編集権限がない場合は編集ボタンが非表示となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PRD-025 | 価格表表示 | 主機能 | 価格表データの詳細表示 |
| FN-PRD-022 | 価格表一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-PRD-024 | 価格表編集 | 遷移先機能 | 編集画面への遷移（編集ボタン） |

## 画面種別

詳細画面（ViewRecord）

## URL/ルーティング

```
/admin/products/price-lists/{record}
```

## 画面構成

- ヘッダー部
  - 画面タイトル「価格表詳細」
  - パンくずリスト
  - ヘッダーアクション
    - 編集ボタン（EditAction）
- コンテンツ部
  - 価格表情報表示セクション

## 入出力項目

本画面は詳細表示画面のため、入力項目なし。

## 表示項目

| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| 価格表ID | id | 数値 | プライマリキー |
| 価格表名 | name | 文字列 | 価格表の識別名称 |
| 通貨 | currency.name | 文字列 | 関連する通貨の名称 |
| 会社 | company.name | 文字列 | 関連する会社の名称 |
| 有効 | is_active | 真偽値 | 価格表の有効/無効状態 |
| 並び順 | sort | 数値 | 表示順序 |
| 作成者 | creator.name | 文字列 | 作成者のユーザー名 |
| 作成日時 | created_at | 日時 | レコード作成日時 |
| 更新日時 | updated_at | 日時 | レコード最終更新日時 |

## イベント仕様

### 1-編集ボタン押下

価格表編集画面へ遷移する。

- **前提条件**：ユーザーが編集権限を持っていること
- **処理フロー**：
  1. 編集画面へのルーティング
  2. 価格表編集画面の表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | products_product_price_lists | SELECT | 価格表レコードの取得 |

### テーブル別更新項目詳細

本画面は参照のみのため、更新処理なし。

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-001 | エラー | 指定された価格表が見つかりません | レコード未発見時 |

## 例外処理

| 例外パターン | 処理内容 | 画面表示 |
|-------------|---------|---------|
| レコード未発見 | 処理を中断 | 404エラーページを表示 |
| 権限不足 | アクセスを拒否 | 403エラーページを表示 |
| データベース接続エラー | 処理を中断 | システムエラーメッセージを表示 |

## 備考

- 本画面はFilament PHPフレームワークのViewRecordを継承して実装されている
- ヘッダーアクションとしてEditActionのみが定義されている
- 読み取り専用画面のため、データ変更は行われない
