# 画面設計書 224-属性一覧

## 概要

本ドキュメントは、Aureus ERPシステムの商品モジュールにおける「属性一覧」画面の設計仕様を定義する。

### 本画面の処理概要

本画面は、商品属性（サイズ、色、素材など）の一覧を表示・管理するための画面である。商品バリエーションを構成する属性を一元管理し、属性の作成・編集・削除・復元などの操作を行うことができる。

**業務上の目的・背景**：商品のバリエーション管理において、属性（Attribute）は重要な要素である。同一商品でもサイズ違いや色違いなど、属性によって異なるバリエーションを持つ場合がある。本画面は、これらの属性を体系的に管理し、商品マスタへの効率的な適用を支援する。属性タイプ（ラジオボタン、カラーピッカー等）に応じた選択肢の管理も可能。

**画面へのアクセス方法**：メインメニューから「商品」モジュールを選択し、「属性」サブメニューをクリックして本画面にアクセスする。

**主要な操作・処理内容**：
1. 属性一覧の表示：登録済み属性をテーブル形式で表示
2. 検索・フィルタリング：名前検索、タイプによるフィルタ
3. グループ化：タイプ、作成日、更新日によるグループ表示
4. 新規作成：新しい属性を作成
5. 編集・表示：既存属性の編集・詳細表示
6. 削除・復元：属性のソフトデリート・復元
7. 完全削除：ソフトデリート済み属性の完全削除
8. タブ切替：全件表示とアーカイブ済み表示の切替

**画面遷移**：メインナビゲーションから遷移する。属性作成画面、属性編集画面、属性詳細画面への遷移が可能。

**権限による表示制御**：属性の閲覧権限を持つユーザーがこの画面にアクセスできる。作成・編集・削除権限がない場合は該当ボタンが非表示となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PRD-018 | 属性一覧 | 主機能 | 属性データの一覧表示・検索・フィルタ |
| FN-PRD-019 | 属性作成 | 遷移先機能 | 新規属性の作成画面への遷移 |
| FN-PRD-020 | 属性編集 | 遷移先機能 | 既存属性の編集画面への遷移 |
| FN-PRD-021 | 属性表示 | 遷移先機能 | 属性詳細画面への遷移 |

## 画面種別

一覧画面（ListRecords）

## URL/ルーティング

```
/admin/products/attributes
```

## 画面構成

- ヘッダー部
  - 画面タイトル「属性一覧」
  - 新規作成ボタン（CreateAction）
- タブ部
  - 全件タブ（件数バッジ付き）
  - アーカイブ済みタブ（件数バッジ付き）
- テーブル部
  - カラムヘッダー（ソート可能）
  - データ行
  - 行アクション（表示・編集・削除・復元・完全削除）
- ツールバー部
  - 一括アクション（一括削除・一括復元・一括完全削除）
- フッター部
  - ページネーション

## 入出力項目

本画面は一覧表示画面のため、主に出力項目。

## 表示項目

| 項目名 | 項目ID | データ型 | ソート | 検索 | 説明 |
|--------|--------|----------|------|------|------|
| 属性名 | name | 文字列 | - | ○ | 属性の識別名称 |
| タイプ | type | Enum | ○ | - | 属性タイプ（Radio/Color等） |
| 作成日時 | created_at | 日時 | ○ | - | レコード作成日時（初期非表示） |
| 更新日時 | updated_at | 日時 | ○ | - | レコード最終更新日時（初期非表示） |

## イベント仕様

### 1-新規作成ボタン押下

モーダルダイアログが表示され、新規属性を作成する。

- **前提条件**：ユーザーが作成権限を持っていること
- **処理フロー**：
  1. モーダルダイアログの表示
  2. 属性情報の入力
  3. creator_idとcompany_idの自動設定
  4. 保存処理
  5. 成功通知の表示
  6. 一覧の更新

### 2-表示アイコン押下

属性詳細画面へ遷移する。削除済みレコードでは非表示。

### 3-編集アイコン押下

属性編集画面へ遷移する。削除済みレコードでは非表示。

### 4-削除アイコン押下

確認ダイアログを表示し、属性をソフトデリートする。

### 5-復元アイコン押下

ソフトデリート済みの属性を復元する。アーカイブ済みタブでのみ表示。

### 6-完全削除アイコン押下

確認ダイアログを表示し、属性を完全削除する。アーカイブ済みタブでのみ表示。

### 7-タブ切替

全件表示とアーカイブ済み表示を切り替える。

### 8-タイプフィルタ選択

選択したタイプで属性一覧をフィルタリングする。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | products_attributes | SELECT | 属性一覧の取得 |
| 新規作成 | products_attributes | INSERT | 新規属性レコードの作成 |
| 削除 | products_attributes | UPDATE | deleted_atにタイムスタンプを設定（ソフトデリート） |
| 復元 | products_attributes | UPDATE | deleted_atをNULLに設定 |
| 完全削除 | products_attributes | DELETE | レコードの物理削除 |

### テーブル別更新項目詳細

#### products_attributes

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | id | 自動採番 | プライマリキー |
| INSERT | name | フォーム入力値 | 属性名 |
| INSERT | type | フォーム入力値 | 属性タイプ（Enum） |
| INSERT | sort | 自動採番（SortableTrait） | 並び順 |
| INSERT | creator_id | ログインユーザーID | 作成者 |
| INSERT | created_at | システム日時 | 作成日時 |
| INSERT | updated_at | システム日時 | 更新日時 |
| UPDATE（削除） | deleted_at | システム日時 | ソフトデリート日時 |
| UPDATE（復元） | deleted_at | NULL | ソフトデリート解除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-001 | 成功 | 属性が正常に作成されました | 作成処理成功時 |
| MSG-002 | 成功 | 属性が正常に削除されました | 削除処理成功時 |
| MSG-003 | 成功 | 属性が正常に復元されました | 復元処理成功時 |
| MSG-004 | 成功 | 属性が完全に削除されました | 完全削除処理成功時 |
| MSG-005 | エラー | 関連するデータが存在するため削除できません | 外部キー制約違反時 |
| MSG-006 | 成功 | 選択した属性が一括削除されました | 一括削除成功時 |
| MSG-007 | 成功 | 選択した属性が一括復元されました | 一括復元成功時 |

## 例外処理

| 例外パターン | 処理内容 | 画面表示 |
|-------------|---------|---------|
| 権限不足 | アクセスを拒否 | 403エラーページを表示 |
| データベース接続エラー | 処理を中断 | システムエラーメッセージを表示 |
| 外部キー制約違反（完全削除時） | 削除処理を中断 | 関連データ存在のエラーメッセージを表示 |

## 備考

- 本画面はFilament PHPフレームワークのListRecordsを継承して実装されている
- ソフトデリート機能（SoftDeletes）が有効になっている
- タブ機能により、アクティブな属性とアーカイブ済み属性を切り替えて表示できる
- 属性タイプはAttributeType Enumで定義されている（RADIO, COLOR等）
- グループ化機能により、タイプ・作成日・更新日でグループ表示が可能
