# 画面設計書 225-属性作成

## 概要

本ドキュメントは、Aureus ERPシステムの商品モジュールにおける「属性作成」画面の設計仕様を定義する。

### 本画面の処理概要

本画面は、新規商品属性を作成するための登録画面である。属性名、属性タイプ（ラジオボタン、カラーピッカー等）、および属性オプション（選択肢）を登録することができる。

**業務上の目的・背景**：商品バリエーションを効率的に管理するためには、属性の定義が必要である。例えば、Tシャツ商品において「サイズ」という属性を作成し、その選択肢として「S」「M」「L」「XL」を登録することで、サイズバリエーションを管理できる。また、「色」属性ではカラーピッカーを使用して視覚的な色選択が可能になる。

**画面へのアクセス方法**：属性一覧画面の「新規作成」ボタンをクリックして本画面にアクセスする。または、空の一覧状態で表示される「作成」ボタンからもアクセス可能。

**主要な操作・処理内容**：
1. 属性名の入力：属性の識別名称を設定（例：サイズ、色、素材）
2. 属性タイプの選択：Radio（ラジオボタン）、Color（カラーピッカー）などから選択
3. 属性オプションの追加：選択肢の名前、色（カラータイプの場合）、追加価格を設定
4. オプションの並び替え：Repeater機能により順序を変更
5. 作成ボタンの押下：入力内容を保存

**画面遷移**：属性一覧画面から遷移し、作成完了後は属性詳細画面へリダイレクトする。

**権限による表示制御**：属性の作成権限を持つユーザーのみがこの画面にアクセスできる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PRD-019 | 属性作成 | 主機能 | 新規属性データの作成・保存処理 |
| FN-PRD-018 | 属性一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-PRD-021 | 属性表示 | 遷移先機能 | 作成完了後の詳細画面への遷移 |

## 画面種別

登録画面（CreateRecord）

## URL/ルーティング

```
/admin/products/attributes/create
```

## 画面構成

- ヘッダー部
  - 画面タイトル「属性作成」
  - パンくずリスト
- フォーム部
  - 基本情報セクション
    - 属性名
    - 属性タイプ
  - オプションセクション
    - オプションリピーター
- フッター部
  - 作成ボタン
  - キャンセルボタン

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | 必須 | データ型 | 最大長 | 初期値 | 説明 |
|--------|--------|----------|------|----------|--------|--------|------|
| 属性名 | name | 入力 | ○ | 文字列 | 255 | - | 属性の識別名称 |
| タイプ | type | 入力 | ○ | Enum | - | RADIO | 属性タイプ（Radio/Color等） |
| オプション名 | options[].name | 入力 | ○ | 文字列 | 255 | - | オプションの識別名称 |
| オプション色 | options[].color | 入力 | - | 文字列（HEX） | 7 | - | カラーコード（タイプがColorの場合のみ表示） |
| 追加価格 | options[].extra_price | 入力 | ○ | 数値 | - | 0.0000 | オプション選択時の追加価格 |
| 作成者ID | creator_id | 出力 | - | 数値（外部キー） | - | ログインユーザーID | 作成者の参照 |

## 表示項目

本画面は登録画面のため、該当なし。

## イベント仕様

### 1-作成ボタン押下

入力されたフォームデータのバリデーションを実行し、問題がなければ属性データをデータベースに保存する。

- **前提条件**：必須項目（属性名、タイプ）が入力されていること
- **処理フロー**：
  1. クライアントサイドバリデーション
  2. サーバーサイドバリデーション
  3. creator_idに現在のログインユーザーIDを設定
  4. 属性レコードの保存
  5. 関連するオプションレコードの保存
  6. 成功通知の表示
  7. 詳細画面へのリダイレクト

### 2-タイプ変更

属性タイプを変更すると、オプションセクションの表示が動的に変化する。タイプが「Color」の場合、カラーピッカー項目が表示される。

### 3-オプション追加

Repeaterの追加ボタンを押下すると、新しいオプション入力行が追加される。

### 4-オプション削除

Repeaterの削除ボタンを押下すると、該当のオプション入力行が削除される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成ボタン押下 | products_attributes | INSERT | 新規属性レコードの作成 |
| 作成ボタン押下 | products_attribute_options | INSERT | 関連するオプションレコードの作成 |

### テーブル別更新項目詳細

#### products_attributes

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | id | 自動採番 | プライマリキー |
| INSERT | name | フォーム入力値 | 属性名 |
| INSERT | type | フォーム入力値 | 属性タイプ（Enum） |
| INSERT | sort | 自動採番（SortableTrait） | 並び順 |
| INSERT | creator_id | ログインユーザーID | 作成者への外部キー |
| INSERT | created_at | システム日時 | 作成日時 |
| INSERT | updated_at | システム日時 | 更新日時 |

#### products_attribute_options

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | id | 自動採番 | プライマリキー |
| INSERT | attribute_id | 親属性のID | 属性への外部キー |
| INSERT | name | フォーム入力値 | オプション名 |
| INSERT | color | フォーム入力値 | カラーコード（HEX） |
| INSERT | extra_price | フォーム入力値（デフォルト: 0.0000） | 追加価格 |
| INSERT | created_at | システム日時 | 作成日時 |
| INSERT | updated_at | システム日時 | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-001 | 成功 | 属性が正常に作成されました | 作成処理成功時 |
| MSG-002 | エラー | 属性名は必須です | 属性名未入力時 |
| MSG-003 | エラー | 属性名は255文字以内で入力してください | 属性名が最大長超過時 |
| MSG-004 | エラー | タイプを選択してください | タイプ未選択時 |
| MSG-005 | エラー | オプション名は必須です | オプション名未入力時 |
| MSG-006 | エラー | 追加価格は0以上99999999999以下で入力してください | 追加価格が範囲外時 |

## 例外処理

| 例外パターン | 処理内容 | 画面表示 |
|-------------|---------|---------|
| バリデーションエラー | 保存処理を中断 | 該当項目にエラーメッセージを表示 |
| データベース接続エラー | トランザクションロールバック | システムエラーメッセージを表示 |
| 権限不足 | 処理を拒否 | 403エラーページを表示 |

## 備考

- 本画面はFilament PHPフレームワークのCreateRecordを継承して実装されている
- 属性タイプはAttributeType Enumで定義されている
- オプションはRepeaterコンポーネントを使用して動的に追加・削除が可能
- カラーピッカー項目は属性タイプが「Color」の場合のみ表示される（条件付き表示）
- 追加価格は0から99999999999の範囲で設定可能
- 作成完了後は属性詳細画面へリダイレクトされる（getRedirectUrl）
