# 画面設計書 226-属性編集

## 概要

本ドキュメントは、Aureus ERPシステムの商品モジュールにおける「属性編集」画面の設計仕様を定義する。

### 本画面の処理概要

本画面は、既存の商品属性情報を編集・更新するための画面である。属性名、属性タイプ、および属性オプション（選択肢）を変更することができる。

**業務上の目的・背景**：ビジネス要件の変化に伴い、既存の属性情報を修正する必要がある。例えば、サイズ属性に新しいサイズオプションを追加したり、オプションの追加価格を変更したりする場合に使用される。本画面は属性マスタのメンテナンス業務を効率的に行うために提供されている。

**画面へのアクセス方法**：属性一覧画面でレコードの編集アイコンをクリックするか、属性詳細画面のヘッダーにある「編集」ボタンをクリックして本画面にアクセスする。

**主要な操作・処理内容**：
1. 既存データの表示：データベースから属性情報とオプションを読み込み、フォームに表示
2. 属性名の変更：識別名称を修正
3. 属性タイプの変更：タイプを変更（オプションの表示が動的に変化）
4. オプションの追加・編集・削除：選択肢を管理
5. 保存ボタンの押下：変更内容をデータベースに反映
6. 削除ボタンの押下：属性を削除（ソフトデリート）

**画面遷移**：属性一覧画面または属性詳細画面から遷移する。ヘッダーには「表示」ボタンと「削除」ボタンが配置されている。

**権限による表示制御**：属性の編集権限を持つユーザーのみがこの画面にアクセスできる。削除権限がない場合は削除ボタンが非表示となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PRD-020 | 属性編集 | 主機能 | 属性データの更新処理 |
| FN-PRD-018 | 属性一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-PRD-021 | 属性表示 | 遷移先機能 | 詳細画面への遷移（表示ボタン） |

## 画面種別

編集画面（EditRecord）

## URL/ルーティング

```
/admin/products/attributes/{record}/edit
```

## 画面構成

- ヘッダー部
  - 画面タイトル「属性編集」
  - パンくずリスト
  - ヘッダーアクション
    - 表示ボタン（ViewAction）
    - 削除ボタン（DeleteAction）
- フォーム部
  - 基本情報セクション
    - 属性名
    - 属性タイプ
  - オプションセクション
    - オプションリピーター
- フッター部
  - 保存ボタン
  - キャンセルボタン

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | 必須 | データ型 | 最大長 | 初期値 | 説明 |
|--------|--------|----------|------|----------|--------|--------|------|
| 属性ID | id | 出力 | - | 数値 | - | 既存データ | プライマリキー（編集不可） |
| 属性名 | name | 入力 | ○ | 文字列 | 255 | 既存データ | 属性の識別名称 |
| タイプ | type | 入力 | ○ | Enum | - | 既存データ | 属性タイプ（Radio/Color等） |
| オプション名 | options[].name | 入力 | ○ | 文字列 | 255 | 既存データ | オプションの識別名称 |
| オプション色 | options[].color | 入力 | - | 文字列（HEX） | 7 | 既存データ | カラーコード（タイプがColorの場合のみ） |
| 追加価格 | options[].extra_price | 入力 | ○ | 数値 | - | 既存データ | オプション選択時の追加価格 |

## 表示項目

本画面は編集画面のため、入力項目と同一。

## イベント仕様

### 1-保存ボタン押下

入力されたフォームデータのバリデーションを実行し、問題がなければ属性データを更新する。

- **前提条件**：必須項目（属性名、タイプ）が入力されていること
- **処理フロー**：
  1. クライアントサイドバリデーション
  2. サーバーサイドバリデーション
  3. 属性レコードの更新
  4. 関連するオプションレコードの更新（追加・変更・削除）
  5. 成功通知の表示

### 2-表示ボタン押下

属性詳細画面へ遷移する。

### 3-削除ボタン押下

確認ダイアログを表示し、確認後に属性をソフトデリートする。削除成功後は属性一覧画面へ遷移する。

### 4-タイプ変更

属性タイプを変更すると、オプションセクションの表示が動的に変化する。

### 5-オプション追加・削除

Repeaterの追加・削除ボタンでオプションを管理する。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | products_attributes | UPDATE | 属性レコードの更新 |
| 保存ボタン押下 | products_attribute_options | INSERT/UPDATE/DELETE | オプションレコードの管理 |
| 削除ボタン押下 | products_attributes | UPDATE | deleted_atにタイムスタンプを設定 |

### テーブル別更新項目詳細

#### products_attributes

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 属性名 |
| UPDATE | type | フォーム入力値 | 属性タイプ（Enum） |
| UPDATE | updated_at | システム日時 | 更新日時 |
| UPDATE（削除） | deleted_at | システム日時 | ソフトデリート日時 |

#### products_attribute_options

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT/UPDATE | name | フォーム入力値 | オプション名 |
| INSERT/UPDATE | color | フォーム入力値 | カラーコード |
| INSERT/UPDATE | extra_price | フォーム入力値 | 追加価格 |
| DELETE | - | Repeaterから削除されたオプション | 物理削除 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-001 | 成功 | 属性が正常に更新されました | 更新処理成功時 |
| MSG-002 | 成功 | 属性が正常に削除されました | 削除処理成功時 |
| MSG-003 | エラー | 属性名は必須です | 属性名未入力時 |
| MSG-004 | 確認 | この属性を削除してもよろしいですか？ | 削除ボタン押下時 |

## 例外処理

| 例外パターン | 処理内容 | 画面表示 |
|-------------|---------|---------|
| レコード未発見 | 処理を中断 | 404エラーページを表示 |
| バリデーションエラー | 保存処理を中断 | 該当項目にエラーメッセージを表示 |
| データベース接続エラー | トランザクションロールバック | システムエラーメッセージを表示 |
| 権限不足 | 処理を拒否 | 403エラーページを表示 |

## 備考

- 本画面はFilament PHPフレームワークのEditRecordを継承して実装されている
- ヘッダーアクションとしてViewActionとDeleteActionが定義されている
- 削除処理はソフトデリート（deleted_atに日時を設定）
- 成功通知はFilamentのNotification機能を使用
- オプションはRepeaterのリレーション機能により、親レコードと一緒に保存される
