# 画面設計書 227-属性詳細

## 概要

本ドキュメントは、Aureus ERPシステムの商品モジュールにおける「属性詳細」画面の設計仕様を定義する。

### 本画面の処理概要

本画面は、特定の商品属性の詳細情報を閲覧するための画面である。属性の基本情報（名称、タイプ）、作成者情報、作成日時・更新日時などを参照することができる。

**業務上の目的・背景**：属性の設定内容を確認する必要がある場面で使用される。商品担当者が属性の構成を確認したり、管理者が属性マスタの監査を行ったりする際に利用される。読み取り専用の表示画面であるため、誤操作による変更を防ぐことができる。

**画面へのアクセス方法**：属性一覧画面でレコードの表示アイコンをクリックするか、属性作成画面から作成完了後のリダイレクト先として本画面にアクセスする。

**主要な操作・処理内容**：
1. 属性情報の表示：データベースから属性情報を読み込み、画面に表示
2. 編集画面への遷移：ヘッダーの「編集」ボタンで編集画面へ移動
3. 削除処理：ヘッダーの「削除」ボタンで属性を削除

**画面遷移**：属性一覧画面または属性作成画面から遷移する。ヘッダーには「編集」ボタンと「削除」ボタンが配置されている。

**権限による表示制御**：属性の閲覧権限を持つユーザーがこの画面にアクセスできる。編集・削除権限がない場合は該当ボタンが非表示となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PRD-021 | 属性表示 | 主機能 | 属性データの詳細表示 |
| FN-PRD-018 | 属性一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-PRD-020 | 属性編集 | 遷移先機能 | 編集画面への遷移（編集ボタン） |

## 画面種別

詳細画面（ViewRecord）

## URL/ルーティング

```
/admin/products/attributes/{record}
```

## 画面構成

- ヘッダー部
  - 画面タイトル「属性詳細」
  - パンくずリスト
  - ヘッダーアクション
    - 編集ボタン（EditAction）
    - 削除ボタン（DeleteAction）
- コンテンツ部（3カラムレイアウト）
  - 左側（2カラム幅）
    - 基本情報セクション
      - 属性名
      - タイプ
  - 右側（1カラム幅）
    - レコード情報セクション
      - 作成者
      - 作成日時
      - 更新日時

## 入出力項目

本画面は詳細表示画面のため、入力項目なし。

## 表示項目

| 項目名 | 項目ID | データ型 | 説明 |
|--------|--------|----------|------|
| 属性名 | name | 文字列 | 属性の識別名称（太字・大サイズ表示） |
| タイプ | type | Enum | 属性タイプ（Radio/Color等） |
| 作成者 | creator.name | 文字列 | 作成者のユーザー名（ユーザーアイコン付き） |
| 作成日時 | created_at | 日時 | レコード作成日時（カレンダーアイコン付き） |
| 更新日時 | updated_at | 日時 | レコード最終更新日時（時計アイコン付き） |

## イベント仕様

### 1-編集ボタン押下

属性編集画面へ遷移する。

- **前提条件**：ユーザーが編集権限を持っていること
- **処理フロー**：
  1. 編集画面へのルーティング
  2. 属性編集画面の表示

### 2-削除ボタン押下

確認ダイアログを表示し、確認後に属性をソフトデリートする。

- **前提条件**：ユーザーが削除権限を持っていること
- **処理フロー**：
  1. 確認ダイアログの表示
  2. ユーザー確認後、ソフトデリート処理
  3. 成功通知の表示
  4. 一覧画面へのリダイレクト

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | products_attributes | SELECT | 属性レコードの取得 |
| 削除ボタン押下 | products_attributes | UPDATE | deleted_atにタイムスタンプを設定 |

### テーブル別更新項目詳細

#### products_attributes

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE（削除） | deleted_at | システム日時 | ソフトデリート日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-001 | 成功 | 属性が正常に削除されました | 削除処理成功時 |
| MSG-002 | エラー | 指定された属性が見つかりません | レコード未発見時 |

## 例外処理

| 例外パターン | 処理内容 | 画面表示 |
|-------------|---------|---------|
| レコード未発見 | 処理を中断 | 404エラーページを表示 |
| 権限不足 | アクセスを拒否 | 403エラーページを表示 |
| データベース接続エラー | 処理を中断 | システムエラーメッセージを表示 |

## 備考

- 本画面はFilament PHPフレームワークのViewRecordを継承して実装されている
- ヘッダーアクションとしてEditActionとDeleteActionが定義されている
- 削除処理はソフトデリート（deleted_atに日時を設定）
- 表示レイアウトは3カラム構成で、左側に基本情報、右側にレコード情報を表示
- 基本情報セクションでは属性名が太字・大サイズで表示される
- レコード情報セクションは折り畳み可能（collapsible）
- 各項目にはHeroiconが付与されている
