# 画面設計書 228-カテゴリ一覧

## 概要

本ドキュメントは、Aureus ERPシステムの商品モジュールにおける「カテゴリ一覧」画面の設計仕様を定義する。

### 本画面の処理概要

本画面は、商品カテゴリの一覧を表示・管理するための画面である。商品を分類するためのカテゴリを階層構造で管理し、カテゴリの作成・編集・削除などの操作を行うことができる。

**業務上の目的・背景**：商品の体系的な管理において、カテゴリによる分類は非常に重要である。例えば「衣類」の下に「Tシャツ」「パンツ」といった階層構造を設けることで、商品の検索性や管理効率が向上する。本画面は、このような商品カテゴリ階層を一元管理するために提供されている。

**画面へのアクセス方法**：メインメニューから「商品」モジュールを選択し、「カテゴリ」サブメニューをクリックして本画面にアクセスする。

**主要な操作・処理内容**：
1. カテゴリ一覧の表示：登録済みカテゴリをテーブル形式で表示
2. 検索：名前、フルネーム、親パスで検索
3. フィルタリング：親カテゴリ、作成者によるフィルタ
4. グループ化：親カテゴリ、作成者、作成日、更新日によるグループ表示
5. カラム並び替え：テーブルカラムの表示順序を変更可能
6. 新規作成：新しいカテゴリを作成
7. 編集・表示：既存カテゴリの編集・詳細表示
8. 削除：カテゴリの削除（物理削除）

**画面遷移**：メインナビゲーションから遷移する。カテゴリ作成画面、カテゴリ編集画面、カテゴリ詳細画面への遷移が可能。

**権限による表示制御**：カテゴリの閲覧権限を持つユーザーがこの画面にアクセスできる。作成・編集・削除権限がない場合は該当ボタンが非表示となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PRD-013 | カテゴリ一覧 | 主機能 | カテゴリデータの一覧表示・検索・フィルタ |
| FN-PRD-014 | カテゴリ作成 | 遷移先機能 | 新規カテゴリの作成画面への遷移 |
| FN-PRD-015 | カテゴリ編集 | 遷移先機能 | 既存カテゴリの編集画面への遷移 |
| FN-PRD-016 | カテゴリ表示 | 遷移先機能 | カテゴリ詳細画面への遷移 |

## 画面種別

一覧画面（ListRecords）

## URL/ルーティング

```
/admin/products/categories
```

## 画面構成

- ヘッダー部
  - 画面タイトル「カテゴリ一覧」
  - 新規作成ボタン（CreateAction）
- フィルタ部
  - 親カテゴリフィルタ
  - 作成者フィルタ
- テーブル部
  - カラムヘッダー（ソート可能、並び替え可能）
  - データ行
  - 行アクション（表示・編集・削除）
- ツールバー部
  - 一括削除アクション
- フッター部
  - ページネーション

## 入出力項目

本画面は一覧表示画面のため、主に出力項目。

## 表示項目

| 項目名 | 項目ID | データ型 | ソート | 検索 | 説明 |
|--------|--------|----------|------|------|------|
| カテゴリ名 | name | 文字列 | - | ○ | カテゴリの識別名称 |
| フルネーム | full_name | 文字列 | - | ○ | 親を含めた完全名称（例：衣類 / Tシャツ） |
| 親パス | parent_path | 文字列 | - | ○ | 親カテゴリのパス |
| 親カテゴリ | parent.name | 文字列 | ○ | - | 親カテゴリの名称 |
| 作成者 | creator.name | 文字列 | ○ | - | 作成者のユーザー名 |
| 作成日時 | created_at | 日時 | ○ | - | レコード作成日時（初期非表示） |
| 更新日時 | updated_at | 日時 | ○ | - | レコード最終更新日時（初期非表示） |

## イベント仕様

### 1-新規作成ボタン押下

モーダルダイアログが表示され、新規カテゴリを作成する。

- **前提条件**：ユーザーが作成権限を持っていること
- **処理フロー**：
  1. モーダルダイアログの表示
  2. カテゴリ情報の入力
  3. creator_idとcompany_idの自動設定
  4. 保存処理
  5. 成功通知の表示
  6. 一覧の更新

### 2-表示アイコン押下

カテゴリ詳細画面へ遷移する。

### 3-編集アイコン押下

カテゴリ編集画面へ遷移する。

### 4-削除アイコン押下

確認ダイアログを表示し、カテゴリを削除する（物理削除）。子カテゴリや関連商品が存在する場合はエラーとなる。

### 5-一括削除

選択したカテゴリを一括で削除する。外部キー制約違反の場合はエラーとなる。

### 6-親カテゴリフィルタ選択

選択した親カテゴリでカテゴリ一覧をフィルタリングする。

### 7-作成者フィルタ選択

選択した作成者でカテゴリ一覧をフィルタリングする。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | products_categories | SELECT | カテゴリ一覧の取得 |
| 新規作成 | products_categories | INSERT | 新規カテゴリレコードの作成 |
| 削除 | products_categories | DELETE | カテゴリレコードの物理削除 |

### テーブル別更新項目詳細

#### products_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | id | 自動採番 | プライマリキー |
| INSERT | name | フォーム入力値 | カテゴリ名 |
| INSERT | full_name | 自動計算（親名 / 自名） | フルネーム |
| INSERT | parent_path | 自動計算（/親ID/） | 親パス |
| INSERT | parent_id | フォーム入力値 | 親カテゴリへの外部キー |
| INSERT | creator_id | ログインユーザーID | 作成者への外部キー |
| INSERT | company_id | ログインユーザーの所属会社ID | 会社への外部キー |
| INSERT | created_at | システム日時 | 作成日時 |
| INSERT | updated_at | システム日時 | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-001 | 成功 | カテゴリが正常に作成されました | 作成処理成功時 |
| MSG-002 | 成功 | カテゴリが正常に削除されました | 削除処理成功時 |
| MSG-003 | エラー | 関連するデータが存在するため削除できません | 外部キー制約違反時 |
| MSG-004 | 成功 | 選択したカテゴリが一括削除されました | 一括削除成功時 |
| MSG-005 | エラー | 一括削除中にエラーが発生しました | 一括削除失敗時 |

## 例外処理

| 例外パターン | 処理内容 | 画面表示 |
|-------------|---------|---------|
| 権限不足 | アクセスを拒否 | 403エラーページを表示 |
| データベース接続エラー | 処理を中断 | システムエラーメッセージを表示 |
| 外部キー制約違反（削除時） | 削除処理を中断 | 関連データ存在のエラーメッセージを表示 |
| 循環参照検出 | 保存処理を中断 | 循環参照エラーメッセージを表示 |

## 備考

- 本画面はFilament PHPフレームワークのListRecordsを継承して実装されている
- カテゴリは階層構造を持ち、親カテゴリを設定可能
- full_nameとparent_pathはモデルのbootメソッドで自動計算される
- 循環参照（自分自身を親にする、または親の親が自分になる）は検証され、エラーとなる
- カラムの並び替え機能（reorderableColumns）が有効
- ソフトデリートは使用されておらず、削除は物理削除となる
