# 画面設計書 229-カテゴリ作成

## 概要

本ドキュメントは、Aureus ERPシステムの商品モジュールにおける「カテゴリ作成」画面の設計仕様を定義する。

### 本画面の処理概要

本画面は、新規商品カテゴリを作成するための登録画面である。カテゴリ名と親カテゴリを設定することで、階層構造を持つカテゴリを登録できる。

**業務上の目的・背景**：商品を効率的に分類・管理するためには、適切なカテゴリ構造が必要である。本画面では、新しいカテゴリを作成し、既存のカテゴリ階層に追加することができる。例えば、「衣類」カテゴリの下に「Tシャツ」というサブカテゴリを作成するといった操作が可能。

**画面へのアクセス方法**：カテゴリ一覧画面の「新規作成」ボタンをクリックして本画面にアクセスする。または、空の一覧状態で表示される「作成」ボタンからもアクセス可能。

**主要な操作・処理内容**：
1. カテゴリ名の入力：カテゴリの識別名称を設定（一意制約あり）
2. 親カテゴリの選択：階層構造を設定するために親カテゴリを選択（任意）
3. 作成ボタンの押下：入力内容を保存

**画面遷移**：カテゴリ一覧画面から遷移し、作成完了後はカテゴリ詳細画面へリダイレクトする。

**権限による表示制御**：カテゴリの作成権限を持つユーザーのみがこの画面にアクセスできる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PRD-014 | カテゴリ作成 | 主機能 | 新規カテゴリデータの作成・保存処理 |
| FN-PRD-013 | カテゴリ一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-PRD-016 | カテゴリ表示 | 遷移先機能 | 作成完了後の詳細画面への遷移 |

## 画面種別

登録画面（CreateRecord）

## URL/ルーティング

```
/admin/products/categories/create
```

## 画面構成

- ヘッダー部
  - 画面タイトル「カテゴリ作成」
  - パンくずリスト
- フォーム部（1カラムレイアウト）
  - 左側（2カラム幅）
    - 基本情報セクション
      - カテゴリ名
      - 親カテゴリ
  - 右側（1カラム幅）
    - （空のグループ、将来の拡張用）
- フッター部
  - 作成ボタン
  - キャンセルボタン

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | 必須 | データ型 | 最大長 | 初期値 | 説明 |
|--------|--------|----------|------|----------|--------|--------|------|
| カテゴリ名 | name | 入力 | ○ | 文字列 | 255 | - | カテゴリの識別名称（一意制約あり） |
| 親カテゴリ | parent_id | 入力 | - | 数値（外部キー） | - | - | 親カテゴリへの参照 |
| フルネーム | full_name | 出力 | - | 文字列 | - | 自動計算 | 親を含めた完全名称 |
| 親パス | parent_path | 出力 | - | 文字列 | - | 自動計算 | 親カテゴリのパス |
| 作成者ID | creator_id | 出力 | - | 数値（外部キー） | - | ログインユーザーID | 作成者の参照 |
| 会社ID | company_id | 出力 | - | 数値（外部キー） | - | ログインユーザーの所属会社ID | 会社の参照 |

## 表示項目

本画面は登録画面のため、該当なし。

## イベント仕様

### 1-作成ボタン押下

入力されたフォームデータのバリデーションを実行し、問題がなければカテゴリデータをデータベースに保存する。

- **前提条件**：必須項目（カテゴリ名）が入力されていること
- **処理フロー**：
  1. クライアントサイドバリデーション
  2. サーバーサイドバリデーション
  3. 一意制約の検証
  4. 循環参照の検証
  5. creator_idに現在のログインユーザーIDを設定
  6. company_idにログインユーザーの所属会社IDを設定
  7. full_nameとparent_pathの自動計算
  8. データベースへの保存処理
  9. 成功通知の表示
  10. 詳細画面へのリダイレクト

### 2-親カテゴリ選択

親カテゴリを選択する。検索可能なセレクトボックスで、full_nameで表示される。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成ボタン押下 | products_categories | INSERT | 新規カテゴリレコードの作成 |

### テーブル別更新項目詳細

#### products_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | id | 自動採番 | プライマリキー |
| INSERT | name | フォーム入力値 | カテゴリ名（一意制約） |
| INSERT | parent_id | フォーム入力値 | 親カテゴリへの外部キー |
| INSERT | full_name | 自動計算 | bootメソッドで計算（親名 / 自名） |
| INSERT | parent_path | 自動計算 | bootメソッドで計算（/親ID/） |
| INSERT | creator_id | ログインユーザーID | 作成者への外部キー |
| INSERT | company_id | ログインユーザーの所属会社ID | 会社への外部キー |
| INSERT | created_at | システム日時 | 作成日時 |
| INSERT | updated_at | システム日時 | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-001 | 成功 | カテゴリが正常に作成されました | 作成処理成功時 |
| MSG-002 | エラー | カテゴリ名は必須です | カテゴリ名未入力時 |
| MSG-003 | エラー | カテゴリ名は255文字以内で入力してください | カテゴリ名が最大長超過時 |
| MSG-004 | エラー | このカテゴリ名は既に使用されています | 一意制約違反時 |
| MSG-005 | エラー | カテゴリ階層に循環参照が検出されました | 循環参照エラー時 |
| MSG-006 | エラー | エラーが発生しました | 一般的なエラー時（例外メッセージを表示） |

## 例外処理

| 例外パターン | 処理内容 | 画面表示 |
|-------------|---------|---------|
| バリデーションエラー | 保存処理を中断 | 該当項目にエラーメッセージを表示 |
| 一意制約違反 | 保存処理を中断 | カテゴリ名にエラーメッセージを表示 |
| 循環参照検出 | 保存処理を中断 | InvalidArgumentExceptionをキャッチしエラー通知 |
| データベース接続エラー | トランザクションロールバック | システムエラーメッセージを表示 |
| 権限不足 | 処理を拒否 | 403エラーページを表示 |
| その他の例外 | 例外メッセージを通知 | エラー通知を表示 |

## 備考

- 本画面はFilament PHPフレームワークのCreateRecordを継承して実装されている
- カテゴリ名は一意制約（unique）が設定されている（ignoreRecord: true）
- 親カテゴリ選択は検索可能（searchable）でプリロード（preload）が有効
- full_nameとparent_pathはモデルのbootメソッドで自動計算される
- 循環参照の検証はモデルのcreatingイベントで実行される
- 作成完了後はカテゴリ詳細画面へリダイレクトされる（getRedirectUrl）
- createメソッドをオーバーライドして例外処理を実装している
