# 画面設計書 23-財務ポジション税管理

## 概要

本ドキュメントは、Aureus ERPシステムにおける財務ポジション税管理画面の設計仕様を定義します。この画面では、特定の財務ポジションに対する税マッピング（ソース税→宛先税の変換ルール）を管理します。

### 本画面の処理概要

**業務上の目的・背景**：
財務ポジション税管理は、異なる税務管轄区域間での取引において、元の税（Tax Source）を適切な宛先税（Tax Destination）に自動変換するためのマッピングルールを設定する機能です。例えば、EU域内取引ではVATを免除に変換したり、輸出取引では国内消費税を0%に変換するなどの設定が可能です。これにより、取引先の所在地に応じた税処理の自動化を実現します。

**画面へのアクセス方法**：
1. サイドメニューから「会計」モジュールを選択
2. 設定メニューから「財務ポジション」を選択して一覧画面へ遷移
3. 一覧から対象レコードを選択し、詳細画面へ遷移
4. サブナビゲーションから「税マッピング」タブを選択

**主要な操作・処理内容**：
1. 税マッピングルールの一覧表示
2. 新規税マッピングの作成
3. 既存税マッピングの編集
4. 税マッピングの削除
5. 税マッピングの詳細表示

**画面遷移**：
- 遷移元：財務ポジション詳細画面、財務ポジション編集画面
- 遷移先：財務ポジション詳細画面、財務ポジション編集画面（サブナビゲーション経由）

**権限による表示制御**：
会計モジュールへのアクセス権限を持つユーザーのみがこの画面にアクセスできます。作成・編集・削除操作には適切な権限が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-025 | 財務ポジション管理 | 主機能 | 税マッピングルールの管理 |
| SCR-ACC-012 | FiscalPositionResource | 親リソース | 財務ポジションとのリレーション |

## 画面種別

関連レコード管理（ManageRelatedRecords）

## URL/ルーティング

`/admin/accounts/fiscal-positions/{record}/fiscal-position-tax`

## 画面構成

- サブナビゲーション（画面上部）
  - 詳細タブ
  - 編集タブ
  - 税マッピングタブ（現在の画面）
- ヘッダーアクション
  - 作成ボタン（CreateAction）
- テーブル
  - ソース税（Tax Source）カラム
  - 宛先税（Tax Destination）カラム
  - 行アクション（表示・編集・削除）
- モーダルフォーム（作成・編集時）

## 入出力項目

### フォーム項目（作成・編集モーダル）

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 初期値 | 備考 |
|--------|--------|----------|----------|------|--------|------|
| ソース税 | tax_source_id | 入力 | integer | ○ | - | 税マスタとのリレーション |
| 宛先税 | tax_destination_id | 入力 | integer | - | null | 税マスタとのリレーション |
| 作成者ID | creator_id | 隠し | integer | ○ | 現在ユーザー | 自動設定 |
| 会社ID | company_id | 隠し | integer | ○ | 現在ユーザーのデフォルト会社 | 自動設定 |

## 表示項目

### テーブル表示項目

| 項目名 | 項目ID | データ型 | 表示形式 | ソート | 検索 |
|--------|--------|----------|----------|--------|------|
| ソース税 | taxSource.name | string | テキスト | ○ | ○ |
| 宛先税 | taxDestination.name | string | テキスト | ○ | ○ |

### 詳細表示項目（Infolist）

| 項目名 | 項目ID | データ型 | 表示形式 | アイコン |
|--------|--------|----------|----------|---------|
| ソース税 | taxSource.name | string | テキスト | heroicon-o-receipt-percent |
| 宛先税 | taxDestination.name | string | テキスト | heroicon-o-receipt-percent |

## イベント仕様

### 1-作成ボタン押下

1. 作成モーダルフォームを表示
2. フォーム入力後、保存ボタン押下
3. `mutateDataUsing`でcreator_idとcompany_idを自動設定
4. データベースに新規レコードを挿入
5. 成功通知を表示
6. テーブルを更新

### 2-編集ボタン押下（行アクション）

1. 編集モーダルフォームを表示（既存データをプリロード）
2. フォーム編集後、保存ボタン押下
3. データベースを更新
4. 成功通知を表示
5. テーブルを更新

### 3-削除ボタン押下（行アクション）

1. 確認ダイアログ表示
2. ユーザーが確認した場合、レコードを削除
3. 成功通知を表示
4. テーブルを更新

### 4-表示ボタン押下（行アクション）

1. 詳細情報をインフォリスト形式で表示

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | fiscal_position_taxes | SELECT | 税マッピングルール一覧の取得 |
| 作成ボタン押下 | fiscal_position_taxes | INSERT | 新規税マッピングルールの作成 |
| 編集ボタン押下 | fiscal_position_taxes | UPDATE | 税マッピングルールの更新 |
| 削除ボタン押下 | fiscal_position_taxes | DELETE | 税マッピングルールの削除 |

### テーブル別更新項目詳細

#### fiscal_position_taxes

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | fiscal_position_id | 親レコードのID | 自動設定 |
| INSERT | tax_source_id | フォーム入力値 | 必須 |
| INSERT | tax_destination_id | フォーム入力値 | nullable |
| INSERT | creator_id | Auth::user()->id | 自動設定 |
| INSERT | company_id | Auth::user()->default_company_id | 自動設定 |
| UPDATE | tax_source_id | フォーム入力値 | 必須 |
| UPDATE | tax_destination_id | フォーム入力値 | nullable |
| UPDATE | updated_at | 現在日時 | 自動更新 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| fiscal-position-tax.table.header-actions.create.notification.title | 成功 | 作成成功タイトル | 作成処理成功時 |
| fiscal-position-tax.table.header-actions.create.notification.body | 成功 | 作成成功メッセージ本文 | 作成処理成功時 |
| fiscal-position-tax.table.actions.edit.notification.title | 成功 | 編集成功タイトル | 編集処理成功時 |
| fiscal-position-tax.table.actions.edit.notification.body | 成功 | 編集成功メッセージ本文 | 編集処理成功時 |
| fiscal-position-tax.table.actions.delete.notification.title | 成功 | 削除成功タイトル | 削除処理成功時 |
| fiscal-position-tax.table.actions.delete.notification.body | 成功 | 削除成功メッセージ本文 | 削除処理成功時 |

## 例外処理

| 例外種別 | 発生条件 | 対処方法 |
|---------|---------|---------|
| 親レコード未存在 | URLパラメータのrecord（財務ポジション）が存在しない場合 | 404エラーページを表示 |
| 権限不足 | 操作権限がないユーザーがアクセス | 403エラーまたはリダイレクト |
| バリデーションエラー | ソース税未選択など | フォームにエラーメッセージを表示 |
| リレーション先不在 | 参照先の税が削除されている場合 | プレースホルダー「-」を表示 |

## 備考

- 本画面はFilament PHPのManageRelatedRecordsページを継承して実装されている
- リレーション名は`fiscalPositionTaxes`
- サブナビゲーションは画面上部（Top）に配置される
- ナビゲーションアイコンは`heroicon-o-document`
- FiscalPositionTaxトレイトを使用してフォーム・テーブル・インフォリストを定義
- 税の選択はリレーション選択により検索・プリロード可能
