# 画面設計書 230-カテゴリ編集

## 概要

本ドキュメントは、Aureus ERPシステムの商品モジュールにおける「カテゴリ編集」画面の設計仕様を定義する。

### 本画面の処理概要

本画面は、既存の商品カテゴリ情報を編集・更新するための画面である。カテゴリ名や親カテゴリを変更することができる。親カテゴリを変更した場合、フルネームや親パスが自動的に再計算される。

**業務上の目的・背景**：ビジネス要件の変化や組織再編に伴い、既存のカテゴリ構造を修正する必要がある。例えば、カテゴリ名の変更や、カテゴリ階層の再構成などが必要な場合に使用される。本画面は、カテゴリマスタのメンテナンス業務を効率的に行うために提供されている。

**画面へのアクセス方法**：カテゴリ一覧画面でレコードの編集アイコンをクリックするか、カテゴリ詳細画面のヘッダーにある「編集」ボタンをクリックして本画面にアクセスする。

**主要な操作・処理内容**：
1. 既存データの表示：データベースからカテゴリ情報を読み込み、フォームに表示
2. カテゴリ名の変更：識別名称を修正
3. 親カテゴリの変更：階層構造を変更
4. 保存ボタンの押下：変更内容をデータベースに反映（full_name, parent_path自動更新）
5. 削除ボタンの押下：カテゴリを削除（物理削除）

**画面遷移**：カテゴリ一覧画面またはカテゴリ詳細画面から遷移する。ヘッダーには「表示」ボタンと「削除」ボタンが配置されている。

**権限による表示制御**：カテゴリの編集権限を持つユーザーのみがこの画面にアクセスできる。削除権限がない場合は削除ボタンが非表示となる。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PRD-015 | カテゴリ編集 | 主機能 | カテゴリデータの更新処理 |
| FN-PRD-013 | カテゴリ一覧 | 遷移元機能 | 一覧画面からの遷移 |
| FN-PRD-016 | カテゴリ表示 | 遷移先機能 | 詳細画面への遷移（表示ボタン） |

## 画面種別

編集画面（EditRecord）

## URL/ルーティング

```
/admin/products/categories/{record}/edit
```

## 画面構成

- ヘッダー部
  - 画面タイトル「カテゴリ編集」
  - パンくずリスト
  - ヘッダーアクション
    - 表示ボタン（ViewAction）
    - 削除ボタン（DeleteAction）
- フォーム部（1カラムレイアウト）
  - 左側（2カラム幅）
    - 基本情報セクション
      - カテゴリ名
      - 親カテゴリ
  - 右側（1カラム幅）
    - （空のグループ、将来の拡張用）
- フッター部
  - 保存ボタン
  - キャンセルボタン

## 入出力項目

| 項目名 | 項目ID | 入力/出力 | 必須 | データ型 | 最大長 | 初期値 | 説明 |
|--------|--------|----------|------|----------|--------|--------|------|
| カテゴリID | id | 出力 | - | 数値 | - | 既存データ | プライマリキー（編集不可） |
| カテゴリ名 | name | 入力 | ○ | 文字列 | 255 | 既存データ | カテゴリの識別名称（一意制約あり） |
| 親カテゴリ | parent_id | 入力 | - | 数値（外部キー） | - | 既存データ | 親カテゴリへの参照 |
| フルネーム | full_name | 出力 | - | 文字列 | - | 自動計算 | 親を含めた完全名称 |
| 親パス | parent_path | 出力 | - | 文字列 | - | 自動計算 | 親カテゴリのパス |

## 表示項目

本画面は編集画面のため、入力項目と同一。

## イベント仕様

### 1-保存ボタン押下

入力されたフォームデータのバリデーションを実行し、問題がなければカテゴリデータを更新する。

- **前提条件**：必須項目（カテゴリ名）が入力されていること
- **処理フロー**：
  1. クライアントサイドバリデーション
  2. サーバーサイドバリデーション
  3. 一意制約の検証（自身のレコードは除外）
  4. 循環参照の検証
  5. full_nameとparent_pathの自動再計算
  6. データベースの更新処理
  7. 成功通知の表示

### 2-表示ボタン押下

カテゴリ詳細画面へ遷移する。

### 3-削除ボタン押下

確認ダイアログを表示し、確認後にカテゴリを削除する（物理削除）。子カテゴリや関連商品が存在する場合はエラーとなる。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | products_categories | UPDATE | カテゴリレコードの更新 |
| 削除ボタン押下 | products_categories | DELETE | カテゴリレコードの物理削除 |

### テーブル別更新項目詳細

#### products_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | カテゴリ名（一意制約） |
| UPDATE | parent_id | フォーム入力値 | 親カテゴリへの外部キー |
| UPDATE | full_name | 自動再計算 | bootメソッドで計算（親名 / 自名） |
| UPDATE | parent_path | 自動再計算 | bootメソッドで計算（/親ID/） |
| UPDATE | updated_at | システム日時 | 更新日時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| MSG-001 | 成功 | カテゴリが正常に更新されました | 更新処理成功時 |
| MSG-002 | 成功 | カテゴリが正常に削除されました | 削除処理成功時 |
| MSG-003 | エラー | カテゴリ名は必須です | カテゴリ名未入力時 |
| MSG-004 | エラー | このカテゴリ名は既に使用されています | 一意制約違反時 |
| MSG-005 | エラー | カテゴリ階層に循環参照が検出されました | 循環参照エラー時 |
| MSG-006 | エラー | 関連するデータが存在するため削除できません | 外部キー制約違反（削除時） |
| MSG-007 | エラー | エラーが発生しました | 一般的なエラー時 |
| MSG-008 | 確認 | このカテゴリを削除してもよろしいですか？ | 削除ボタン押下時 |

## 例外処理

| 例外パターン | 処理内容 | 画面表示 |
|-------------|---------|---------|
| レコード未発見 | 処理を中断 | 404エラーページを表示 |
| バリデーションエラー | 保存処理を中断 | 該当項目にエラーメッセージを表示 |
| 一意制約違反 | 保存処理を中断 | カテゴリ名にエラーメッセージを表示 |
| 循環参照検出 | 保存処理を中断 | エラー通知を表示 |
| 外部キー制約違反（削除時） | 削除処理を中断 | 関連データ存在のエラーメッセージを表示 |
| その他の例外 | 例外メッセージを通知 | エラー通知を表示 |
| 権限不足 | 処理を拒否 | 403エラーページを表示 |

## 備考

- 本画面はFilament PHPフレームワークのEditRecordを継承して実装されている
- HasRecordNavigationTabsトレイトを使用（関連レコード間のナビゲーション）
- ヘッダーアクションとしてViewActionとDeleteActionが定義されている
- 削除処理では外部キー制約違反をキャッチして適切なエラー通知を表示
- saveメソッドをオーバーライドして例外処理を実装
- 循環参照の検証はモデルのupdatingイベントで実行される
- 親カテゴリを変更した場合、full_nameとparent_pathが自動的に再計算される
- 成功通知はFilamentのNotification機能を使用
