# 画面設計書 231-カテゴリ詳細

## 概要

本ドキュメントは、商品カテゴリの詳細情報を表示する画面の設計書です。カテゴリの階層構造、作成者情報、作成日時等の情報を閲覧できます。

### 本画面の処理概要

**業務上の目的・背景**：商品カテゴリは商品を体系的に分類・管理するための重要な要素です。本画面では、登録されたカテゴリの詳細情報を確認することで、カテゴリ構造の把握、親カテゴリとの関係性の確認、および管理者による適切なカテゴリ運用を支援します。商品管理業務において、カテゴリの正確な把握は在庫管理や販売分析の基盤となります。

**画面へのアクセス方法**：商品モジュールのカテゴリ一覧画面（ListCategories）から対象のカテゴリ行をクリック、または行アクションの「表示」ボタンをクリックすることでアクセスできます。

**主要な操作・処理内容**：
1. カテゴリ名、親カテゴリ、フルパス等の基本情報の閲覧
2. 作成者、作成日時、更新日時等のレコード情報の確認
3. 編集ボタンによる編集画面への遷移
4. 削除ボタンによるカテゴリの削除処理

**画面遷移**：
- 遷移元：カテゴリ一覧画面（ListCategories）
- 遷移先：カテゴリ編集画面（EditCategory）、カテゴリ一覧画面（削除後）

**権限による表示制御**：カテゴリリソースに対する「view」権限を持つユーザーのみがアクセス可能です。編集・削除ボタンは各操作に対する権限保持者にのみ表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PRD-016 | カテゴリ表示 | 主機能 | カテゴリ詳細情報の表示 |
| FN-PRD-015 | カテゴリ編集 | 遷移先機能 | 編集ボタン押下時の遷移 |
| FN-PRD-013 | カテゴリ一覧 | 遷移元機能 | 一覧からの遷移元 |

## 画面種別

詳細

## URL/ルーティング

`/admin/products/categories/{record}`

## 画面構成

- ヘッダーアクション領域
  - 編集ボタン（EditAction）
  - 削除ボタン（DeleteAction）
- メインコンテンツ領域（3カラムレイアウト）
  - 左側（2カラム分）
    - 一般情報セクション
  - 右側（1カラム分）
    - レコード情報セクション

## 入出力項目

本画面は詳細表示画面のため、入力項目はありません。

## 表示項目

### 一般情報セクション

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| カテゴリ名（name） | テキスト（太字・大サイズ） | カテゴリの名称 |
| 親カテゴリ（parent.name） | テキスト（アイコン付き） | 親カテゴリの名称。未設定時は「—」表示 |
| フルパス名（full_name） | テキスト（アイコン付き） | ルートからのフルパス表示 |
| 親パス（parent_path） | テキスト（アイコン付き） | 親カテゴリまでのパス |

### レコード情報セクション

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| 作成者（creator.name） | テキスト（アイコン付き） | カテゴリを作成したユーザー名 |
| 作成日時（created_at） | 日時（アイコン付き） | カテゴリの作成日時 |
| 更新日時（updated_at） | 日時（アイコン付き） | カテゴリの最終更新日時 |

## イベント仕様

### 01-編集ボタン押下

編集ボタン（EditAction）をクリックすると、カテゴリ編集画面（EditCategory）へ遷移します。

### 02-削除ボタン押下

削除ボタン（DeleteAction）をクリックすると、確認ダイアログが表示され、確認後にカテゴリを削除します。削除成功時は成功通知が表示され、削除失敗時（子カテゴリや関連商品が存在する場合）はエラー通知が表示されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除ボタン押下 | products_categories | DELETE | カテゴリレコードの削除 |

### テーブル別更新項目詳細

#### products_categories

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| DELETE | - | WHERE id = {record_id} | 外部キー制約違反時は例外発生 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| delete.notification.success.title | 成功 | カテゴリが削除されました | 削除成功時 |
| delete.notification.success.body | 成功 | カテゴリが正常に削除されました | 削除成功時 |
| delete.notification.error.title | エラー | カテゴリを削除できません | 削除失敗時（外部キー制約違反） |
| delete.notification.error.body | エラー | このカテゴリは使用中のため削除できません | 削除失敗時 |

## 例外処理

| 例外種別 | 発生条件 | 対応処理 |
|---------|---------|---------|
| QueryException | 削除時に外部キー制約違反が発生した場合 | エラー通知を表示し、削除処理を中断 |
| RecordNotFound | 指定されたIDのカテゴリが存在しない場合 | 404エラーページを表示 |
| AuthorizationException | viewの権限がない場合 | 403エラーページを表示 |

## 備考

- HasRecordNavigationTabsトレイトを使用しており、レコード間のナビゲーションタブが表示されます
- カテゴリは階層構造を持つため、削除時は子カテゴリや関連商品の存在を確認する必要があります
