# 画面設計書 232-パッケージング管理

## 概要

本ドキュメントは、商品パッケージング情報を一元管理するManageRecordsタイプの画面の設計書です。商品の梱包単位、バーコード、数量等のパッケージング情報の登録・編集・削除・一覧表示を行います。

### 本画面の処理概要

**業務上の目的・背景**：商品パッケージングは、商品の梱包単位（ケース、パレット等）を管理するための機能です。販売・購買・在庫管理において、商品の取引単位を適切に管理することで、効率的な物流オペレーションを実現します。バーコード管理により、入出荷時のスキャン処理を効率化し、在庫精度の向上に貢献します。

**画面へのアクセス方法**：商品モジュールのナビゲーションメニューから「パッケージング」を選択、または商品設定画面からアクセスできます。

**主要な操作・処理内容**：
1. パッケージング情報の一覧表示（名前、商品、数量、バーコード、会社）
2. 新規パッケージングの作成（モーダルフォーム）
3. 既存パッケージングの編集（インライン編集）
4. パッケージングの削除（単体・一括）
5. バーコードの印刷（PDF出力）
6. 商品別グループ化表示

**画面遷移**：本画面はManageRecordsタイプのため、CRUD操作は全てモーダルダイアログで完結します。

**権限による表示制御**：パッケージングリソースに対する各権限（create、edit、delete）に基づき、対応するアクションボタンの表示・非表示が制御されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PRD-026 | パッケージング管理 | 主機能 | パッケージングのCRUD操作 |
| FN-PRD-001 | 商品一覧 | 補助機能 | 商品選択時の参照 |

## 画面種別

管理（ManageRecords）

## URL/ルーティング

`/admin/products/packagings`

## 画面構成

- ヘッダー領域
  - 画面タイトル
  - 作成ボタン（CreateAction）
- テーブル領域
  - データテーブル（フィルタ、ソート、グループ化対応）
  - 行アクション（表示・編集・削除）
  - 一括アクション（印刷・削除）
- 空状態表示
  - データがない場合の作成ボタン

## 入出力項目

### 作成・編集フォーム

| 項目名 | 項目ID | 入力種別 | 必須 | 最大長 | 説明 |
|--------|--------|----------|------|--------|------|
| パッケージング名 | name | テキスト | ○ | 255 | パッケージングの名称 |
| バーコード | barcode | テキスト | - | 255 | パッケージングのバーコード |
| 商品 | product_id | セレクト | ○ | - | 対象商品（type=goodsのみ） |
| 数量 | qty | 数値 | ○ | - | パッケージング内の数量（0〜99999999） |
| 会社 | company_id | セレクト | - | - | 所属会社 |

## 表示項目

### テーブル列

| 項目名 | 表示形式 | ソート | 検索 | 説明 |
|--------|----------|--------|------|------|
| パッケージング名（name） | テキスト | - | ○ | パッケージングの名称 |
| 商品（product.name） | テキスト | ○ | ○ | 関連商品名 |
| 数量（qty） | 数値 | ○ | - | パッケージング内の数量 |
| バーコード（barcode） | テキスト | - | ○ | バーコード |
| 会社（company.name） | テキスト | ○ | - | 所属会社名 |
| 作成日時（created_at） | 日時 | ○ | - | 作成日時（初期非表示） |
| 更新日時（updated_at） | 日時 | ○ | - | 更新日時（初期非表示） |

### 詳細表示（Infolist）

| セクション | 項目名 | 表示形式 | 説明 |
|-----------|--------|----------|------|
| 一般情報 | パッケージング名 | テキスト（太字・大サイズ・アイコン付き） | パッケージングの名称 |
| 一般情報 | バーコード | テキスト（アイコン付き） | バーコード |
| 一般情報 | 商品 | テキスト（アイコン付き） | 関連商品名 |
| 一般情報 | 数量 | テキスト（アイコン付き） | パッケージング内の数量 |
| 組織情報 | 会社 | テキスト（アイコン付き） | 所属会社 |
| 組織情報 | 作成者 | テキスト（アイコン付き） | 作成したユーザー名 |
| 組織情報 | 作成日時 | 日時（アイコン付き） | 作成日時 |
| 組織情報 | 更新日時 | 日時（アイコン付き） | 更新日時 |

## イベント仕様

### 01-作成ボタン押下

ヘッダーまたは空状態の作成ボタンをクリックすると、作成モーダルが表示されます。フォーム送信時にcreator_idが自動設定されます。

### 02-編集アクション押下

行の編集アクションをクリックすると、編集モーダルが表示されます。更新成功時に成功通知が表示されます。

### 03-削除アクション押下

行の削除アクションをクリックすると、確認ダイアログが表示されます。削除成功時は成功通知、失敗時はエラー通知が表示されます。

### 04-印刷アクション押下

選択したレコードのバーコードをPDFとして出力します。A4縦向きで「Packaging-Barcode.pdf」としてダウンロードされます。

### 05-一括削除アクション押下

選択した複数レコードを一括削除します。削除成功時は成功通知、失敗時はエラー通知が表示されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成ボタン押下 | products_packagings | INSERT | 新規パッケージングの登録 |
| 編集アクション押下 | products_packagings | UPDATE | パッケージング情報の更新 |
| 削除アクション押下 | products_packagings | DELETE | パッケージングの削除 |
| 一括削除アクション押下 | products_packagings | DELETE | 複数パッケージングの削除 |

### テーブル別更新項目詳細

#### products_packagings

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | barcode | フォーム入力値 | 任意 |
| INSERT | product_id | フォーム選択値 | 必須 |
| INSERT | qty | フォーム入力値 | 必須（0以上） |
| INSERT | company_id | フォーム選択値 | 任意 |
| INSERT | creator_id | Auth::id() | 自動設定 |
| UPDATE | name, barcode, product_id, qty, company_id | フォーム入力値 | 対象レコードを更新 |
| DELETE | - | WHERE id = {record_id} | - |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| create.notification.title | 成功 | パッケージングが作成されました | 作成成功時 |
| create.notification.body | 成功 | パッケージングが正常に作成されました | 作成成功時 |
| edit.notification.title | 成功 | パッケージングが更新されました | 編集成功時 |
| edit.notification.body | 成功 | パッケージングが正常に更新されました | 編集成功時 |
| delete.notification.success.title | 成功 | パッケージングが削除されました | 削除成功時 |
| delete.notification.success.body | 成功 | パッケージングが正常に削除されました | 削除成功時 |
| delete.notification.error.title | エラー | パッケージングを削除できません | 削除失敗時 |
| delete.notification.error.body | エラー | このパッケージングは使用中のため削除できません | 削除失敗時 |
| bulk-delete.notification.success.title | 成功 | パッケージングが一括削除されました | 一括削除成功時 |
| bulk-delete.notification.error.title | エラー | パッケージングを一括削除できません | 一括削除失敗時 |

## 例外処理

| 例外種別 | 発生条件 | 対応処理 |
|---------|---------|---------|
| QueryException | 削除時に外部キー制約違反が発生した場合 | エラー通知を表示し、削除処理を中断 |
| ValidationException | 必須項目未入力、バリデーションエラー | フォームにエラーメッセージを表示 |
| AuthorizationException | 操作権限がない場合 | 403エラーまたはアクションボタン非表示 |

## 備考

- 商品選択はtype=goodsの商品のみ対象（サービス商品は除外）
- 削除済み商品は選択肢に表示されるが、選択不可（Deleted表示）
- バーコード印刷機能はbarryvdh/laravel-dompdfを使用
- グループ化機能で商品別、作成日別、更新日別の表示が可能
