# 画面設計書 233-プロジェクト一覧

## 概要

本ドキュメントは、プロジェクト管理モジュールのプロジェクト一覧画面の設計書です。登録されているプロジェクトをカード形式のグリッドレイアウトで表示し、プリセットビュー（タブ）による絞り込みやお気に入り機能を提供します。

### 本画面の処理概要

**業務上の目的・背景**：プロジェクト管理は、組織の業務を体系的に管理するための中核機能です。本画面では、全プロジェクトの概要把握、進捗状況の確認、担当プロジェクトへの素早いアクセスを可能にします。カード形式のビジュアル表示により、プロジェクトの状態（顧客、期間、担当者、タグ等）を一目で把握でき、プロジェクトマネージャーや経営層の意思決定を支援します。

**画面へのアクセス方法**：メインナビゲーションの「プロジェクト」メニューから「プロジェクト」を選択、またはダッシュボードからアクセスできます。

**主要な操作・処理内容**：
1. プロジェクト一覧のカード形式表示（グリッドレイアウト）
2. プリセットビュー（マイプロジェクト、お気に入り、未割当、アーカイブ）による絞り込み
3. お気に入り登録・解除（スター切替）
4. 新規プロジェクトの作成画面への遷移
5. プロジェクト詳細画面への遷移
6. タスク管理画面・マイルストーン管理画面への直接遷移
7. プロジェクトの編集・削除・復元・完全削除

**画面遷移**：
- 遷移先：プロジェクト作成画面、プロジェクト詳細画面、プロジェクト編集画面、タスク管理画面、マイルストーン管理画面

**権限による表示制御**：プロジェクトの可視性設定（private/internal/public）とユーザー権限に基づき、表示されるプロジェクトが制御されます。削除・復元・完全削除は各操作権限保持者にのみ表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PROJ-001 | プロジェクト一覧 | 主機能 | プロジェクトの一覧表示 |
| FN-PROJ-002 | プロジェクト作成 | 遷移先機能 | 作成ボタン押下時の遷移 |
| FN-PROJ-004 | プロジェクト表示 | 遷移先機能 | カード押下時の遷移 |
| FN-PROJ-005 | タスク管理 | 遷移先機能 | タスクボタン押下時の遷移 |
| FN-PROJ-006 | マイルストーン管理 | 遷移先機能 | マイルストーンボタン押下時の遷移 |
| FN-PROJ-007 | お気に入り | 補助機能 | お気に入り登録・解除 |

## 画面種別

一覧

## URL/ルーティング

`/admin/project/projects`

## 画面構成

- ヘッダー領域
  - 画面タイトル
  - 作成ボタン（CreateAction）
- プリセットビュー（タブ）領域
  - マイプロジェクト
  - お気に入りプロジェクト
  - 未割当プロジェクト
  - アーカイブ済みプロジェクト
- コンテンツグリッド領域（レスポンシブ：sm=1列、md=2列、xl=3列、2xl=4列）
  - プロジェクトカード
- フィルタ領域（モーダル・スライドオーバー）

## 入出力項目

本画面は一覧表示画面のため、直接の入力項目はありません（フィルタ条件を除く）。

## 表示項目

### プロジェクトカード表示

| 項目名 | 表示形式 | 表示条件 | 説明 |
|--------|----------|----------|------|
| プロジェクト名（name） | テキスト（太字） | 常時 | プロジェクトの名称 |
| 顧客名（partner.name） | テキスト（アイコン付き） | 顧客が設定されている場合 | 関連顧客名 |
| 期間 | テキスト（アイコン付き） | 開始日・終了日が設定されている場合 | 「開始日 - 終了日」形式 |
| 残時間（remaining_hours） | バッジ | タイムシート有効かつ残時間がある場合 | 残り時間（色分け：正=success、負=danger） |
| プロジェクトマネージャー（user.name） | テキスト（アイコン付き） | 担当者が設定されている場合 | プロジェクト担当者名 |
| タグ（tags.name） | バッジ（複数） | タグが設定されている場合 | タグ名（各タグの色で表示） |

### 行アクション

| アクション名 | アイコン | 表示条件 | 説明 |
|-------------|---------|----------|------|
| お気に入り | star（塗りつぶし/輪郭） | 常時 | お気に入り登録・解除の切替 |
| タスク | clipboard-document-list | 削除済みでない場合 | タスク管理画面へ遷移（タスク数表示） |
| マイルストーン | flag | マイルストーン有効かつ削除済みでない場合 | マイルストーン管理画面へ遷移（完了/全数表示） |
| 編集 | - | 削除済みでない場合 | 編集画面へ遷移 |
| 復元 | - | 削除済みの場合 | ソフトデリートからの復元 |
| 削除 | - | 削除済みでない場合 | ソフトデリート |
| 完全削除 | - | 削除済みの場合 | 物理削除 |

## イベント仕様

### 01-作成ボタン押下

ヘッダーの作成ボタンをクリックすると、プロジェクト作成画面（CreateProject）へ遷移します。

### 02-プロジェクトカード押下

プロジェクトカードをクリックすると、プロジェクト詳細画面（ViewProject）へ遷移します。

### 03-お気に入りボタン押下

スターアイコンをクリックすると、お気に入り状態をトグルします。中間テーブル（projects_user_project_favorites）にレコードが追加または削除されます。

### 04-タスクボタン押下

タスクボタンをクリックすると、該当プロジェクトのタスク管理画面（ManageTasks）へ遷移します。

### 05-マイルストーンボタン押下

マイルストーンボタンをクリックすると、該当プロジェクトのマイルストーン管理画面（ManageMilestones）へ遷移します。

### 06-削除アクション押下

削除アクションをクリックすると、プロジェクトをソフトデリートします（deleted_atを設定）。

### 07-復元アクション押下

復元アクションをクリックすると、ソフトデリートされたプロジェクトを復元します（deleted_atをnullに）。

### 08-完全削除アクション押下

完全削除アクションをクリックすると、プロジェクトを物理削除します。関連データがある場合はエラーとなります。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| お気に入りボタン押下 | projects_user_project_favorites | INSERT/DELETE | お気に入りの登録・解除 |
| 削除アクション押下 | projects_projects | UPDATE | deleted_atの設定（ソフトデリート） |
| 復元アクション押下 | projects_projects | UPDATE | deleted_atのクリア |
| 完全削除アクション押下 | projects_projects | DELETE | レコードの物理削除 |

### テーブル別更新項目詳細

#### projects_user_project_favorites

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | project_id | 対象プロジェクトID | お気に入り登録時 |
| INSERT | user_id | Auth::id() | お気に入り登録時 |
| DELETE | - | WHERE project_id = ? AND user_id = ? | お気に入り解除時 |

#### projects_projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | deleted_at | 現在日時 | 削除時 |
| UPDATE | deleted_at | NULL | 復元時 |
| DELETE | - | WHERE id = ? | 完全削除時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| restore.notification.title | 成功 | プロジェクトが復元されました | 復元成功時 |
| restore.notification.body | 成功 | プロジェクトが正常に復元されました | 復元成功時 |
| delete.notification.title | 成功 | プロジェクトが削除されました | 削除成功時 |
| delete.notification.body | 成功 | プロジェクトが正常に削除されました | 削除成功時 |
| force-delete.notification.success.title | 成功 | プロジェクトが完全に削除されました | 完全削除成功時 |
| force-delete.notification.success.body | 成功 | プロジェクトが完全に削除されました | 完全削除成功時 |
| force-delete.notification.error.title | エラー | プロジェクトを削除できません | 完全削除失敗時 |
| force-delete.notification.error.body | エラー | 関連データがあるため削除できません | 完全削除失敗時 |

## 例外処理

| 例外種別 | 発生条件 | 対応処理 |
|---------|---------|---------|
| QueryException | 完全削除時に外部キー制約違反が発生した場合 | エラー通知を表示し、削除処理を中断 |
| AuthorizationException | アクセス権限がない場合 | 403エラーページを表示 |

## 備考

- HasTableViewsトレイトを使用し、プリセットビュー（タブ）機能を実現
- プリセットビューの定義：
  - マイプロジェクト：user_id = Auth::id()
  - お気に入り：projects_user_project_favoritesテーブルでuser_id = Auth::id()
  - 未割当：user_id IS NULL
  - アーカイブ：onlyTrashed()（ソフトデリート済み）
- グリッドレイアウトはレスポンシブ対応（sm=1, md=2, xl=3, 2xl=4列）
- フィルタはQueryBuilderを使用し、モーダル・スライドオーバー形式で表示
- カスタムフィールド機能（HasCustomFields）をサポート
- マイルストーン表示はTaskSettings::enable_milestonesに依存
- タイムシート関連表示はTimeSettings::enable_timesheetsに依存
