# 画面設計書 234-プロジェクト作成

## 概要

本ドキュメントは、新規プロジェクトを作成するための画面設計書です。プロジェクトの基本情報、追加情報、設定（可視性、タイムシート、マイルストーン）を入力し、プロジェクトを登録します。

### 本画面の処理概要

**業務上の目的・背景**：プロジェクト管理において、新規プロジェクトの登録は業務開始の起点となります。本画面では、プロジェクトの名称、担当者、顧客、期間、リソース配分（時間）、可視性等の基本情報を設定し、タスク管理やマイルストーン管理の基盤を構築します。適切なプロジェクト設定により、チーム間のコラボレーションや進捗管理を効率化します。

**画面へのアクセス方法**：プロジェクト一覧画面（ListProjects）の「作成」ボタンをクリック、またはナビゲーションから直接アクセスできます。

**主要な操作・処理内容**：
1. プロジェクト基本情報の入力（名称、説明）
2. プロジェクトステージの選択（ステッパー形式）
3. 追加情報の入力（担当者、顧客、期間、時間、タグ、会社）
4. 設定の構成（可視性、タイムシート許可、マイルストーン許可）
5. プロジェクトの保存

**画面遷移**：
- 遷移元：プロジェクト一覧画面（ListProjects）
- 遷移先：プロジェクト詳細画面（ViewProject）- 作成成功後

**権限による表示制御**：プロジェクトリソースに対する「create」権限を持つユーザーのみがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PROJ-002 | プロジェクト作成 | 主機能 | 新規プロジェクトの登録 |
| FN-PROJ-001 | プロジェクト一覧 | 遷移元機能 | 一覧からの遷移元 |
| FN-PROJ-004 | プロジェクト表示 | 遷移先機能 | 作成成功後の遷移先 |

## 画面種別

作成

## URL/ルーティング

`/admin/project/projects/create`

## 画面構成

- メインコンテンツ領域（3カラムレイアウト）
  - 左側（2カラム分）
    - プロジェクトステージセレクター（ProgressStepper）
    - 一般情報セクション
    - 追加情報セクション
  - 右側（1カラム分）
    - 設定セクション

## 入出力項目

### 一般情報セクション

| 項目名 | 項目ID | 入力種別 | 必須 | 最大長 | 初期値 | 説明 |
|--------|--------|----------|------|--------|--------|------|
| プロジェクト名 | name | テキスト | ○ | 255 | - | プロジェクトの名称 |
| 説明 | description | リッチエディタ | - | - | - | プロジェクトの詳細説明 |

### プロジェクトステージ

| 項目名 | 項目ID | 入力種別 | 必須 | 初期値 | 表示条件 | 説明 |
|--------|--------|----------|------|--------|----------|------|
| ステージ | stage_id | ProgressStepper | ○ | 最初のステージ | TaskSettings.enable_project_stages=true | プロジェクトの進行ステージ |

### 追加情報セクション

| 項目名 | 項目ID | 入力種別 | 必須 | 説明 |
|--------|--------|----------|------|------|
| プロジェクトマネージャー | user_id | セレクト | - | プロジェクト担当者（新規作成可） |
| 顧客 | partner_id | セレクト | - | 関連顧客（新規作成・編集可） |
| 開始日 | start_date | 日付選択 | 条件付き | 終了日設定時は必須 |
| 終了日 | end_date | 日付選択 | 条件付き | 開始日設定時は必須、開始日以降 |
| 割当時間 | allocated_hours | 数値 | - | リソース配分時間（0以上、タイムシート有効時のみ表示） |
| タグ | tags | マルチセレクト | - | プロジェクトタグ（複数選択可、新規作成可） |
| 会社 | company_id | セレクト | - | 所属会社（新規作成可） |

### 設定セクション

| 項目名 | 項目ID | 入力種別 | 必須 | 初期値 | 説明 |
|--------|--------|----------|------|--------|------|
| 可視性 | visibility | ラジオボタン | ○ | internal | private/internal/publicの選択 |
| タイムシート許可 | allow_timesheets | トグル | - | enable_timesheets設定値 | タイムシート機能の有効化（タイムシート有効時のみ表示） |
| マイルストーン許可 | allow_milestones | トグル | - | enable_milestones設定値 | マイルストーン機能の有効化（マイルストーン有効時のみ表示） |

## 表示項目

本画面は作成画面のため、表示専用項目はありません。

## イベント仕様

### 01-保存ボタン押下

フォームの保存ボタンをクリックすると、入力内容のバリデーションを実施し、プロジェクトを作成します。作成前にcreator_idが現在のログインユーザーIDに自動設定されます。作成成功後、プロジェクト詳細画面（ViewProject）へリダイレクトします。

### 02-キャンセルボタン押下

キャンセルボタンをクリックすると、プロジェクト一覧画面へ戻ります。

### 03-プロジェクトマネージャー新規作成

セレクトボックスから「新規作成」を選択すると、ユーザー作成フォームがモーダル表示されます。

### 04-顧客新規作成・編集

セレクトボックスから「新規作成」または「編集」を選択すると、パートナー作成/編集フォームがモーダル表示されます。

### 05-タグ新規作成

セレクトボックスから「新規作成」を選択すると、タグ作成フォームがモーダル表示されます。

### 06-会社新規作成

セレクトボックスから「新規作成」を選択すると、会社作成フォームがモーダル表示されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | projects_projects | INSERT | 新規プロジェクトの登録 |
| 保存ボタン押下 | projects_project_tag | INSERT | プロジェクトとタグの関連付け |

### テーブル別更新項目詳細

#### projects_projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | description | フォーム入力値 | 任意 |
| INSERT | stage_id | フォーム選択値 | 必須（ステージ有効時） |
| INSERT | user_id | フォーム選択値 | 任意 |
| INSERT | partner_id | フォーム選択値 | 任意 |
| INSERT | start_date | フォーム入力値 | 任意 |
| INSERT | end_date | フォーム入力値 | 任意 |
| INSERT | allocated_hours | フォーム入力値 | 任意 |
| INSERT | company_id | フォーム選択値 | 任意 |
| INSERT | visibility | フォーム選択値 | デフォルト: internal |
| INSERT | allow_timesheets | フォーム入力値 | 任意 |
| INSERT | allow_milestones | フォーム入力値 | 任意 |
| INSERT | creator_id | Auth::id() | 自動設定 |

#### projects_project_tag

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | project_id | 作成されたプロジェクトID | - |
| INSERT | tag_id | 選択されたタグID | タグ数分レコード作成 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| notification.title | 成功 | プロジェクトが作成されました | 作成成功時 |
| notification.body | 成功 | プロジェクトが正常に作成されました | 作成成功時 |

## 例外処理

| 例外種別 | 発生条件 | 対応処理 |
|---------|---------|---------|
| ValidationException | 必須項目未入力、日付バリデーションエラー | フォームにエラーメッセージを表示 |
| AuthorizationException | create権限がない場合 | 403エラーページを表示 |

## 備考

- ProgressStepperコンポーネントを使用し、ステージ選択をビジュアル化
- 可視性の説明：
  - private：招待されたポータルユーザーおよびすべての内部ユーザーのみ
  - internal：すべての内部ユーザーのみ（デフォルト）
  - public：すべてのユーザー
- 開始日・終了日は相互依存（一方を設定すると他方も必須）
- 開始日は終了日より前である必要がある（beforeOrEqualバリデーション）
- 終了日は開始日より後である必要がある（afterOrEqualバリデーション）
- 割当時間フィールドはTimeSettings.enable_timesheets=trueの場合のみ表示
- マイルストーン許可トグルはTaskSettings.enable_milestones=trueの場合のみ表示
- タイムシート許可トグルはTimeSettings.enable_timesheets=trueの場合のみ表示
- HasCustomFieldsトレイトにより、追加情報セクションにカスタムフィールドを追加可能
