# 画面設計書 235-プロジェクト編集

## 概要

本ドキュメントは、既存プロジェクトの情報を編集するための画面設計書です。プロジェクトの基本情報、追加情報、設定を更新し、また削除やチャッター機能によるコミュニケーションを行います。

### 本画面の処理概要

**業務上の目的・背景**：プロジェクト運営において、プロジェクト情報の更新は日常的な業務です。本画面では、プロジェクトの進捗に応じたステージ更新、担当者変更、期間延長、設定変更等を行います。また、チャッター機能により、プロジェクト関係者間のコミュニケーション（コメント、ログ、アクティビティ）を記録・管理します。

**画面へのアクセス方法**：プロジェクト一覧画面または詳細画面の「編集」ボタン/アクションをクリック、またはサブナビゲーションの「編集」タブからアクセスできます。

**主要な操作・処理内容**：
1. プロジェクト基本情報の更新（名称、説明）
2. プロジェクトステージの変更
3. 追加情報の更新（担当者、顧客、期間、時間、タグ、会社）
4. 設定の変更（可視性、タイムシート許可、マイルストーン許可）
5. チャッターによるコミュニケーション
6. プロジェクトの削除

**画面遷移**：
- 遷移元：プロジェクト一覧画面、プロジェクト詳細画面
- 遷移先：プロジェクト詳細画面（保存成功後）、プロジェクト一覧画面（削除成功後）
- サブナビゲーション：詳細、編集、タスク、マイルストーン

**権限による表示制御**：プロジェクトリソースに対する「update」権限を持つユーザーのみがアクセス可能です。削除アクションは「delete」権限保持者にのみ表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PROJ-003 | プロジェクト編集 | 主機能 | プロジェクト情報の更新 |
| FN-PROJ-001 | プロジェクト一覧 | 遷移元機能 | 一覧からの遷移元 |
| FN-PROJ-004 | プロジェクト表示 | 遷移元/先機能 | 詳細からの遷移元、保存後の遷移先 |
| FN-CHT-001 | チャッター | 補助機能 | コミュニケーション機能 |

## 画面種別

編集

## URL/ルーティング

`/admin/project/projects/{record}/edit`

## 画面構成

- ヘッダーアクション領域
  - チャッターボタン（ChatterAction）
  - 削除ボタン（DeleteAction）
- サブナビゲーション（上部）
  - ViewProject, EditProject, ManageTasks, ManageMilestones
- メインコンテンツ領域（3カラムレイアウト）
  - 左側（2カラム分）
    - プロジェクトステージセレクター（ProgressStepper）
    - 一般情報セクション
    - 追加情報セクション
  - 右側（1カラム分）
    - 設定セクション

## 入出力項目

### 一般情報セクション

| 項目名 | 項目ID | 入力種別 | 必須 | 最大長 | 説明 |
|--------|--------|----------|------|--------|------|
| プロジェクト名 | name | テキスト | ○ | 255 | プロジェクトの名称 |
| 説明 | description | リッチエディタ | - | - | プロジェクトの詳細説明 |

### プロジェクトステージ

| 項目名 | 項目ID | 入力種別 | 必須 | 表示条件 | 説明 |
|--------|--------|----------|------|----------|------|
| ステージ | stage_id | ProgressStepper | ○ | TaskSettings.enable_project_stages=true | プロジェクトの進行ステージ |

### 追加情報セクション

| 項目名 | 項目ID | 入力種別 | 必須 | 説明 |
|--------|--------|----------|------|------|
| プロジェクトマネージャー | user_id | セレクト | - | プロジェクト担当者（新規作成可） |
| 顧客 | partner_id | セレクト | - | 関連顧客（新規作成・編集可） |
| 開始日 | start_date | 日付選択 | 条件付き | 終了日設定時は必須 |
| 終了日 | end_date | 日付選択 | 条件付き | 開始日設定時は必須、開始日以降 |
| 割当時間 | allocated_hours | 数値 | - | リソース配分時間（0以上、タイムシート有効時のみ表示） |
| タグ | tags | マルチセレクト | - | プロジェクトタグ（複数選択可、新規作成可） |
| 会社 | company_id | セレクト | - | 所属会社（新規作成可） |

### 設定セクション

| 項目名 | 項目ID | 入力種別 | 必須 | 説明 |
|--------|--------|----------|------|------|
| 可視性 | visibility | ラジオボタン | ○ | private/internal/publicの選択 |
| タイムシート許可 | allow_timesheets | トグル | - | タイムシート機能の有効化（タイムシート有効時のみ表示） |
| マイルストーン許可 | allow_milestones | トグル | - | マイルストーン機能の有効化（マイルストーン有効時のみ表示） |

## 表示項目

本画面は編集画面のため、入力項目以外の表示専用項目はありません。

## イベント仕様

### 01-保存ボタン押下

フォームの保存ボタンをクリックすると、入力内容のバリデーションを実施し、プロジェクト情報を更新します。更新成功後、プロジェクト詳細画面（ViewProject）へリダイレクトし、成功通知が表示されます。

### 02-チャッターボタン押下

ヘッダーのチャッターボタンをクリックすると、チャッターサイドパネルが表示されます。コメント、ログ、アクティビティの記録・閲覧が可能です。アクティビティプランはprojectsプラグインのプランが利用可能です。

### 03-削除ボタン押下

ヘッダーの削除ボタンをクリックすると、確認ダイアログが表示されます。確認後、プロジェクトをソフトデリートし、成功通知を表示してプロジェクト一覧へリダイレクトします。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | projects_projects | UPDATE | プロジェクト情報の更新 |
| 保存ボタン押下 | projects_project_tag | DELETE/INSERT | タグ関連付けの更新（sync） |
| 削除ボタン押下 | projects_projects | UPDATE | ソフトデリート（deleted_at設定） |
| チャッター操作 | chatter_messages | INSERT | コメント・ログの追加 |
| チャッター操作 | chatter_activities | INSERT/UPDATE | アクティビティの管理 |

### テーブル別更新項目詳細

#### projects_projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | name | フォーム入力値 | 必須 |
| UPDATE | description | フォーム入力値 | 任意 |
| UPDATE | stage_id | フォーム選択値 | 必須（ステージ有効時） |
| UPDATE | user_id | フォーム選択値 | 任意 |
| UPDATE | partner_id | フォーム選択値 | 任意 |
| UPDATE | start_date | フォーム入力値 | 任意 |
| UPDATE | end_date | フォーム入力値 | 任意 |
| UPDATE | allocated_hours | フォーム入力値 | 任意 |
| UPDATE | company_id | フォーム選択値 | 任意 |
| UPDATE | visibility | フォーム選択値 | 必須 |
| UPDATE | allow_timesheets | フォーム入力値 | 任意 |
| UPDATE | allow_milestones | フォーム入力値 | 任意 |
| UPDATE | deleted_at | 現在日時 | 削除時のみ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| notification.title | 成功 | プロジェクトが更新されました | 更新成功時 |
| notification.body | 成功 | プロジェクトが正常に更新されました | 更新成功時 |
| header-actions.delete.notification.title | 成功 | プロジェクトが削除されました | 削除成功時 |
| header-actions.delete.notification.body | 成功 | プロジェクトが正常に削除されました | 削除成功時 |

## 例外処理

| 例外種別 | 発生条件 | 対応処理 |
|---------|---------|---------|
| ValidationException | 必須項目未入力、日付バリデーションエラー | フォームにエラーメッセージを表示 |
| ModelNotFoundException | 指定されたプロジェクトが存在しない場合 | 404エラーページを表示 |
| AuthorizationException | update権限がない場合 | 403エラーページを表示 |

## 備考

- サブナビゲーションはSubNavigationPosition::Topで上部に配置
- チャッター機能はChatterActionを使用し、リソースとアクティビティプランを設定
- アクティビティプランはActivityPlanモデルでplugin='projects'のものを取得
- フォーム構成は作成画面（CreateProject）と同一のProjectResource::formを使用
- HasCustomFieldsトレイトにより、追加情報セクションにカスタムフィールドが表示される
