# 画面設計書 236-プロジェクト詳細

## 概要

本ドキュメントは、プロジェクトの詳細情報を表示する画面の設計書です。プロジェクトの基本情報、追加情報、統計情報、設定情報を表示し、チャッター機能によるコミュニケーションや削除操作を行います。

### 本画面の処理概要

**業務上の目的・背景**：プロジェクト詳細画面は、プロジェクトの全体像を把握するための中心的な画面です。プロジェクト名、担当者、顧客、期間、進捗状況（タスク数、マイルストーン進捗）、時間管理情報（割当時間、残時間）を一覧表示し、プロジェクトマネージャーや関係者が迅速に状況を把握できるようにします。

**画面へのアクセス方法**：プロジェクト一覧画面のカードをクリック、または編集画面・タスク管理画面等のサブナビゲーションからアクセスできます。

**主要な操作・処理内容**：
1. プロジェクト詳細情報の閲覧
2. タスク数・マイルストーン進捗の確認
3. 時間管理情報（割当時間、残時間）の確認
4. チャッターによるコミュニケーション
5. プロジェクトの削除
6. サブナビゲーションによる関連画面への遷移

**画面遷移**：
- 遷移元：プロジェクト一覧画面、プロジェクト作成画面、プロジェクト編集画面
- 遷移先：プロジェクト編集画面、タスク管理画面、マイルストーン管理画面
- サブナビゲーション：詳細、編集、タスク、マイルストーン

**権限による表示制御**：プロジェクトリソースに対する「view」権限を持つユーザーのみがアクセス可能です。削除アクションは「delete」権限保持者にのみ表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PROJ-004 | プロジェクト表示 | 主機能 | プロジェクト詳細情報の表示 |
| FN-PROJ-003 | プロジェクト編集 | 遷移先機能 | 編集画面への遷移 |
| FN-PROJ-005 | タスク管理 | 遷移先機能 | タスク管理画面への遷移 |
| FN-PROJ-006 | マイルストーン管理 | 遷移先機能 | マイルストーン管理画面への遷移 |
| FN-CHT-001 | チャッター | 補助機能 | コミュニケーション機能 |

## 画面種別

詳細

## URL/ルーティング

`/admin/project/projects/{record}`

## 画面構成

- ヘッダーアクション領域
  - チャッターボタン（ChatterAction）
  - 削除ボタン（DeleteAction）
- サブナビゲーション（上部）
  - ViewProject, EditProject, ManageTasks, ManageMilestones
- メインコンテンツ領域（3カラムレイアウト）
  - 左側（2カラム分）
    - 一般情報セクション
    - 追加情報セクション
    - 統計情報セクション
  - 右側（1カラム分）
    - レコード情報セクション
    - 設定セクション

## 入出力項目

本画面は詳細表示画面のため、入力項目はありません。

## 表示項目

### 一般情報セクション

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| プロジェクト名（name） | テキスト（大サイズ・太字） | プロジェクトの名称 |
| 説明（description） | マークダウン | プロジェクトの詳細説明 |

### 追加情報セクション（2カラムグリッド）

| 項目名 | 表示形式 | 表示条件 | 説明 |
|--------|----------|----------|------|
| プロジェクトマネージャー（user.name） | テキスト（アイコン付き） | 常時 | 担当者名。未設定時は「—」 |
| 顧客（partner.name） | テキスト（アイコン付き） | 常時 | 関連顧客名。未設定時は「—」 |
| プロジェクト期間（planned_date） | テキスト（アイコン付き） | 常時 | 「開始日 - 終了日」形式。未設定時は「—」 |
| 割当時間（allocated_hours） | テキスト（アイコン付き）+サフィックス | タイムシート有効時 | 割り当てられた時間 |
| 残時間（remaining_hours） | テキスト（アイコン付き）+サフィックス | タイムシート有効時 | 残り時間（負値は赤表示） |
| 現在ステージ（stage.name） | バッジ（アイコン付き） | ステージ有効時 | 現在のプロジェクトステージ |
| タグ（tags.name） | バッジ（複数、色付き） | 常時 | プロジェクトタグ |

### 統計情報セクション（2カラムグリッド）

| 項目名 | 表示形式 | 表示条件 | 説明 |
|--------|----------|----------|------|
| タスク数（tasks_count） | テキスト（アイコン付き）+リンク | 常時 | プロジェクトのタスク総数。タスク管理画面へリンク |
| マイルストーン進捗（milestones_completion） | テキスト（アイコン付き）+リンク | マイルストーン有効時 | 「完了数/全数」形式。マイルストーン管理画面へリンク |

### レコード情報セクション

| 項目名 | 表示形式 | 説明 |
|--------|----------|------|
| 作成日時（created_at） | 日時（アイコン付き） | プロジェクトの作成日時 |
| 作成者（creator.name） | テキスト（アイコン付き） | プロジェクトを作成したユーザー名 |
| 更新日時（updated_at） | 日時（アイコン付き） | プロジェクトの最終更新日時 |

### 設定セクション

| 項目名 | 表示形式 | 表示条件 | 説明 |
|--------|----------|----------|------|
| 可視性（visibility） | バッジ（アイコン・色付き） | 常時 | private/internal/public |
| タイムシート有効（allow_timesheets） | アイコン（○/×） | タイムシート有効時 | タイムシート機能の有効状態 |
| マイルストーン有効（allow_milestones） | アイコン（○/×） | マイルストーン有効時 | マイルストーン機能の有効状態 |

## イベント仕様

### 01-チャッターボタン押下

ヘッダーのチャッターボタンをクリックすると、チャッターサイドパネルが表示されます。コメント、ログ、アクティビティの記録・閲覧が可能です。

### 02-削除ボタン押下

ヘッダーの削除ボタンをクリックすると、確認ダイアログが表示されます。確認後、プロジェクトをソフトデリートし、成功通知を表示してプロジェクト一覧へリダイレクトします。

### 03-タスク数リンク押下

タスク数の表示部分をクリックすると、該当プロジェクトのタスク管理画面（ManageTasks）へ遷移します。

### 04-マイルストーン進捗リンク押下

マイルストーン進捗の表示部分をクリックすると、該当プロジェクトのマイルストーン管理画面（ManageMilestones）へ遷移します。

### 05-サブナビゲーション操作

サブナビゲーションのタブをクリックすると、対応する画面（編集、タスク管理、マイルストーン管理）へ遷移します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除ボタン押下 | projects_projects | UPDATE | ソフトデリート（deleted_at設定） |
| チャッター操作 | chatter_messages | INSERT | コメント・ログの追加 |
| チャッター操作 | chatter_activities | INSERT/UPDATE | アクティビティの管理 |

### テーブル別更新項目詳細

#### projects_projects

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | deleted_at | 現在日時 | 削除時のみ |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| header-actions.delete.notification.title | 成功 | プロジェクトが削除されました | 削除成功時 |
| header-actions.delete.notification.body | 成功 | プロジェクトが正常に削除されました | 削除成功時 |

## 例外処理

| 例外種別 | 発生条件 | 対応処理 |
|---------|---------|---------|
| ModelNotFoundException | 指定されたプロジェクトが存在しない場合 | 404エラーページを表示 |
| AuthorizationException | view権限がない場合 | 403エラーページを表示 |

## 備考

- サブナビゲーションはSubNavigationPosition::Topで上部に配置
- 可視性の表示：
  - private：ロックアイコン、グレー
  - internal：ユーザーグループアイコン、ブルー
  - public：地球アイコン、グリーン
- 残時間（remaining_hours）は負値の場合dangerカラー、正値の場合successカラーで表示
- タスク数・マイルストーン進捗はクリック可能なリンクとして実装
- HasCustomFieldsトレイトにより、追加情報セクションにカスタムフィールドが表示される
- infolistはProjectResource::infolistを使用
