# 画面設計書 237-マイルストーン管理

## 概要

本ドキュメントは、プロジェクトに紐づくマイルストーンを管理するManageRelatedRecordsタイプの画面設計書です。プロジェクトの重要な節目（マイルストーン）の登録・編集・削除・完了管理を行います。

### 本画面の処理概要

**業務上の目的・背景**：マイルストーンは、プロジェクトの重要な節目や達成目標を表します。本画面では、プロジェクトの進捗管理において、目標日程の設定、達成状況の追跡、完了管理を行います。マイルストーン管理により、プロジェクトの進捗を可視化し、計画的な業務遂行を支援します。

**画面へのアクセス方法**：プロジェクト一覧画面のマイルストーンボタン、またはプロジェクト詳細・編集画面のサブナビゲーションからアクセスできます。マイルストーン機能が有効（TaskSettings.enable_milestones=true）かつ、プロジェクトでマイルストーンが許可（allow_milestones=true）されている場合のみアクセス可能です。

**主要な操作・処理内容**：
1. マイルストーン一覧の表示
2. 新規マイルストーンの作成
3. マイルストーン情報の編集
4. マイルストーンの完了トグル
5. マイルストーンの削除（単体・一括）

**画面遷移**：
- 遷移元：プロジェクト一覧画面、プロジェクト詳細画面
- サブナビゲーション：詳細、編集、タスク、マイルストーン

**権限による表示制御**：親リソース（ProjectResource）のアクセス権限と、マイルストーン設定の有効状態、およびプロジェクトのallow_milestones設定に基づいてアクセスが制御されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PROJ-006 | マイルストーン管理 | 主機能 | マイルストーンのCRUD操作 |
| FN-PROJ-004 | プロジェクト表示 | 関連機能 | プロジェクト詳細からの遷移 |
| FN-PROJ-001 | プロジェクト一覧 | 関連機能 | プロジェクト一覧からの遷移 |

## 画面種別

管理（ManageRelatedRecords）

## URL/ルーティング

`/admin/project/projects/{record}/milestones`

## 画面構成

- サブナビゲーション（上部）
  - ViewProject, EditProject, ManageTasks, ManageMilestones
- ヘッダー領域
  - ナビゲーションラベル（フラグアイコン付き）
  - 作成ボタン（CreateAction）
- テーブル領域
  - データテーブル（フィルタ、ソート、グループ化対応）
  - 行アクション（編集・削除）
  - 一括アクション（削除）

## 入出力項目

### 作成・編集フォーム

| 項目名 | 項目ID | 入力種別 | 必須 | 最大長 | 説明 |
|--------|--------|----------|------|--------|------|
| マイルストーン名 | name | テキスト | ○ | 255 | マイルストーンの名称 |
| 期日 | deadline | 日時選択 | - | - | マイルストーンの目標日時 |
| 完了 | is_completed | トグル | ○ | - | 完了状態 |

※ project_idはManageMilestones画面では非表示（親プロジェクトから自動設定）

## 表示項目

### テーブル列

| 項目名 | 表示形式 | ソート | 検索 | 説明 |
|--------|----------|--------|------|------|
| マイルストーン名（name） | テキスト | ○ | ○ | マイルストーンの名称 |
| 期日（deadline） | 日時 | ○ | - | 目標日時 |
| 完了（is_completed） | トグル | ○ | - | 完了状態（インライン切替可） |
| 完了日時（completed_at） | 日時 | ○ | - | 完了処理を行った日時 |
| 作成者（creator.name） | テキスト | ○ | - | マイルストーンを作成したユーザー |
| 作成日時（created_at） | 日時 | ○ | - | 作成日時（初期非表示） |
| 更新日時（updated_at） | 日時 | ○ | - | 更新日時（初期非表示） |

※ project.nameはManageMilestones画面では非表示（プロジェクトコンテキスト内のため）

## イベント仕様

### 01-作成ボタン押下

ヘッダーの作成ボタンをクリックすると、マイルストーン作成モーダルが表示されます。creator_idは現在のログインユーザーIDが自動設定されます。作成成功時に成功通知が表示されます。

### 02-編集アクション押下

行の編集アクションをクリックすると、編集モーダルが表示されます。更新成功時に成功通知が表示されます。

### 03-完了トグル切替

テーブル上のis_completedトグルを切り替えると、完了状態が即座に更新されます。完了時はcompleted_atに現在日時が、未完了時はnullが設定されます。

### 04-削除アクション押下

行の削除アクションをクリックすると、確認ダイアログが表示されます。確認後、マイルストーンを削除します。

### 05-一括削除アクション押下

選択した複数レコードを一括削除します。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 作成ボタン押下 | projects_milestones | INSERT | 新規マイルストーンの登録 |
| 編集アクション押下 | projects_milestones | UPDATE | マイルストーン情報の更新 |
| 完了トグル切替 | projects_milestones | UPDATE | 完了状態・完了日時の更新 |
| 削除アクション押下 | projects_milestones | DELETE | マイルストーンの削除 |
| 一括削除アクション押下 | projects_milestones | DELETE | 複数マイルストーンの削除 |

### テーブル別更新項目詳細

#### projects_milestones

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | deadline | フォーム入力値 | 任意 |
| INSERT | is_completed | フォーム入力値 | デフォルト: false |
| INSERT | project_id | 親プロジェクトID | 自動設定 |
| INSERT | creator_id | Auth::id() | 自動設定 |
| UPDATE | is_completed | トグル値 | トグル切替時 |
| UPDATE | completed_at | now() / null | is_completedの状態に応じて |
| DELETE | - | WHERE id = {record_id} | - |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| header-actions.create.notification.title | 成功 | マイルストーンが作成されました | 作成成功時 |
| header-actions.create.notification.body | 成功 | マイルストーンが正常に作成されました | 作成成功時 |
| actions.edit.notification.title | 成功 | マイルストーンが更新されました | 編集成功時 |
| actions.edit.notification.body | 成功 | マイルストーンが正常に更新されました | 編集成功時 |
| actions.delete.notification.title | 成功 | マイルストーンが削除されました | 削除成功時 |
| actions.delete.notification.body | 成功 | マイルストーンが正常に削除されました | 削除成功時 |
| bulk-actions.delete.notification.title | 成功 | マイルストーンが一括削除されました | 一括削除成功時 |
| bulk-actions.delete.notification.body | 成功 | マイルストーンが正常に一括削除されました | 一括削除成功時 |

## 例外処理

| 例外種別 | 発生条件 | 対応処理 |
|---------|---------|---------|
| ValidationException | 必須項目未入力 | フォームにエラーメッセージを表示 |
| AuthorizationException | アクセス権限がない場合 | 403エラーページを表示またはナビゲーション非表示 |
| AccessDeniedException | マイルストーン機能が無効な場合 | ナビゲーションから除外 |

## 備考

- ManageRelatedRecordsクラスを継承し、Projectモデルのmilestonesリレーションを管理
- ナビゲーションアイコンはheroicon-o-flag
- canAccess条件：
  1. 親クラスのcanAccessがtrue
  2. TaskSettings::enable_milestonesがtrue
  3. 対象プロジェクトのallow_milestonesがtrue
- フォームとテーブルの定義はMilestoneResourceを再利用
- 完了トグル切替時、beforeStateUpdatedでcompleted_atを自動更新
- グループ化機能でプロジェクト別、完了状態別、作成日別の表示が可能
- フィルタ：完了状態（三値）、作成者
