# 画面設計書 238-タスク管理

## 概要

本ドキュメントは、プロジェクトに紐づくタスクを管理するManageRelatedRecordsタイプの画面設計書です。プロジェクト内のタスクの一覧表示、詳細確認、編集、削除、復元等の操作を行います。

### 本画面の処理概要

**業務上の目的・背景**：タスク管理は、プロジェクトの作業単位を管理するための中核機能です。本画面では、プロジェクトに紐づくタスクの一覧を表示し、プリセットビュー（タブ）による状態別絞り込み、タスクの状態管理、担当者割当等を行います。プロジェクトコンテキスト内でのタスク管理により、プロジェクト単位での進捗把握を支援します。

**画面へのアクセス方法**：プロジェクト一覧画面のタスクボタン、またはプロジェクト詳細・編集画面のサブナビゲーションからアクセスできます。

**主要な操作・処理内容**：
1. プロジェクト内タスク一覧の表示
2. プリセットビュー（オープンタスク、マイタスク、未割当、クローズド、スター付き、アーカイブ）による絞り込み
3. 新規タスク作成画面への遷移
4. タスク詳細画面・編集画面への遷移
5. タスクの削除・復元・完全削除

**画面遷移**：
- 遷移元：プロジェクト一覧画面、プロジェクト詳細画面
- 遷移先：タスク作成画面、タスク詳細画面、タスク編集画面
- サブナビゲーション：詳細、編集、タスク、マイルストーン

**権限による表示制御**：親リソース（ProjectResource）のアクセス権限に基づいてアクセスが制御されます。削除・復元・完全削除は各操作権限保持者にのみ表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PROJ-005 | タスク管理 | 主機能 | プロジェクト内タスクの管理 |
| FN-PROJ-004 | プロジェクト表示 | 関連機能 | プロジェクト詳細からの遷移 |
| FN-TASK-002 | タスク作成 | 遷移先機能 | タスク作成画面への遷移 |
| FN-TASK-004 | タスク表示 | 遷移先機能 | タスク詳細画面への遷移 |
| FN-TASK-003 | タスク編集 | 遷移先機能 | タスク編集画面への遷移 |

## 画面種別

管理（ManageRelatedRecords）

## URL/ルーティング

`/admin/project/projects/{record}/tasks`

## 画面構成

- サブナビゲーション（上部）
  - ViewProject, EditProject, ManageTasks, ManageMilestones
- ヘッダー領域
  - ナビゲーションラベル
  - 作成ボタン（CreateAction）→ タスク作成画面へ遷移
- プリセットビュー（タブ）領域
  - オープンタスク、マイタスク、未割当タスク、クローズドタスク、スター付きタスク、アーカイブ済みタスク
- テーブル領域
  - データテーブル（フィルタ、ソート、グループ化対応）
  - 行アクション（表示・編集・復元・削除・完全削除）

## 入出力項目

本画面は関連レコード管理画面のため、タスクの作成・編集はTaskResourceの画面で行います。

## 表示項目

### テーブル列

| 項目名 | 表示形式 | ソート | 検索 | 説明 |
|--------|----------|--------|------|------|
| ID | テキスト | ○ | ○ | タスクID（初期非表示） |
| 優先度（priority） | アイコン | - | - | スターアイコン（高優先度=塗りつぶし） |
| 状態（state） | アイコン | ○ | - | タスク状態アイコン（色付き、ツールチップ付き） |
| タイトル（title） | テキスト | ○ | ○ | タスクのタイトル |
| マイルストーン（milestone.name） | テキスト | ○ | ○ | 関連マイルストーン（初期非表示） |
| 顧客（partner.name） | テキスト | ○ | ○ | 関連顧客（初期非表示） |
| 担当者（users.name） | テキスト | ○ | ○ | 割当ユーザー（複数） |
| 割当時間（allocated_hours） | 数値 | ○ | - | 割り当てられた時間（初期非表示） |
| 費やした時間（total_hours_spent） | 数値 | ○ | - | 実績時間 |
| 残時間（remaining_hours） | 数値 | ○ | - | 残り時間（初期非表示） |
| 進捗（progress） | プログレスバー | ○ | - | 進捗率（色分け表示） |
| 期日（deadline） | 日時 | ○ | - | タスクの期日 |
| タグ（tags.name） | バッジ | - | - | タスクタグ（色付き） |
| ステージ（stage.name） | テキスト | ○ | - | タスクステージ |

※ project.nameはManageTasks画面では非表示（プロジェクトコンテキスト内のため）

## イベント仕様

### 01-作成ボタン押下

ヘッダーの作成ボタンをクリックすると、タスク作成画面（TaskResource::create）へ遷移します。

### 02-表示アクション押下

行の表示アクションをクリックすると、タスク詳細画面（TaskResource::view）へ遷移します。削除済みタスクでは非表示です。

### 03-編集アクション押下

行の編集アクションをクリックすると、タスク編集画面（TaskResource::edit）へ遷移します。削除済みタスクでは非表示です。

### 04-削除アクション押下

行の削除アクションをクリックすると、確認ダイアログが表示されます。確認後、タスクをソフトデリートします。

### 05-復元アクション押下

行の復元アクションをクリックすると、ソフトデリートされたタスクを復元します。

### 06-完全削除アクション押下

行の完全削除アクションをクリックすると、タスクを物理削除します。

### 07-プリセットビュー切替

プリセットビュー（タブ）をクリックすると、対応するフィルタ条件でタスク一覧が絞り込まれます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 削除アクション押下 | projects_tasks | UPDATE | ソフトデリート（deleted_at設定） |
| 復元アクション押下 | projects_tasks | UPDATE | deleted_atのクリア |
| 完全削除アクション押下 | projects_tasks | DELETE | レコードの物理削除 |

### テーブル別更新項目詳細

#### projects_tasks

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | deleted_at | 現在日時 | 削除時 |
| UPDATE | deleted_at | NULL | 復元時 |
| DELETE | - | WHERE id = {record_id} | 完全削除時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| actions.restore.notification.title | 成功 | タスクが復元されました | 復元成功時 |
| actions.restore.notification.body | 成功 | タスクが正常に復元されました | 復元成功時 |
| actions.delete.notification.title | 成功 | タスクが削除されました | 削除成功時 |
| actions.delete.notification.body | 成功 | タスクが正常に削除されました | 削除成功時 |
| actions.force-delete.notification.title | 成功 | タスクが完全に削除されました | 完全削除成功時 |
| actions.force-delete.notification.body | 成功 | タスクが完全に削除されました | 完全削除成功時 |

## 例外処理

| 例外種別 | 発生条件 | 対応処理 |
|---------|---------|---------|
| AuthorizationException | アクセス権限がない場合 | 403エラーページを表示 |
| ModelNotFoundException | 対象タスクが存在しない場合 | 404エラーページを表示 |

## 備考

- ManageRelatedRecordsクラスを継承し、Projectモデルのtasksリレーションを管理
- ナビゲーションアイコンはheroicon-o-clipboard-document-list
- HasTableViewsトレイトを使用し、プリセットビュー（タブ）機能を実現
- プリセットビューの定義：
  - オープンタスク：state NOT IN (CANCELLED, DONE)
  - マイタスク：usersリレーションでuser_id = Auth::id()
  - 未割当タスク：usersリレーションが空
  - クローズドタスク：state IN (CANCELLED, DONE)
  - スター付きタスク：priority = true
  - アーカイブ済み：onlyTrashed()
- クエリはparent_id IS NULLでフィルタ（親タスクのみ表示、サブタスクは除外）
- テーブル定義はTaskResourceを再利用
- infolist定義もTaskResourceを再利用
- 時間関連列はTimeSettings.enable_timesheets=trueの場合のみ表示
- マイルストーン列はTaskSettings.enable_milestones=trueの場合のみ表示
