# 画面設計書 239-タスク一覧

## 概要

本ドキュメントは、全タスクを一覧表示するListRecordsタイプの画面設計書です。全プロジェクト横断でのタスク管理、プリセットビュー（タブ）による絞り込み、統計ウィジェットによる概要把握を提供します。

### 本画面の処理概要

**業務上の目的・背景**：タスク一覧画面は、組織全体のタスクを俯瞰するための画面です。プロジェクト横断でのタスク管理、自分のタスクの確認、未割当タスクの把握、タスクの進捗状況の確認等を行います。統計ウィジェットにより、タスクの全体状況を数値で把握できます。

**画面へのアクセス方法**：メインナビゲーションの「プロジェクト」メニューから「タスク」を選択、またはダッシュボードからアクセスできます。

**主要な操作・処理内容**：
1. タスク一覧の表示（テーブル形式）
2. プリセットビュー（オープン、マイタスク、未割当、プライベート、フォロー中、クローズ、スター付き、アーカイブ）による絞り込み
3. 統計ウィジェットによる概要表示
4. 新規タスク作成画面への遷移
5. タスク詳細画面・編集画面への遷移
6. タスクの削除・復元・完全削除
7. 優先度・状態のインライン切替

**画面遷移**：
- 遷移先：タスク作成画面、タスク詳細画面、タスク編集画面

**権限による表示制御**：タスクリソースに対する各権限に基づき、対応するアクションの表示・非表示が制御されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TASK-001 | タスク一覧 | 主機能 | タスクの一覧表示・管理 |
| FN-TASK-002 | タスク作成 | 遷移先機能 | 作成ボタンからの遷移 |
| FN-TASK-004 | タスク表示 | 遷移先機能 | 行アクションからの遷移 |
| FN-TASK-003 | タスク編集 | 遷移先機能 | 行アクションからの遷移 |

## 画面種別

一覧

## URL/ルーティング

`/admin/project/tasks`

## 画面構成

- ヘッダーウィジェット領域
  - StatsOverviewWidget（統計ウィジェット）
- ヘッダー領域
  - 画面タイトル
  - 作成ボタン（CreateAction）
- プリセットビュー（タブ）領域
  - オープンタスク、マイタスク、未割当タスク、プライベートタスク、フォロー中タスク、クローズドタスク、スター付きタスク、アーカイブ済みタスク
- テーブル領域
  - データテーブル（フィルタ、ソート、グループ化、列管理対応）
  - 行アクション（表示・編集・復元・削除・完全削除）
  - 一括アクション（復元・削除・完全削除）

## 入出力項目

本画面は一覧表示画面のため、直接の入力項目はありません（フィルタ条件を除く）。

## 表示項目

### 統計ウィジェット

StatsOverviewWidgetによりタスクの統計情報が表示されます。

### テーブル列

| 項目名 | 表示形式 | ソート | 検索 | 説明 |
|--------|----------|--------|------|------|
| ID | テキスト | ○ | ○ | タスクID（初期非表示） |
| 優先度（priority） | アイコン | - | - | スターアイコン（クリックで切替可） |
| 状態（state） | アイコン | ○ | - | タスク状態アイコン（クリックで更新モーダル表示） |
| タイトル（title） | テキスト | ○ | ○ | タスクのタイトル |
| プロジェクト（project.name） | テキスト | ○ | ○ | 関連プロジェクト（プライベートタスクの場合はプレースホルダー表示） |
| マイルストーン（milestone.name） | テキスト | ○ | ○ | 関連マイルストーン（初期非表示） |
| 顧客（partner.name） | テキスト | ○ | ○ | 関連顧客（初期非表示） |
| 担当者（users.name） | テキスト | ○ | ○ | 割当ユーザー（複数） |
| 割当時間（allocated_hours） | 数値 | ○ | - | 割り当てられた時間（サマリー付き、初期非表示） |
| 費やした時間（total_hours_spent） | 数値 | ○ | - | 実績時間（サマリー付き） |
| 残時間（remaining_hours） | 数値 | ○ | - | 残り時間（サマリー付き、初期非表示） |
| 進捗（progress） | プログレスバー | ○ | - | 進捗率（色分け表示） |
| 期日（deadline） | 日時 | ○ | - | タスクの期日 |
| タグ（tags.name） | バッジ | - | - | タスクタグ（色付き） |
| ステージ（stage.name） | テキスト | ○ | - | タスクステージ |

## イベント仕様

### 01-作成ボタン押下

ヘッダーの作成ボタンをクリックすると、タスク作成画面（CreateTask）へ遷移します。

### 02-表示アクション押下

行の表示アクションをクリックすると、タスク詳細画面（ViewTask）へ遷移します。削除済みタスクでは非表示です。

### 03-編集アクション押下

行の編集アクションをクリックすると、タスク編集画面（EditTask）へ遷移します。削除済みタスクでは非表示です。

### 04-削除アクション押下

行の削除アクションをクリックすると、確認ダイアログが表示されます。確認後、タスクをソフトデリートします。

### 05-復元アクション押下

行の復元アクションをクリックすると、ソフトデリートされたタスクを復元します。

### 06-完全削除アクション押下

行の完全削除アクションをクリックすると、タスクを物理削除します。

### 07-優先度アイコン押下

priorityのスターアイコンをクリックすると、優先度が即座に切り替わります。

### 08-状態アイコン押下

stateのアイコンをクリックすると、状態更新モーダルが表示されます。新しい状態を選択して更新できます。

### 09-プリセットビュー切替

プリセットビュー（タブ）をクリックすると、対応するフィルタ条件でタスク一覧が絞り込まれます。

### 10-一括アクション

チェックボックスで選択したタスクに対して、一括復元・一括削除・一括完全削除を実行できます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 優先度アイコン押下 | projects_tasks | UPDATE | priorityの切替 |
| 状態アイコン押下 | projects_tasks | UPDATE | stateの更新 |
| 削除アクション押下 | projects_tasks | UPDATE | ソフトデリート |
| 復元アクション押下 | projects_tasks | UPDATE | deleted_atのクリア |
| 完全削除アクション押下 | projects_tasks | DELETE | 物理削除 |
| 一括削除 | projects_tasks | UPDATE | 複数タスクのソフトデリート |
| 一括復元 | projects_tasks | UPDATE | 複数タスクの復元 |
| 一括完全削除 | projects_tasks | DELETE | 複数タスクの物理削除 |

### テーブル別更新項目詳細

#### projects_tasks

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | priority | !current_value | 優先度トグル時 |
| UPDATE | state | 選択された状態 | 状態更新時 |
| UPDATE | deleted_at | 現在日時 | 削除時 |
| UPDATE | deleted_at | NULL | 復元時 |
| DELETE | - | WHERE id = {record_id} | 完全削除時 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| actions.restore.notification.title | 成功 | タスクが復元されました | 復元成功時 |
| actions.restore.notification.body | 成功 | タスクが正常に復元されました | 復元成功時 |
| actions.delete.notification.title | 成功 | タスクが削除されました | 削除成功時 |
| actions.delete.notification.body | 成功 | タスクが正常に削除されました | 削除成功時 |
| actions.force-delete.notification.title | 成功 | タスクが完全に削除されました | 完全削除成功時 |
| actions.force-delete.notification.body | 成功 | タスクが完全に削除されました | 完全削除成功時 |
| bulk-actions.restore.notification.title | 成功 | タスクが一括復元されました | 一括復元成功時 |
| bulk-actions.delete.notification.title | 成功 | タスクが一括削除されました | 一括削除成功時 |
| bulk-actions.force-delete.notification.title | 成功 | タスクが一括完全削除されました | 一括完全削除成功時 |

## 例外処理

| 例外種別 | 発生条件 | 対応処理 |
|---------|---------|---------|
| AuthorizationException | アクセス権限がない場合 | 403エラーページを表示 |

## 備考

- ListRecordsクラスを継承
- HasTableViewsトレイトを使用し、プリセットビュー（タブ）機能を実現
- ヘッダーウィジェットとしてStatsOverviewWidgetを表示
- プリセットビューの定義：
  - オープンタスク：state NOT IN (CANCELLED, DONE)（デフォルト）
  - マイタスク：usersリレーションでuser_id = Auth::id()
  - 未割当タスク：usersリレーションが空
  - プライベートタスク：project_id IS NULL
  - フォロー中タスク：followersリレーションでpartner_id = Auth::user()->partner_id
  - クローズドタスク：state IN (CANCELLED, DONE)
  - スター付きタスク：priority = true
  - アーカイブ済み：onlyTrashed()
- クエリはparent_id IS NULLでフィルタ（親タスクのみ表示）
- 列管理機能（columnManagerColumns: 2）で表示列をカスタマイズ可能
- 列の並び替え機能（reorderableColumns）対応
- 時間関連列はTimeSettings.enable_timesheets=trueの場合のみ表示
- マイルストーン列はTaskSettings.enable_milestones=trueの場合のみ表示
- フィルタはQueryBuilderでモーダル・スライドオーバー形式
- カスタムフィールド機能（HasCustomFields）をサポート
