# 画面設計書 24-インコタームズ一覧

## 概要

本ドキュメントは、Aureus ERPシステムにおけるインコタームズ一覧画面の設計仕様を定義します。インコタームズ（Incoterms）は国際商業会議所（ICC）が策定した国際貿易条件であり、売主と買主の間の責任、リスク、費用の分担を定義します。

### 本画面の処理概要

**業務上の目的・背景**：
インコタームズは国際貿易において、商品の引渡し条件や費用・リスクの負担範囲を明確に定義するために使用されます。例えばFOB（本船渡し）、CIF（運賃保険料込み）、EXW（工場渡し）などがあります。この一覧画面では、システムで使用可能なインコタームズを管理し、請求書や取引明細で参照できるようにします。

**画面へのアクセス方法**：
1. サイドメニューから「会計」モジュールを選択
2. 設定メニューから「インコタームズ」を選択

**主要な操作・処理内容**：
1. インコタームズの一覧表示
2. 新規インコタームズの作成（モーダル）
3. 既存インコタームズの編集（モーダル）
4. インコタームズの削除
5. 削除済みインコタームズの復元
6. 一括削除、一括完全削除、一括復元

**画面遷移**：
- 遷移元：会計モジュールのメニュー
- 遷移先：なし（モーダル操作のため同一画面内で完結）

**権限による表示制御**：
会計モジュールへのアクセス権限を持つユーザーのみがこの画面にアクセスできます。作成・編集・削除操作には適切な権限が必要です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-ACC-026 | インコタームズ管理 | 主機能 | インコタームズのCRUD操作 |
| SCR-ACC-001 | InvoiceResource | 参照機能 | 請求書でのインコタームズ参照 |

## 画面種別

一覧（List）

## URL/ルーティング

`/admin/accounts/inco-terms`

## 画面構成

- ヘッダーアクション
  - 作成ボタン（CreateAction）- アイコン付き
- テーブル
  - コード（code）カラム
  - 名称（name）カラム
  - 作成者（createdBy.name）カラム
  - 行アクション（表示・編集・削除・復元）
- ツールバーアクション
  - 一括アクショングループ（削除・完全削除・復元）
- モーダルフォーム（作成・編集時）

## 入出力項目

### フォーム項目（作成・編集モーダル）

| 項目名 | 項目ID | 入力/出力 | データ型 | 必須 | 初期値 | バリデーション | 備考 |
|--------|--------|----------|----------|------|--------|----------------|------|
| 作成者ID | creator_id | 隠し | integer | ○ | Auth::id() | - | 自動設定 |
| コード | code | 入力 | string | ○ | - | maxLength:3 | 3文字以内 |
| 名称 | name | 入力 | string | ○ | - | - | インコタームズ名 |

## 表示項目

### テーブル表示項目

| 項目名 | 項目ID | データ型 | 表示形式 | ソート | 検索 |
|--------|--------|----------|----------|--------|------|
| コード | code | string | テキスト | ○ | ○ |
| 名称 | name | string | テキスト | ○ | ○ |
| 作成者 | createdBy.name | string | テキスト | ○ | ○ |

### 詳細表示項目（Infolist）

| 項目名 | 項目ID | データ型 | 表示形式 |
|--------|--------|----------|----------|
| コード | code | string | テキスト |
| 名称 | name | string | テキスト |

## イベント仕様

### 1-作成ボタン押下

1. 作成モーダルフォームを表示
2. フォーム入力後、保存ボタン押下
3. creator_idに現在ユーザーIDを自動設定
4. データベースに新規レコードを挿入
5. 成功通知を表示
6. テーブルを更新

### 2-編集ボタン押下（行アクション）

1. 編集モーダルフォームを表示（既存データをプリロード）
2. フォーム編集後、保存ボタン押下
3. データベースを更新
4. 成功通知を表示
5. テーブルを更新

### 3-削除ボタン押下（行アクション）

1. 確認ダイアログ表示
2. ユーザーが確認した場合、ソフトデリート実行
3. 成功通知を表示
4. テーブルを更新

### 4-復元ボタン押下（行アクション）

1. 削除済みレコードを復元
2. 成功通知を表示
3. テーブルを更新

### 5-一括削除

1. 選択された複数レコードを一括でソフトデリート
2. 成功通知を表示
3. テーブルを更新

### 6-一括完全削除

1. 選択された複数レコードを物理削除
2. 成功通知を表示
3. テーブルを更新

### 7-一括復元

1. 選択された複数の削除済みレコードを一括復元
2. 成功通知を表示
3. テーブルを更新

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 画面表示 | incoterms | SELECT | インコタームズ一覧の取得 |
| 作成ボタン押下 | incoterms | INSERT | 新規インコタームズの作成 |
| 編集ボタン押下 | incoterms | UPDATE | インコタームズの更新 |
| 削除ボタン押下 | incoterms | UPDATE | deleted_atを設定（ソフトデリート） |
| 復元ボタン押下 | incoterms | UPDATE | deleted_atをnullに設定 |
| 一括完全削除 | incoterms | DELETE | 物理削除 |

### テーブル別更新項目詳細

#### incoterms

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | code | フォーム入力値 | 必須、3文字以内 |
| INSERT | name | フォーム入力値 | 必須 |
| INSERT | creator_id | Auth::id() | 自動設定 |
| INSERT | created_at | 現在日時 | 自動設定 |
| UPDATE | code | フォーム入力値 | 必須、3文字以内 |
| UPDATE | name | フォーム入力値 | 必須 |
| UPDATE | updated_at | 現在日時 | 自動更新 |
| SOFT DELETE | deleted_at | 現在日時 | ソフトデリート |
| RESTORE | deleted_at | null | 復元 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|--------------|----------|
| list-inco-term.header-actions.notification.title | 成功 | 作成成功タイトル | 作成処理成功時 |
| list-inco-term.header-actions.notification.body | 成功 | 作成成功メッセージ本文 | 作成処理成功時 |
| incoterm.table.actions.edit.notification.title | 成功 | 編集成功タイトル | 編集処理成功時 |
| incoterm.table.actions.edit.notification.body | 成功 | 編集成功メッセージ本文 | 編集処理成功時 |
| incoterm.table.actions.delete.notification.title | 成功 | 削除成功タイトル | 削除処理成功時 |
| incoterm.table.actions.delete.notification.body | 成功 | 削除成功メッセージ本文 | 削除処理成功時 |
| incoterm.table.actions.restore.notification.title | 成功 | 復元成功タイトル | 復元処理成功時 |
| incoterm.table.actions.restore.notification.body | 成功 | 復元成功メッセージ本文 | 復元処理成功時 |
| incoterm.table.bulk-actions.delete.notification.title | 成功 | 一括削除成功タイトル | 一括削除成功時 |
| incoterm.table.bulk-actions.delete.notification.body | 成功 | 一括削除成功メッセージ | 一括削除成功時 |
| incoterm.table.bulk-actions.force-delete.notification.title | 成功 | 完全削除成功タイトル | 完全削除成功時 |
| incoterm.table.bulk-actions.force-delete.notification.body | 成功 | 完全削除成功メッセージ | 完全削除成功時 |
| incoterm.table.bulk-actions.restore.notification.title | 成功 | 一括復元成功タイトル | 一括復元成功時 |
| incoterm.table.bulk-actions.restore.notification.body | 成功 | 一括復元成功メッセージ | 一括復元成功時 |

## 例外処理

| 例外種別 | 発生条件 | 対処方法 |
|---------|---------|---------|
| 権限不足 | 操作権限がないユーザーがアクセス | 403エラーまたはリダイレクト |
| バリデーションエラー | コードが3文字を超えるなど | フォームにエラーメッセージを表示 |
| 重複エラー | 同一コードが既に存在する場合 | エラーメッセージを表示 |

## 備考

- 本画面はFilament PHPのListRecordsページを継承して実装されている
- モデルはIncoterm（ソフトデリート対応）
- ナビゲーションアイコンは`heroicon-o-globe-alt`
- shouldRegisterNavigationがfalseのため、直接のナビゲーション登録はされていない
- ソフトデリート対応のため、削除済みレコードの復元が可能
- コードは国際標準のインコタームズコード（FOB、CIF、EXW等）を想定
