# 画面設計書 240-タスク作成

## 概要

本ドキュメントは、新規タスクを作成するための画面設計書です。タスクの基本情報、プロジェクト関連情報、担当者、期日、時間配分等を入力し、タスクを登録します。

### 本画面の処理概要

**業務上の目的・背景**：タスク作成は、プロジェクトの作業単位を登録するための機能です。本画面では、タスクのタイトル、状態、説明、プロジェクト関連付け、マイルストーン、顧客、担当者、期日、時間配分等を設定します。適切なタスク登録により、チームメンバーへの作業割当、進捗管理、時間管理の基盤を構築します。

**画面へのアクセス方法**：タスク一覧画面（ListTasks）の「作成」ボタン、またはプロジェクトタスク管理画面（ManageTasks）の「作成」ボタンからアクセスできます。

**主要な操作・処理内容**：
1. タスク基本情報の入力（タイトル、状態、タグ、説明）
2. タスクステージの選択（ステッパー形式）
3. 設定情報の入力（プロジェクト、マイルストーン、顧客、担当者、期日、時間配分）
4. タスクの保存

**画面遷移**：
- 遷移元：タスク一覧画面（ListTasks）、プロジェクトタスク管理画面（ManageTasks）
- 遷移先：タスク詳細画面（ViewTask）- 作成成功後

**権限による表示制御**：タスクリソースに対する「create」権限を持つユーザーのみがアクセス可能です。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-TASK-002 | タスク作成 | 主機能 | 新規タスクの登録 |
| FN-TASK-001 | タスク一覧 | 遷移元機能 | 一覧からの遷移元 |
| FN-PROJ-005 | タスク管理 | 遷移元機能 | プロジェクト管理からの遷移元 |
| FN-TASK-004 | タスク表示 | 遷移先機能 | 作成成功後の遷移先 |

## 画面種別

作成

## URL/ルーティング

`/admin/project/tasks/create`

## 画面構成

- メインコンテンツ領域（3カラムレイアウト）
  - 左側（2カラム分）
    - タスクステージセレクター（ProgressStepper）
    - 一般情報セクション
    - 追加情報セクション（カスタムフィールドがある場合）
  - 右側（1カラム分）
    - 設定セクション

## 入出力項目

### 一般情報セクション

| 項目名 | 項目ID | 入力種別 | 必須 | 最大長 | 初期値 | 説明 |
|--------|--------|----------|------|--------|--------|------|
| タイトル | title | テキスト | ○ | 255 | - | タスクのタイトル |
| 状態 | state | トグルボタン | ○ | - | IN_PROGRESS | IN_PROGRESS/CHANGES_REQUESTED/APPROVED/CANCELLED/DONE |
| タグ | tags | マルチセレクト | - | - | - | タスクタグ（複数選択可、新規作成可） |
| 説明 | description | リッチエディタ | - | - | - | タスクの詳細説明 |

### タスクステージ

| 項目名 | 項目ID | 入力種別 | 必須 | 初期値 | 説明 |
|--------|--------|----------|------|--------|------|
| ステージ | stage_id | ProgressStepper | ○ | 最初のステージ | タスクの進行ステージ |

### 設定セクション

| 項目名 | 項目ID | 入力種別 | 必須 | 表示条件 | 説明 |
|--------|--------|----------|------|----------|------|
| プロジェクト | project_id | セレクト | - | 常時 | 関連プロジェクト（新規作成可、削除済み選択不可） |
| マイルストーン | milestone_id | セレクト | - | プロジェクト選択済かつマイルストーン有効時 | 関連マイルストーン（プロジェクト連動、新規作成可） |
| 顧客 | partner_id | セレクト | - | 常時 | 関連顧客（新規作成・編集可） |
| 担当者 | users | マルチセレクト | - | 常時 | 割当ユーザー（複数選択可、新規作成可） |
| 期日 | deadline | 日時選択 | - | 常時 | タスクの期日 |
| 割当時間 | allocated_hours | 数値 | - | タイムシート有効時 | 予定時間（0以上） |

## 表示項目

本画面は作成画面のため、表示専用項目はありません。

## イベント仕様

### 01-保存ボタン押下

フォームの保存ボタンをクリックすると、入力内容のバリデーションを実施し、タスクを作成します。作成前にcreator_idが現在のログインユーザーIDに自動設定されます。作成成功後、タスク詳細画面（ViewTask）へリダイレクトします。

### 02-キャンセルボタン押下

キャンセルボタンをクリックすると、タスク一覧画面へ戻ります。

### 03-プロジェクト選択変更

プロジェクトを選択/変更すると、以下の処理が実行されます：
1. milestone_idがnullにリセット
2. partner_idがプロジェクトの顧客に自動設定

### 04-プロジェクト新規作成

セレクトボックスから「新規作成」を選択すると、プロジェクト作成フォームがモーダル表示されます。

### 05-マイルストーン新規作成

セレクトボックスから「新規作成」を選択すると、マイルストーン作成フォームがモーダル表示されます。選択中のプロジェクトが自動設定されます。

### 06-顧客新規作成・編集

セレクトボックスから「新規作成」または「編集」を選択すると、パートナー作成/編集フォームがモーダル表示されます。

### 07-担当者新規作成

セレクトボックスから「新規作成」を選択すると、ユーザー作成フォームがモーダル表示されます。

### 08-タグ新規作成

セレクトボックスから「新規作成」を選択すると、タグ作成フォーム（名前、色）がモーダル表示されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | projects_tasks | INSERT | 新規タスクの登録 |
| 保存ボタン押下 | projects_task_tag | INSERT | タスクとタグの関連付け |
| 保存ボタン押下 | projects_task_user | INSERT | タスクとユーザーの関連付け |

### テーブル別更新項目詳細

#### projects_tasks

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | title | フォーム入力値 | 必須 |
| INSERT | state | フォーム選択値 | デフォルト: IN_PROGRESS |
| INSERT | description | フォーム入力値 | 任意 |
| INSERT | stage_id | フォーム選択値 | 必須 |
| INSERT | project_id | フォーム選択値 | 任意（プライベートタスクの場合null） |
| INSERT | milestone_id | フォーム選択値 | 任意 |
| INSERT | partner_id | フォーム選択値 | 任意 |
| INSERT | deadline | フォーム入力値 | 任意 |
| INSERT | allocated_hours | フォーム入力値 or 0 | dehydrateStateUsing適用 |
| INSERT | creator_id | Auth::id() | 自動設定 |

#### projects_task_tag

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | task_id | 作成されたタスクID | - |
| INSERT | tag_id | 選択されたタグID | タグ数分レコード作成 |

#### projects_task_user

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | task_id | 作成されたタスクID | - |
| INSERT | user_id | 選択されたユーザーID | ユーザー数分レコード作成 |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|----------|
| notification.title | 成功 | タスクが作成されました | 作成成功時 |
| notification.body | 成功 | タスクが正常に作成されました | 作成成功時 |

## 例外処理

| 例外種別 | 発生条件 | 対応処理 |
|---------|---------|---------|
| ValidationException | 必須項目未入力、バリデーションエラー | フォームにエラーメッセージを表示 |
| AuthorizationException | create権限がない場合 | 403エラーページを表示 |

## 備考

- ProgressStepperコンポーネントを使用し、ステージ選択をビジュアル化
- 状態（state）はToggleButtonsで視覚的に選択
- 状態の選択肢：IN_PROGRESS（進行中）、CHANGES_REQUESTED（変更要求）、APPROVED（承認済み）、CANCELLED（キャンセル）、DONE（完了）
- プロジェクト選択はwithTrashed()で削除済みプロジェクトも表示（ただし選択不可）
- プロジェクト未選択の場合、プライベートタスクとして扱われる
- マイルストーン選択はプロジェクト選択に連動し、対象プロジェクトのマイルストーンのみ表示
- マイルストーン選択はプロジェクトのallow_milestones設定とTaskSettings.enable_milestonesに依存
- 割当時間フィールドはTimeSettings.enable_timesheets=trueの場合のみ表示
- 割当時間はnullの場合0に変換（dehydrateStateUsing）
- カスタムフィールドがある場合、追加情報セクションとして表示
- タグ作成時は名前と色（デフォルト:#808080）を設定可能
