# 画面設計書 241-タスク編集

## 概要

本ドキュメントは、Aureus ERPシステムのプロジェクト管理モジュールにおける「タスク編集」画面の設計書です。

### 本画面の処理概要

本画面は、既存のタスク情報を編集するための画面です。タスクの基本情報（タイトル、状態、説明、タグ）や設定情報（プロジェクト、マイルストーン、顧客、担当者、期限、割り当て時間）を更新することができます。

**業務上の目的・背景**：プロジェクト管理において、タスクの進捗状況や詳細情報は時間の経過とともに変化します。担当者の変更、期限の延長、状態の更新など、タスクに関する情報を柔軟に変更できることは、プロジェクトを成功に導くために不可欠です。本画面は、そのようなタスク情報の更新を効率的に行うためのインターフェースを提供します。

**画面へのアクセス方法**：
1. サイドメニューから「プロジェクト」→「タスク」を選択
2. タスク一覧画面で編集したいタスクの行アクションメニューから「編集」を選択
3. または、タスク詳細画面のサブナビゲーションから「編集」タブを選択

**主要な操作・処理内容**：
1. タスクステージの変更（ProgressStepper）
2. タイトル・説明の編集
3. 状態（進行中/変更/完了/キャンセル）の変更
4. タグの追加・削除・新規作成
5. プロジェクトの変更（関連するマイルストーン・顧客も自動更新）
6. マイルストーンの変更
7. 顧客（パートナー）の変更
8. 担当者（ユーザー）の追加・削除
9. 期限の変更
10. 割り当て時間の設定（タイムシート機能有効時）
11. Chatterアクションによるコメント・アクティビティ管理
12. タスクの削除

**画面遷移**：
- 遷移元：タスク一覧画面、タスク詳細画面
- 遷移先：タスク詳細画面（保存後リダイレクト）、タスク一覧画面（削除後）

**権限による表示制御**：
- タスクの編集権限を持つユーザーのみアクセス可能
- マイルストーンフィールドはTaskSettings.enable_milestonesが有効かつプロジェクトでallow_milestonesが有効な場合のみ表示
- 割り当て時間フィールドはTimeSettings.enable_timesheetsが有効な場合のみ表示

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| FN-PROJ-010 | タスク編集 | 主機能 | タスク情報の編集と保存 |
| FN-PROJ-008 | タスク一覧 | 遷移元機能 | タスク一覧からの編集画面へのアクセス |
| FN-PROJ-011 | タスク表示 | 遷移元/遷移先機能 | 詳細画面からの編集と保存後のリダイレクト |
| FN-PROJ-001 | プロジェクト一覧 | 補助機能 | プロジェクト選択時の参照 |

## 画面種別

編集

## URL/ルーティング

`/admin/project/tasks/{record}/edit`

## 画面構成

- ヘッダーアクション
  - Chatterアクション（コメント・アクティビティ管理）
  - 削除アクション
- サブナビゲーション（Top位置）
  - 詳細、編集、タイムシート、サブタスク
- メインコンテンツ（3カラムレイアウト）
  - 左側2カラム
    - ProgressStepper（ステージ選択）
    - 一般情報セクション
      - タイトル入力
      - 状態切り替えボタン
      - タグ選択
      - 説明リッチエディタ
    - 追加情報セクション（カスタムフィールド）
  - 右側1カラム
    - 設定セクション
      - プロジェクト選択
      - マイルストーン選択
      - 顧客選択
      - 担当者選択
      - 期限入力
      - 割り当て時間入力

## 入出力項目

| 項目名 | 項目ID | データ型 | 必須 | 入力形式 | 備考 |
|--------|--------|----------|------|----------|------|
| ステージ | stage_id | integer | Yes | ProgressStepper | TaskStageから選択 |
| タイトル | title | string | Yes | テキスト入力 | 最大255文字、フォントサイズ大 |
| 状態 | state | enum | Yes | ToggleButtons | IN_PROGRESS/CHANGES/DONE/CANCELLED |
| タグ | tags | array | No | 複数選択 | 新規作成可能 |
| 説明 | description | text | No | RichEditor | HTML形式 |
| プロジェクト | project_id | integer | No | 選択 | 変更時にマイルストーン・顧客リセット |
| マイルストーン | milestone_id | integer | No | 選択 | プロジェクト依存、条件付き表示 |
| 顧客 | partner_id | integer | No | 選択 | 新規作成・編集可能 |
| 担当者 | users | array | No | 複数選択 | ユーザー選択、新規作成可能 |
| 期限 | deadline | datetime | No | 日時ピッカー | カレンダーアイコン付き |
| 割り当て時間 | allocated_hours | float | No | 数値入力 | 0以上、条件付き表示 |

## 表示項目

| 項目名 | データ取得元 | 表示形式 | 備考 |
|--------|-------------|----------|------|
| サブナビゲーション | ページ構成 | タブ形式 | 詳細/編集/タイムシート/サブタスク |
| ステージオプション | TaskStage::orderBy('sort') | ステップ形式 | ソート順で表示 |
| タグオプション | tags relationship | バッジ | 名前と色を表示 |
| プロジェクトオプション | Project (with trashed) | セレクト | 削除済みは選択不可表示 |
| マイルストーンオプション | Milestone (project filtered) | セレクト | 選択プロジェクトで絞り込み |
| 顧客オプション | Partner | セレクト | 検索可能 |
| ユーザーオプション | User | 複数セレクト | 検索可能 |

## イベント仕様

### 1-保存ボタン押下

タスク情報をデータベースに保存し、成功通知を表示後、タスク詳細画面にリダイレクトします。

処理フロー：
1. 入力値のバリデーション
2. projects_tasksテーブルの更新
3. projects_task_tagテーブルの同期（タグ）
4. projects_task_usersテーブルの同期（担当者）
5. 関連するtimesheetsテーブルの更新（project_id, partner_id, company_id）
6. 成功通知の表示
7. タスク詳細画面へリダイレクト

### 2-削除アクション

ヘッダーの削除アクションをクリックすると、確認後にタスクを論理削除します。

### 3-Chatterアクション

コメントの追加やアクティビティプランの実行が可能です。

### 4-プロジェクト変更時

プロジェクトを変更すると、マイルストーンがリセットされ、顧客がプロジェクトの顧客に自動設定されます。

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| 保存ボタン押下 | projects_tasks | UPDATE | タスク情報の更新 |
| 保存ボタン押下 | projects_task_tag | SYNC | タグ関連の同期 |
| 保存ボタン押下 | projects_task_users | SYNC | 担当者関連の同期 |
| 保存ボタン押下 | projects_timesheets | UPDATE | 関連タイムシートのプロジェクト等更新 |
| 削除アクション | projects_tasks | SOFT DELETE | タスクの論理削除 |

### テーブル別更新項目詳細

#### projects_tasks

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| UPDATE | title | フォーム入力値 | 必須 |
| UPDATE | state | フォーム選択値 | TaskState enum |
| UPDATE | description | フォーム入力値 | HTML形式 |
| UPDATE | stage_id | フォーム選択値 | ステージID |
| UPDATE | project_id | フォーム選択値 | プロジェクトID |
| UPDATE | milestone_id | フォーム選択値 | マイルストーンID |
| UPDATE | partner_id | フォーム選択値 | 顧客ID |
| UPDATE | deadline | フォーム入力値 | datetime |
| UPDATE | allocated_hours | フォーム入力値、未入力時0 | float |
| UPDATE | updated_at | 現在日時 | 自動更新 |

#### projects_task_tag

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SYNC | task_id | レコードID | 中間テーブル |
| SYNC | tag_id | 選択されたタグID | 中間テーブル |

#### projects_task_users

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| SYNC | task_id | レコードID | 中間テーブル |
| user_id | 選択されたユーザーID | 中間テーブル |

## メッセージ仕様

| メッセージ種別 | メッセージ内容 | 表示条件 |
|--------------|---------------|---------|
| 成功通知 | タスクが正常に更新されました | 保存成功時 |
| 成功通知（削除） | タスクが正常に削除されました | 削除成功時 |
| バリデーションエラー | タイトルは必須です | タイトル未入力時 |
| バリデーションエラー | 割り当て時間は0以上の数値を入力してください | 不正な数値入力時 |

## 例外処理

| 例外パターン | 処理内容 | 表示メッセージ |
|------------|----------|---------------|
| レコード未存在 | 404エラーページ表示 | ページが見つかりません |
| 権限不足 | 403エラーページ表示 | アクセス権限がありません |
| バリデーションエラー | フォームエラー表示 | 各フィールドにエラーメッセージ |
| データベースエラー | エラー通知表示 | 更新に失敗しました |

## 備考

- EditRecordクラスを継承したFilament標準の編集画面実装
- 保存後のリダイレクト先はタスク詳細画面（ViewTask）
- サブナビゲーションはページ上部（Top位置）に表示
- プロジェクト選択では論理削除されたプロジェクトも表示されるが選択不可（Deleted表示）
- カスタムフィールド機能により、追加フィールドの表示が可能
